/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ModelDoor;
import net.comcraft.src.World;

public class BlockDoor
extends Block {
    private int indexTop;
    private int indexBottom;

    public BlockDoor(int id, int indexTop, int indexBottom) {
        super(id);
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
    }

    public boolean doesBlockDestroyGrass() {
        return false;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return true;
    }

    public boolean isNormal() {
        return false;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexTop, this.indexBottom};
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world == null) {
            return this.indexTop;
        }
        if (this.getDoorSide(world, x, y, z) == 4) {
            return this.indexBottom;
        }
        return this.indexTop;
    }

    public Transform getBlockTransform(World world, int x, int y, int z, Transform transform, int side) {
        if (world == null) {
            return transform;
        }
        Transform blockTransform = new Transform();
        blockTransform.set(transform);
        if (this.isDoorOpended(world, x, y, z)) {
            if (this.getDoorSide(world, x, y, z) == 5) {
                --y;
            }
            if (!world.isAirBlock(x - 1, y, z) && !world.isAirBlock(x + 1, y, z) || world.getBlockID(x - 1, y, z) == this.blockID) {
                blockTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
                blockTransform.postTranslate(-10.0f, 0.0f, 5.0f);
            } else if (world.getBlockID(x + 1, y, z) == this.blockID) {
                blockTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
                blockTransform.postTranslate(-10.0f, 0.0f, -5.0f);
            } else if (world.getBlockID(x, y, z + 1) == this.blockID) {
                blockTransform.postTranslate(0.0f, 0.0f, -5.0f);
            } else {
                blockTransform.postTranslate(0.0f, 0.0f, 5.0f);
            }
            if (this.getDoorSide(world, x, y, z) == 5) {
                ++y;
            }
        } else {
            if (this.getDoorSide(world, x, y, z) == 5) {
                --y;
            }
            if ((world.isAirBlock(x - 1, y, z) || world.isAirBlock(x + 1, y, z)) && world.getBlockID(x - 1, y, z) != this.blockID && world.getBlockID(x + 1, y, z) != this.blockID) {
                blockTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
                blockTransform.postTranslate(-10.0f, 0.0f, 0.0f);
            }
            if (this.getDoorSide(world, x, y, z) == 5) {
                ++y;
            }
        }
        return blockTransform;
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        int side = this.getDoorSide(world, x, y, z);
        boolean value = !this.isDoorOpended(world, x, y, z);
        world.setBlockMetadata(x, y, z, this.getDoorMetadataToSave(side, value));
        if (side == 4) {
            world.setBlockMetadata(x, y + 1, z, this.getDoorMetadataToSave(this.getDoorSide(world, x, y + 1, z), value));
        } else if (side == 5) {
            world.setBlockMetadata(x, y - 1, z, this.getDoorMetadataToSave(this.getDoorSide(world, x, y - 1, z), value));
        }
        return true;
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
        int side = this.getDoorSide(world, x, y, z);
        if (side == 4) {
            world.setBlockID(x, y + 1, z, 0);
        } else if (side == 5) {
            world.setBlockID(x, y - 1, z, 0);
        }
    }

    private int getDoorMetadataToSave(int side, boolean opended) {
        return side | (opended ? 16 : 0);
    }

    private int getDoorSide(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) & 0xF;
    }

    private boolean isDoorOpended(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) >> 4 == 1;
    }

    public void onBlockPlaced(World world, int x, int y, int z, int side) {
        if (super.canPlaceBlockAt(world, x, y - 1, z)) {
            world.setBlockMetadata(x, y, z, this.getDoorMetadataToSave(5, false));
            world.setBlockAndMetadata(x, y - 1, z, this.blockID, this.getDoorMetadataToSave(4, false));
        } else if (super.canPlaceBlockAt(world, x, y + 1, z)) {
            world.setBlockMetadata(x, y, z, this.getDoorMetadataToSave(4, false));
            world.setBlockAndMetadata(x, y + 1, z, this.blockID, this.getDoorMetadataToSave(5, false));
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (this.isDoorOpended(world, x, y, z)) {
            if (this.getDoorSide(world, x, y, z) == 5) {
                --y;
            }
            if (!world.isAirBlock(x - 1, y, z) && !world.isAirBlock(x + 1, y, z) || world.getBlockID(x - 1, y, z) == this.blockID) {
                return AxisAlignedBB.getBoundingBox((float)x + 0.8f, y, z, x + 1, y + 1, z + 1);
            }
            if (world.getBlockID(x + 1, y, z) == this.blockID) {
                return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 0.2f, y + 1, z + 1);
            }
            if (world.getBlockID(x, y, z + 1) == this.blockID) {
                return AxisAlignedBB.getBoundingBox(x, y, z, x + 1, y + 1, (float)z + 0.2f);
            }
            return AxisAlignedBB.getBoundingBox(x, y, (float)z + 0.8f, x + 1, y + 1, z + 1);
        }
        return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
    }

    public int getRenderType() {
        return 5;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        return ModelDoor.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelDoor.indexBuffer;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!super.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        if (super.canPlaceBlockAt(world, x, y - 1, z)) {
            return true;
        }
        return super.canPlaceBlockAt(world, x, y + 1, z);
    }
}

