/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsException;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsObject;
import java.util.Hashtable;
import java.util.Vector;

public class EventHandler {
    private Hashtable events = new Hashtable();

    public EventHandler(String[] eventnames) {
        this();
        int i = 0;
        while (i < eventnames.length) {
            this.addEventName(eventnames[i]);
            ++i;
        }
    }

    public EventHandler() {
    }

    protected void addEventName(String name) {
        Vector[] v = new Vector[]{new Vector(), new Vector()};
        this.events.put(name, v);
    }

    public boolean hasEvent(String name) {
        return this.events.containsKey(name);
    }

    public void runEvent(String name, Object[] params) {
        this.runEvent(name, null, params);
    }

    public void runEvent(String name, JsObject thisPtr, Object[] params) {
        Vector[] event;
        if (!this.hasEvent(name)) {
            return;
        }
        if (params == null) {
            params = new Object[]{};
        }
        if ((event = (Vector[])this.events.get(name))[0].isEmpty()) {
            return;
        }
        Vector e = event[0];
        JsArray stack = new JsArray();
        int ce = 0;
        while (ce < e.size()) {
            JsFunction fn = (JsFunction)e.elementAt(ce);
            stack.setObject(0, (Object)(thisPtr != null ? thisPtr : fn));
            stack.setObject(1, (Object)fn);
            int i = 0;
            while (i < params.length) {
                if (params[i] instanceof Integer) {
                    stack.setInt(i + 2, (Integer)params[i]);
                } else if (params[i] instanceof Boolean) {
                    stack.setBoolean(i + 2, (Boolean)params[i]);
                } else {
                    stack.setObject(i + 2, params[i]);
                }
                ++i;
            }
            try {
                fn.eval(stack, 0, params.length);
                event[1].setElementAt(stack.getObject(0), ce);
            }
            catch (Exception e1) {
                System.err.println(e1.getMessage());
                e1.printStackTrace();
            }
            ++ce;
        }
    }

    public void runEvent(String name) {
        this.runEvent(name, null);
    }

    public void bindEvent(String name, JsFunction function) {
        if (name == null || function == null) {
            return;
        }
        if (!this.events.containsKey(name)) {
            throw new JsException((Object)("Unknown Event key " + name));
        }
        Vector[] e = (Vector[])this.events.get(name);
        e[0].addElement(function);
        e[1].addElement(null);
    }

    public boolean bindEventOnce(String name, JsFunction function) {
        if (!this.hasEvent(name)) {
            return false;
        }
        Vector fnlist = ((Vector[])this.events.get(name))[0];
        int i = 0;
        while (i < fnlist.size()) {
            if (((JsFunction)fnlist.elementAt(i)).equals(function)) {
                return false;
            }
            ++i;
        }
        this.bindEvent(name, function);
        return true;
    }

    public void setEvent(String name, JsFunction function) {
        if (name == null || function == null) {
            return;
        }
        if (!this.events.containsKey(name)) {
            throw new JsException((Object)("Unknown Event key " + name));
        }
        Vector[] e = (Vector[])this.events.get(name);
        e[0].removeAllElements();
        e[1].removeAllElements();
        e[0].addElement(function);
        e[1].addElement(null);
    }

    public Object getLastReturn(String name) {
        return ((Vector[])this.events.get(name))[1].lastElement();
    }

    public Object getLastSuccess(String name) {
        if (!this.hasEvent(name)) {
            return null;
        }
        Vector event = ((Vector[])this.events.get(name))[1];
        Object r = null;
        int i = 0;
        while (i < event.size()) {
            Object t = event.elementAt(i);
            if (t != null) {
                r = t;
            }
            ++i;
        }
        return r;
    }

    public Object getFirstSuccess(String name) {
        Vector event = ((Vector[])this.events.get(name))[1];
        int i = 0;
        while (i < event.size()) {
            Object r = event.elementAt(i);
            if (r != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public Object[] getSucesses(String name) {
        Vector event = ((Vector[])this.events.get(name))[1];
        Vector v = new Vector();
        int i = 0;
        while (i < event.size()) {
            Object r = event.elementAt(i);
            if (r != null) {
                v.addElement(r);
            }
            ++i;
        }
        Object[] arr = new Object[v.size()];
        v.copyInto(arr);
        return arr;
    }
}

