/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiSelectServer;
import net.comcraft.src.GuiTextBox;
import net.comcraft.src.GuiTextBoxHost;

public class GuiEditServer
extends GuiScreen
implements GuiTextBoxHost {
    private String name;
    private String ip;
    private GuiButton textbutton = null;
    private boolean isNew;
    private String[] selected;

    public GuiEditServer(GuiSelectServer parentScreen, String name, String ip, String[] selected) {
        super(parentScreen, "EditServer");
        this.name = name;
        this.ip = ip;
        this.isNew = selected == null;
        this.selected = selected;
    }

    protected void customDrawScreen() {
    }

    protected void initGui() {
        this.name = this.name != null ? this.name : this.cc.langBundle.getText("GuiEditServer.defaultName");
        int centerX = (Comcraft.screenWidth - GuiButton.getButtonWidth()) / 2;
        int startY = 30;
        int mul = GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6;
        this.elementsList.addElement(new GuiButton(this.cc, 0, centerX, startY, this.cc.langBundle.getText("GuiEditServer.buttonSave")));
        this.elementsList.addElement(new GuiButton(this.cc, 1, centerX, startY + mul * 2, this.name));
        this.elementsList.addElement(new GuiButton(this.cc, 2, centerX, startY + mul * 3, this.ip != null ? this.ip : "<" + this.cc.langBundle.getText("GuiEditServer.ipaddr") + ">"));
        this.elementsList.addElement(new GuiButton(this.cc, 3, centerX, startY + mul * 5, this.cc.langBundle.getText("GuiNewWorld.buttonClose")));
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.getId() == 0) {
            if (!this.name.equals("") && this.ip != null) {
                if (this.isNew) {
                    this.cc.serverLoader.addServer(this.name, this.ip);
                } else {
                    this.cc.serverLoader.editServer(this.selected, this.name, this.ip);
                }
                this.backToParentScreen();
            }
        } else if (guiButton.getId() == 1) {
            this.textbutton = guiButton;
            this.cc.displayGuiScreen(new GuiTextBox(this, this.name, 0, 64));
        } else if (guiButton.getId() == 2) {
            this.textbutton = guiButton;
            this.cc.displayGuiScreen(new GuiTextBox(this, this.ip, 0, 256));
        } else if (guiButton.getId() == 3) {
            this.backToParentScreen();
        }
    }

    public void guiTextBoxAction(String textBoxString) {
        if (textBoxString == null) {
            return;
        }
        this.textbutton.displayString = textBoxString;
        if (this.textbutton.getId() == 1) {
            this.name = textBoxString;
        } else if (this.textbutton.getId() == 2) {
            this.ip = textBoxString;
        }
    }
}

