/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.lcdui.Image;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiButtonMoveControl;
import net.comcraft.src.GuiButtonPictured;
import net.comcraft.src.GuiContainerInventory;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiQuickMenu;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiYesNoHost;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.Touch;

public class GuiInventory
extends GuiScreen
implements GuiYesNoHost {
    private GuiContainerInventory guiContainer;
    private Image inventoryImage;
    private int xInv;
    private int yInv;

    public GuiInventory() {
        super(null, "Inventory");
    }

    protected void drawDefaultBackground() {
    }

    protected void customDrawScreen() {
        this.cc.g.drawImage(this.inventoryImage, this.xInv, this.yInv, 20);
        this.guiContainer.drawContainer();
        if (!Touch.isTouchSupported()) {
            this.cc.g.setColor(0xFFFFFF);
            GuiElement.drawStringWithShadow(this.cc.g, this.cc.langBundle.getText("Ingame.quickMenuInfo"), 3, Comcraft.screenHeight - 3, 68);
        }
    }

    protected void initGui() {
        this.inventoryImage = this.cc.textureProvider.getImage("gui/inventory_" + (Touch.isTouchSupported() ? "landscape.png" : "normal.png"));
        if (Touch.isTouchSupported()) {
            this.xInv = (Comcraft.screenWidth - 3 - GuiButtonMoveControl.getButtonWidth() - 3) / 2 - this.inventoryImage.getWidth() / 2;
            this.yInv = Comcraft.screenHeight / 2 - this.inventoryImage.getHeight() / 2;
            this.elementsList.addElement(new GuiButtonPictured(this.cc, this, 0, Comcraft.screenWidth - GuiButtonPictured.getButtonWidth() - 3, Comcraft.screenHeight - GuiButtonPictured.getButtonHeight() - 3, "gui/button_exit.png", 5));
            this.elementsList.addElement(new GuiButtonPictured(this.cc, this, 1, Comcraft.screenWidth - GuiButtonPictured.getButtonWidth() - 3, 3, "gui/button_quick_menu.png", 5));
        } else {
            this.xInv = Comcraft.screenWidth / 2 - this.inventoryImage.getWidth() / 2;
            this.yInv = (Comcraft.screenHeight - 3 - GuiButtonMoveControl.getButtonHeight() - 3) / 2 - this.inventoryImage.getHeight() / 2 + 3 + GuiButtonMoveControl.getButtonHeight() + 3;
        }
        this.guiContainer = new GuiContainerInventory(this.cc, this, this.xInv + 5, this.yInv + 5);
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        this.eh.runEvent("handleGuiAction", this, new Object[]{guiButton});
        if (guiButton.getId() == 0) {
            this.touchMovedOrUp(Touch.getX(), Touch.getY());
            this.cc.endWorld();
        } else if (guiButton.getId() == 1) {
            this.touchMovedOrUp(Touch.getX(), Touch.getY());
            this.cc.displayGuiScreen(new GuiQuickMenu());
        }
    }

    protected void handleTouchInput() {
        if (!Touch.isInputHandled()) {
            super.handleTouchInput();
        }
    }

    protected void handleKeyboardInput() {
    }

    public void customHandleInput() {
        this.guiContainer.handleInput();
    }

    public void clickedItemStack(InvItemStack itemStack) {
        int index = this.cc.player.inventory.getSelectedElementNum();
        InvItemStack currStack = this.cc.player.inventory.getItemStackAt(index);
        if (currStack != null && currStack.equals(itemStack)) {
            ++currStack.stackSize;
            itemStack = currStack;
        }
        this.cc.player.inventory.setItemStackAt(index, itemStack);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void guiYesNoAction(boolean value) {
        if (value) {
            this.cc.endWorld();
        }
    }
}

