/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsException;
import com.google.minijoe.sys.JsFunction;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.comcraft.client.Comcraft;
import net.comcraft.src.EventHandler;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiButtonOnOff;
import net.comcraft.src.GuiButtonSelect;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiMainMenu;
import net.comcraft.src.Keyboard;
import net.comcraft.src.ModArray;
import net.comcraft.src.Touch;

public abstract class GuiScreen
extends GuiElement {
    protected EventHandler eh = new EventHandler(new String[]{"initGui", "handleGuiAction"});
    protected Comcraft cc;
    protected Vector elementsList;
    protected GuiButton selectedButton;
    protected GuiScreen parentScreen;
    private boolean isInitialized;
    private String GuiName = "Screen";
    private static final int ID_INIT_GUI = 101;
    private static final int ID_IS_GUI = 103;
    private static final int ID_ADD_ACTION_HANDLER = 105;

    public GuiScreen(GuiScreen parentScreen, String guiName) {
        this.GuiName = guiName;
        this.parentScreen = parentScreen;
        this.elementsList = new Vector(5);
        this.addNative("initGui", 101, -1);
        this.addNative("isGui", 103, 1);
        this.addNative("addGuiActionHandler", 105, 1);
    }

    protected abstract void customDrawScreen();

    public boolean getSkipRender() {
        return true;
    }

    protected void preScreenRender() {
    }

    protected void postScreenRender() {
    }

    public final void drawScreen() {
        this.preScreenRender();
        this.drawDefaultBackground();
        this.customDrawScreen();
        int i = 0;
        while (i < this.elementsList.size()) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            guiButton.drawButton(this.selectedButton);
            ++i;
        }
        this.postScreenRender();
    }

    protected abstract void initGui();

    public void initGuiScreen(Comcraft cc) {
        this.cc = cc;
        this.addVar("cc", cc);
        this.elementsList.removeAllElements();
        this.initGui();
        this.initTouchOrKeyboard();
        JsArray JsElementsList = ModArray.toArray(this.elementsList);
        this.addVar("elementsList", JsElementsList);
        this.eh.runEvent("initGui", this, null);
        this.elementsList = ModArray.toVector(JsElementsList);
        this.isInitialized = true;
    }

    protected void initTouchOrKeyboard() {
        GuiButton guiButton;
        this.selectedButton = Touch.isTouchSupported() ? null : ((guiButton = this.getFirstAvailableButton()) != null ? guiButton : null);
    }

    public void onScreenDisplay() {
    }

    public void onScreenClosed() {
    }

    protected void drawDefaultBackground() {
        this.drawBackground(false);
    }

    protected void drawDarkBackground() {
        this.drawBackground(true);
    }

    private void drawBackground(boolean dark) {
        Image backgroundImage = this.cc.textureProvider.getImage("gui/background.png");
        Image blackImage = null;
        if (dark) {
            blackImage = this.cc.textureProvider.getImage("gui/black.png");
        }
        int rows = Comcraft.screenWidth / backgroundImage.getWidth() + 1;
        int cols = Comcraft.screenHeight / backgroundImage.getHeight() + 1;
        int y = 0;
        while (y < cols) {
            int x = 0;
            while (x < rows) {
                this.cc.g.drawImage(backgroundImage, x * backgroundImage.getWidth(), y * backgroundImage.getHeight(), 20);
                if (dark) {
                    this.cc.g.drawImage(blackImage, x * blackImage.getWidth(), y * blackImage.getHeight(), 20);
                }
                ++x;
            }
            ++y;
        }
    }

    protected void touchClicked(int x, int y) {
        int i = 0;
        while (i < this.elementsList.size()) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.checkPoint(x, y)) {
                this.selectedButton = guiButton;
                this.handleGuiAction(guiButton);
            }
            ++i;
        }
    }

    protected void touchMovedOrUp(int x, int y) {
        if (this.selectedButton != null && Touch.isTouchSupported()) {
            this.selectedButton = null;
        }
    }

    protected abstract void handleGuiAction(GuiButton var1);

    protected void handleKeyboardInput() {
        if (Keyboard.wasButtonDown(-2) || Keyboard.wasButtonDown(115)) {
            this.selectedButton = this.getNextAvailableButton();
        }
        if (Keyboard.wasButtonDown(-1) || Keyboard.wasButtonDown(119)) {
            this.selectedButton = this.getPreviousAvailableButton();
        }
        if ((Keyboard.wasButtonDown(-5) || Keyboard.wasButtonDown(-6) || Keyboard.wasButtonDown(-7)) && this.selectedButton != null && this.selectedButton.enabled) {
            this.handleGuiAction(this.selectedButton);
        }
    }

    protected void handleTouchInput() {
        if (!Touch.isPressed() && Touch.wasPressed()) {
            this.touchClicked(Touch.getX(), Touch.getY());
        } else {
            this.touchMovedOrUp(Touch.getX(), Touch.getY());
        }
    }

    protected void customHandleInput() {
    }

    public void handleInput() {
        this.customHandleInput();
        this.handleTouchInput();
        this.handleKeyboardInput();
    }

    protected final GuiButton getButton(int id) {
        int i = 0;
        while (i < this.elementsList.size()) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.getId() == id) {
                return guiButton;
            }
            ++i;
        }
        return null;
    }

    protected GuiButtonOnOff getButtonOnOff(int id) {
        return (GuiButtonOnOff)this.getButton(id);
    }

    protected GuiButtonSelect getButtonSelect(int id) {
        return (GuiButtonSelect)this.getButton(id);
    }

    protected final GuiButton getNextAvailableButton() {
        if (this.selectedButton == null) {
            return this.getLastAvailableButton();
        }
        int i = this.elementsList.indexOf(this.selectedButton) + 1;
        while (i < this.elementsList.size()) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.enabled) {
                return guiButton;
            }
            ++i;
        }
        return this.getFirstAvailableButton();
    }

    protected final GuiButton getPreviousAvailableButton() {
        if (this.selectedButton == null) {
            return this.getFirstAvailableButton();
        }
        int i = this.elementsList.indexOf(this.selectedButton) - 1;
        while (i >= 0) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.enabled) {
                return guiButton;
            }
            --i;
        }
        return this.getLastAvailableButton();
    }

    protected final GuiButton getFirstAvailableButton() {
        int i = 0;
        while (i < this.elementsList.size()) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.enabled) {
                return guiButton;
            }
            ++i;
        }
        return null;
    }

    protected final GuiButton getLastAvailableButton() {
        int i = this.elementsList.size() - 1;
        while (i >= 0) {
            GuiButton guiButton = (GuiButton)this.elementsList.elementAt(i);
            if (guiButton.enabled) {
                return guiButton;
            }
            --i;
        }
        return null;
    }

    protected void backToParentScreen() {
        if (this.parentScreen == null) {
            this.parentScreen = new GuiMainMenu();
        }
        this.cc.displayGuiScreen(this.parentScreen);
    }

    protected void drawTitle(String title) {
        this.cc.g.setColor(255, 255, 255);
        GuiElement.drawStringWithShadow(this.cc.g, title, Comcraft.screenWidth / 2, 3, 17);
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public final boolean isScreenInitialized() {
        return this.isInitialized;
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 101: {
                break;
            }
            case 102: {
                Object fn = stack.getObject(sp);
                if (!(fn instanceof JsFunction)) break;
                this.eh.bindEventOnce("initGui", (JsFunction)fn);
                break;
            }
            case 103: {
                stack.setBoolean(sp, this.GuiName.equals(stack.getString(sp + 2)));
                break;
            }
            case 105: {
                if (parCount < 1) {
                    throw new JsException((Object)"[GuiScreen.addGuiActionHandler] missing handler argument");
                }
                Object handle = stack.getObject(sp + 2);
                if (!(handle instanceof JsFunction)) {
                    throw new JsException((Object)"[GuiScreen.addGuiActionHandler] handler must be a function");
                }
                this.eh.bindEventOnce("handleGuiAction", (JsFunction)handle);
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

