/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiNewWorld;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiScreenSlotHost;
import net.comcraft.src.GuiSlotSelectWorld;
import net.comcraft.src.GuiTextBox;
import net.comcraft.src.GuiTextBoxHost;
import net.comcraft.src.GuiYesNo;
import net.comcraft.src.GuiYesNoHost;
import net.comcraft.src.PlayerManagerImp;
import net.comcraft.src.WorldSaveType;

public class GuiSelectWorld
extends GuiScreenSlotHost
implements GuiTextBoxHost,
GuiYesNoHost {
    private WorldSaveType selectedWorld;
    public int maxWorlds;

    public GuiSelectWorld(GuiScreen parentScreen) {
        super(parentScreen, "SelectWorld");
        this.guiSlot = new GuiSlotSelectWorld(this);
    }

    protected void initGuiSlotCustom() {
        this.maxWorlds = 666;
        this.cc.worldLoader.updateAvailableWorldList();
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonPlay"), false, 2, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonNew"), this.getElementsList().size() < this.maxWorlds, 1, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonDelete"), false, 2, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonClose"), this.parentScreen != null, 0, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonRename"), false, 1, 1);
        this.elementClicked(0);
    }

    public void onScreenClosed() {
    }

    public void elementClicked(int id) {
        if (id >= this.getElementsList().size() || id < 0) {
            this.getButton(0).setEnabled(false);
            this.getButton(2).setEnabled(false);
            this.getButton(4).setEnabled(false);
            this.selectedWorld = null;
            return;
        }
        this.selectedWorld = (WorldSaveType)this.getElementsList().elementAt(id);
        this.getButton(0).setEnabled(true);
        this.getButton(2).setEnabled(true);
        this.getButton(4).setEnabled(true);
    }

    public Vector getElementsList() {
        Vector worldList = this.cc.worldLoader.getWorldList();
        if (worldList.size() > this.maxWorlds) {
            worldList.setSize(this.maxWorlds);
        }
        return worldList;
    }

    protected void customDrawScreen() {
        this.guiSlot.drawScreen();
        this.drawTitle(this.cc.langBundle.getText("GuiSelectWorld.title"));
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.getId() == 0) {
            this.selectWorld(this.selectedWorld);
        } else if (guiButton.getId() == 1) {
            this.cc.displayGuiScreen(new GuiNewWorld((GuiScreen)this, this.parentScreen));
            guiButton.setEnabled(this.getElementsList().size() < this.maxWorlds);
        } else if (guiButton.getId() == 2) {
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectWorld.deleteWorld.confirmationText")));
        } else if (guiButton.getId() == 3) {
            this.backToParentScreen();
        } else if (guiButton.getId() == 4) {
            this.cc.displayGuiScreen(new GuiTextBox(this, this.selectedWorld.getWorldName(), 0, 64));
        }
    }

    private void renameWorld(WorldSaveType worldInfo, String newName) {
        if (newName == null || newName.equals("")) {
            return;
        }
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)worldInfo.getWorldPath(), (int)3);
            fileConnection.rename(newName);
            fileConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void selectWorld(WorldSaveType world) {
        this.cc.displayGuiScreen(null);
        this.cc.playerManager = new PlayerManagerImp(this.cc);
        this.cc.startWorld(world);
    }

    public void guiYesNoAction(boolean value) {
        if (value) {
            this.cc.worldLoader.deleteWorld(this.selectedWorld);
            this.cc.worldLoader.updateAvailableWorldList();
            this.guiSlot.resetSlot();
            if (!this.getButton((int)2).enabled) {
                this.selectedButton = this.getNextAvailableButton();
            }
            this.getButton(1).setEnabled(this.getElementsList().size() < this.maxWorlds);
        }
    }

    public void guiTextBoxAction(String textBoxString) {
        this.renameWorld(this.selectedWorld, textBoxString);
        this.cc.worldLoader.updateAvailableWorldList();
    }
}

