/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.lcdui.Image;
import net.comcraft.client.Comcraft;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.GuiButtonSmall;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiSelectPath;
import net.comcraft.src.GuiSlot;

public class GuiSlotSelectPath
extends GuiSlot {
    private Image fileImage = null;
    private Image folderImage = null;

    public GuiSlotSelectPath(GuiSelectPath guiSelectPath) {
        super(guiSelectPath);
    }

    protected void initSlotSize() {
        this.xPos = 0;
        this.slotScreenWidth = Comcraft.screenWidth;
        this.slotWidth = Comcraft.screenWidth - 20;
        this.yPos = 3 + this.cc.g.getFont().getHeight() + 3;
        this.slotScreenHeight = Comcraft.screenHeight - this.yPos - 15 - GuiButtonSmall.getButtonHeight() * 2;
        if (Comcraft.getScreenHeight() == 320) {
            this.slotHeight = 30;
        } else if (Comcraft.getScreenHeight() == 240) {
            this.slotHeight = 30;
        } else if (Comcraft.getScreenHeight() == 220) {
            this.slotHeight = 30;
        } else if (Comcraft.getScreenHeight() == 400) {
            this.slotHeight = 30;
        } else if (Comcraft.getScreenHeight() == 480) {
            this.slotHeight = 40;
        } else if (Comcraft.getScreenHeight() == 640) {
            this.slotHeight = 60;
        } else if (Comcraft.getScreenHeight() == 800) {
            this.slotHeight = 60;
        }
    }

    private void initFileAndFolderImage() {
        Image baseImage = this.cc.textureProvider.getImage("gui/file_icon.png");
        int size = baseImage.getHeight();
        this.fileImage = Image.createImage((Image)baseImage, (int)0, (int)0, (int)size, (int)size, (int)0);
        this.folderImage = Image.createImage((Image)baseImage, (int)size, (int)0, (int)size, (int)size, (int)0);
    }

    protected void initSlot() {
        this.initFileAndFolderImage();
    }

    protected void drawSlot(int i) {
        int y = this.getSlotY(i);
        if (!this.isSlotVisibile(y)) {
            return;
        }
        if (this.selectedElement == i) {
            this.drawSelectedSlotFrame(y);
        }
        this.cc.g.setColor(255, 255, 255);
        String slotString = (String)this.guiScreenSlotHost.getElementsList().elementAt(i);
        if (FileSystemHelper.isDirectory(slotString)) {
            this.drawSlotTypeImage(this.folderImage, y);
        } else {
            this.drawSlotTypeImage(this.fileImage, y);
        }
        GuiElement.drawStringWithShadow(this.cc.g, FileSystemHelper.getLastPathName(slotString), (Comcraft.screenWidth - this.slotWidth) / 2 + this.folderImage.getWidth() + 10, y + this.slotHeight / 2 - this.cc.g.getFont().getHeight() / 2, 20);
    }

    private void drawSlotTypeImage(Image slotImage, int y) {
        this.cc.g.drawImage(slotImage, (Comcraft.screenWidth - this.slotWidth) / 2 + 5, y + (this.slotHeight - slotImage.getHeight()) / 2, 20);
    }
}

