/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;

public class Keyboard {
    public static final int KEY_UP = -1;
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_FIRE = -5;
    public static final int KEY_SOFT_LEFT = -6;
    public static final int KEY_SOFT_RIGHT = -7;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    public static final int KEY_W = 119;
    public static final int KEY_S = 115;
    public static final int KEY_A = 97;
    public static final int KEY_D = 100;
    public static final int KEY_Q = 113;
    public static final int KEY_E = 101;
    public static final int KEY_R = 114;
    public static final int KEY_I = 105;
    public static final int KEY_J = 106;
    public static final int KEY_K = 107;
    public static final int KEY_L = 108;
    public static final int KEY_F = 102;
    public static final int KEY_O = 111;
    public static final int KEY_U = 117;
    public static final int KEY_T = 116;
    public static final int KEY_Y = 121;
    private static int actKey = -999;
    private static int lastKey = -999;
    private static boolean isPressed = false;
    private static boolean wasPressed = false;
    private static long buttonDownTime;
    private static long buttonPressTime;
    private static Vector typeQueue;
    private static Vector valueQueue;
    private static Vector timeQueue;
    private static boolean hasAnyKeyBeenPressed;

    static {
        hasAnyKeyBeenPressed = false;
        typeQueue = new Vector(50);
        valueQueue = new Vector(50);
        timeQueue = new Vector(50);
    }

    private Keyboard() {
    }

    public static boolean hasAnyKeyBeenPressed() {
        return hasAnyKeyBeenPressed;
    }

    public static int getCurrentKey() {
        return actKey;
    }

    public static int getLastKey() {
        return lastKey;
    }

    public static boolean isQueueEmpty() {
        return typeQueue.isEmpty() || valueQueue.isEmpty() || timeQueue.isEmpty();
    }

    public static void keyPressed(int key) {
        typeQueue.addElement(new Integer(0));
        valueQueue.addElement(new Integer(key));
        timeQueue.addElement(new Long(System.currentTimeMillis()));
        hasAnyKeyBeenPressed = true;
    }

    public static void keyRepeated(int key) {
        typeQueue.addElement(new Integer(1));
        valueQueue.addElement(new Integer(key));
        timeQueue.addElement(new Long(0L));
    }

    public static void keyReleased(int key) {
        typeQueue.addElement(new Integer(2));
        valueQueue.addElement(new Integer(key));
        timeQueue.addElement(new Long(System.currentTimeMillis()));
    }

    public static void tickKeyboard() {
        if (Keyboard.isQueueEmpty()) {
            return;
        }
        Integer typeInteger = (Integer)typeQueue.firstElement();
        Integer valueInteger = (Integer)valueQueue.firstElement();
        Long timeLong = (Long)timeQueue.firstElement();
        typeQueue.removeElementAt(0);
        valueQueue.removeElementAt(0);
        timeQueue.removeElementAt(0);
        int type = typeInteger;
        int value = valueInteger;
        long time = timeLong;
        if (type == 0) {
            Keyboard.keyDown(value, time);
        } else if (type == 1) {
            Keyboard.keyHold(value);
        } else {
            Keyboard.keyUp(value, time);
        }
    }

    private static void keyDown(int key, long time) {
        buttonDownTime = time;
        actKey = key;
        isPressed = true;
        wasPressed = false;
    }

    private static void keyUp(int key, long time) {
        buttonPressTime = time - buttonDownTime;
        actKey = -999;
        lastKey = key;
        isPressed = false;
        wasPressed = true;
    }

    private static void keyHold(int key) {
    }

    public static boolean isButtonDown(int key) {
        return isPressed && Keyboard.isTheSameKey(key, actKey);
    }

    public static boolean wasButtonDown(int key) {
        if (wasPressed && Keyboard.isTheSameKey(key, lastKey)) {
            wasPressed = false;
            return true;
        }
        return false;
    }

    private static boolean isTheSameKey(int actKey, int lastKey) {
        if (actKey == lastKey) {
            return true;
        }
        if (actKey >= 97 && actKey <= 122) {
            return actKey - 32 == lastKey;
        }
        return false;
    }

    public static int getButtonPressDtTime(long currentTime) {
        if (isPressed) {
            return (int)(System.currentTimeMillis() - buttonDownTime);
        }
        return (int)buttonPressTime;
    }

    public static void resetKeyboard() {
        actKey = -999;
        lastKey = -999;
        isPressed = false;
        wasPressed = false;
        typeQueue.removeAllElements();
        valueQueue.removeAllElements();
        timeQueue.removeAllElements();
    }
}

