/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import net.comcraft.client.Comcraft;
import net.comcraft.src.BufferedReader;

public class LangBundle {
    private Hashtable wordMap = new Hashtable(150);
    private Hashtable defaultMap = new Hashtable(150);
    private Comcraft cc;

    public LangBundle(Comcraft cc) {
        this.cc = cc;
    }

    private void loadMap(String fileName, Hashtable map) {
        BufferedReader bufferedReader;
        map.clear();
        InputStream resource = this.cc.getResourceAsStream(fileName);
        if (resource == null) {
            return;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            bufferedReader = new BufferedReader(new InputStreamReader(resource));
        }
        while (!bufferedReader.getReachedTheEnd()) {
            int firstIndex;
            String word = bufferedReader.readLine();
            if (word == null || (firstIndex = word.indexOf("=")) == -1) continue;
            String key = word.substring(0, firstIndex);
            String text = word.substring(firstIndex + 1);
            map.put(key, text);
        }
    }

    public void setDefaultMap(String fileName) {
        this.loadMap(fileName, this.defaultMap);
    }

    public void loadBundle(String fileName) {
        this.loadMap(fileName, this.wordMap);
    }

    public String getText(String key) {
        String word = (String)this.wordMap.get(key);
        if (word == null && (word = (String)this.defaultMap.get(key)) == null) {
            return "???";
        }
        return word;
    }
}

