/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Texture2D;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Block;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.InvItem;
import net.comcraft.src.Touch;

public final class TextureManager {
    private final Comcraft cc;
    private Hashtable loadedImagesList;
    private Texture2D[] terrainTexturesList;
    private Image[] itemImagesList;
    private Texture2D[] skinTexturesList;

    public TextureManager(Comcraft cc) {
        this.cc = cc;
        this.loadedImagesList = new Hashtable(50);
        this.terrainTexturesList = new Texture2D[512];
        this.itemImagesList = new Image[512];
        this.skinTexturesList = new Texture2D[6];
    }

    public void releaseTextures() {
        this.loadedImagesList.clear();
        this.terrainTexturesList = null;
        this.skinTexturesList = null;
    }

    public void reloadTextures() {
        this.loadedImagesList.clear();
        this.loadAllImages();
        this.loadTerrainTextures();
        this.loadItemTextures();
        this.loadSkinTextures();
    }

    private Vector getUsedItemTexturesList() {
        Vector<Integer> list = new Vector<Integer>(256);
        int n = 0;
        while (n < InvItem.itemsList.length) {
            InvItem item = InvItem.itemsList[n];
            if (item != null) {
                int tex = item.getIconIndex();
                Integer integer = new Integer(tex);
                list.addElement(integer);
            }
            ++n;
        }
        return list;
    }

    private Vector getUsedTerrainTexturesList() {
        Vector<Integer> list = new Vector<Integer>(512);
        int n = 0;
        while (n < Block.blocksList.length) {
            Block block = Block.blocksList[n];
            if (block != null) {
                int[] tex = block.getUsedTexturesList();
                int i = 0;
                while (i < tex.length) {
                    Integer integer = new Integer(tex[i]);
                    list.addElement(integer);
                    ++i;
                }
            }
            ++n;
        }
        return list;
    }

    public static Image getResizedImage(Image image, int resizedWidth, int resizedHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] in = new int[width];
        int[] out = new int[resizedWidth * resizedHeight];
        int y = 0;
        while (y < resizedHeight) {
            int dy = y * height / resizedHeight;
            image.getRGB(in, 0, width, 0, dy, width, 1);
            int x = 0;
            while (x < resizedWidth) {
                int dx = x * width / resizedWidth;
                out[resizedWidth * y + x] = in[dx];
                ++x;
            }
            ++y;
        }
        Image resized = Image.createRGBImage((int[])out, (int)resizedWidth, (int)resizedHeight, (boolean)true);
        return resized;
    }

    private void loadItemTextures() {
        Image background;
        Image resized;
        Image image;
        int x;
        Image items = null;
        Image items2 = null;
        Vector usedTextures = this.getUsedItemTexturesList();
        try {
            items = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream("gui/items.png"));
            items2 = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream("gui/items_cc.png"));
        }
        catch (IOException ex) {
            throw new ComcraftException("Can't load terrain image!", ex);
        }
        int size = items.getWidth() / 16;
        int y = 0;
        while (y < 16) {
            x = 0;
            while (x < 16) {
                if (usedTextures.contains(new Integer(y * 16 + x))) {
                    image = Image.createImage((Image)items, (int)(x * size), (int)(y * size), (int)size, (int)size, (int)(Touch.isTouchSupported() ? 5 : 0));
                    resized = TextureManager.getResizedImage(image, 32, 32);
                    background = Image.createImage((int)50, (int)50);
                    background.getGraphics().drawImage(resized, (50 - resized.getWidth()) / 2, (50 - resized.getHeight()) / 2, 20);
                    this.itemImagesList[y * 16 + x] = background;
                }
                ++x;
            }
            ++y;
        }
        size = items2.getWidth() / 16;
        y = 0;
        while (y < 16) {
            x = 0;
            while (x < 16) {
                if (usedTextures.contains(new Integer(256 + y * 16 + x))) {
                    image = Image.createImage((Image)items2, (int)(x * size), (int)(y * size), (int)size, (int)size, (int)(Touch.isTouchSupported() ? 5 : 0));
                    resized = TextureManager.getResizedImage(image, 32, 32);
                    background = Image.createImage((int)50, (int)50);
                    background.getGraphics().drawImage(resized, (50 - resized.getWidth()) / 2, (50 - resized.getHeight()) / 2, 20);
                    this.itemImagesList[256 + y * 16 + x] = background;
                }
                ++x;
            }
            ++y;
        }
    }

    private void loadTerrainTextures() {
        Texture2D texture2D;
        Image2D image2D;
        Image image;
        int x;
        Image terrain = null;
        Image terrain1 = null;
        Vector usedTextures = this.getUsedTerrainTexturesList();
        try {
            terrain = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream("terrain.png"));
            terrain1 = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream("terrain_cc.png"));
        }
        catch (IOException ex) {
            throw new ComcraftException("Can't load terrain image!", ex);
        }
        int size = terrain.getWidth() / 16;
        int y = 0;
        while (y < 16) {
            x = 0;
            while (x < 16) {
                if (usedTextures.contains(new Integer(y * 16 + x))) {
                    image = Image.createImage((Image)terrain, (int)(x * size), (int)(y * size), (int)size, (int)size, (int)2);
                    image2D = new Image2D(100, (Object)image);
                    texture2D = new Texture2D(image2D);
                    texture2D.setFiltering(208, 210);
                    texture2D.setWrapping(241, 241);
                    texture2D.setBlending(228);
                    this.terrainTexturesList[y * 16 + x] = texture2D;
                }
                ++x;
            }
            ++y;
        }
        size = terrain1.getWidth() / 16;
        y = 0;
        while (y < 16) {
            x = 0;
            while (x < 16) {
                if (usedTextures.contains(new Integer(256 + y * 16 + x))) {
                    image = Image.createImage((Image)terrain1, (int)(x * size), (int)(y * size), (int)size, (int)size, (int)2);
                    image2D = new Image2D(100, (Object)image);
                    texture2D = new Texture2D(image2D);
                    texture2D.setFiltering(208, 210);
                    texture2D.setWrapping(241, 241);
                    texture2D.setBlending(228);
                    this.terrainTexturesList[256 + y * 16 + x] = texture2D;
                }
                ++x;
            }
            ++y;
        }
    }

    private void loadAllImages() {
        this.loadImage("gui/background.png");
        this.loadImage("gui/black.png");
        this.loadImage("gui/file_icon.png");
        this.loadImage("gui/button.png");
        this.loadImage("gui/button_small.png");
        this.loadImage("gui/slot.png");
        this.loadImage("gui/slot_selection.png");
        this.loadImage("gui/arrow_key.png");
        this.loadImage("gui/pointer.png");
        this.loadImageLandscape("gui/slot_more.png");
        this.loadImage("gui/inventory_landscape.png");
        this.loadImage("gui/inventory_normal.png");
        this.loadImage("gui/inventory_slot.png");
        this.loadImage("gui/inventory_slot_selection.png");
        this.loadImage("gui/button_exit.png");
        this.loadImage("gui/comcraft_logo.png");
        this.loadImageLandscape("gui/loading_sprite.png");
        this.loadImage("gui/button_quick_menu.png");
        this.loadImage("gui/button_screenshot.png");
        this.loadImageLandscape("gui/locked_item.png");
    }

    private void loadImage(String path) {
        Image image = null;
        try {
            image = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream(path));
        }
        catch (IOException ex) {
            throw new ComcraftException("Can't load texture from texturepack: " + path, ex);
        }
        this.loadedImagesList.put(path, image);
    }

    private void loadImageLandscape(String path) {
        Image image = null;
        int transform = Touch.isTouchSupported() ? 5 : 0;
        try {
            Image tempImage = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream(path));
            image = Image.createImage((Image)tempImage, (int)0, (int)0, (int)tempImage.getWidth(), (int)tempImage.getHeight(), (int)transform);
        }
        catch (IOException ex) {
            throw new ComcraftException("Can't load texture from texturepack: " + path, ex);
        }
        this.loadedImagesList.put(path, image);
    }

    public Texture2D getTerrainTexture(int index) {
        return this.terrainTexturesList[index];
    }

    public Texture2D getSkinTexture(int index) {
        return this.skinTexturesList[index];
    }

    public Image getItemTexture(int index) {
        if (index >= 512) {
            return this.cc.render.renderBlockPreview.getBlockPreviewImage(index - 512);
        }
        return this.itemImagesList[index];
    }

    public Image getImage(String path) {
        Image image = (Image)this.loadedImagesList.get(path);
        if (image == null) {
            try {
                image = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream(path));
                return image;
            }
            catch (IOException ex) {
                throw new ComcraftException(ex);
            }
        }
        return image;
    }

    private void loadSkinTextures() {
        Image skin = null;
        try {
            skin = Image.createImage((InputStream)this.cc.texturePackList.getResourceAsStream("skin.png"));
        }
        catch (IOException ex) {
            throw new ComcraftException("Can't load skin image!", ex);
        }
        int size = skin.getWidth() / 3;
        int y = 0;
        while (y < 2) {
            int x = 0;
            while (x < 3) {
                Image image = Image.createImage((Image)skin, (int)(x * size), (int)(y * size), (int)size, (int)(size * (y + 1)), (int)2);
                Image2D image2D = new Image2D(100, (Object)image);
                Texture2D texture2D = new Texture2D(image2D);
                texture2D.setFiltering(208, 210);
                texture2D.setWrapping(241, 241);
                texture2D.setBlending(228);
                this.skinTexturesList[y * 2 + x] = texture2D;
                ++x;
            }
            ++y;
        }
    }
}

