/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class GeminiMIDlet
extends MIDlet {
    private Display display;
    private Form form;
    private TextField inputField;
    private StringItem responseItem;
    private StringItem questionItem;
    private String selectedLanguage = "pt";

    public GeminiMIDlet() {
        this.showLanguageSelection();
    }

    private void showLanguageSelection() {
        String[] languages = new String[]{"Portugu\u00eas", "Ingl\u00eas", "Espanhol", "Russo"};
        final List languageList = new List("Selecione o Idioma", 1, languages, null);
        final Command selectCommand = new Command("Selecionar", 4, 1);
        languageList.addCommand(selectCommand);
        languageList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == selectCommand) {
                    int selectedIndex = languageList.getSelectedIndex();
                    switch (selectedIndex) {
                        case 0: {
                            GeminiMIDlet.this.selectedLanguage = "pt";
                            break;
                        }
                        case 1: {
                            GeminiMIDlet.this.selectedLanguage = "en";
                            break;
                        }
                        case 2: {
                            GeminiMIDlet.this.selectedLanguage = "es";
                            break;
                        }
                        case 3: {
                            GeminiMIDlet.this.selectedLanguage = "ru";
                        }
                    }
                    GeminiMIDlet.this.initializeForm();
                    GeminiMIDlet.this.display.setCurrent((Displayable)GeminiMIDlet.this.form);
                }
            }
        });
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)languageList);
    }

    private void initializeForm() {
        String inputLabel = "";
        String sendLabel = "";
        String saveLabel = "";
        String questionLabel = "";
        String responseLabel = "";
        String formTitle = "";
        if (this.selectedLanguage.equals("pt")) {
            inputLabel = "Digite sua pergunta:";
            sendLabel = "Enviar";
            saveLabel = "Salvar";
            questionLabel = "Pergunta: ";
            responseLabel = "Resposta: ";
            formTitle = "Conversar com Gemini";
        } else if (this.selectedLanguage.equals("en")) {
            inputLabel = "Enter your question:";
            sendLabel = "Send";
            saveLabel = "Save";
            questionLabel = "Question: ";
            responseLabel = "Answer: ";
            formTitle = "Chat with Gemini";
        } else if (this.selectedLanguage.equals("es")) {
            inputLabel = "Ingrese su pregunta:";
            sendLabel = "Enviar";
            saveLabel = "Guardar";
            questionLabel = "Pregunta: ";
            responseLabel = "Respuesta: ";
            formTitle = "Conversar con Gemini";
        } else if (this.selectedLanguage.equals("ru")) {
            inputLabel = "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u0430\u0448 \u0432\u043e\u043f\u0440\u043e\u0441:";
            sendLabel = "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c";
            saveLabel = "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c";
            questionLabel = "\u0412\u043e\u043f\u0440\u043e\u0441: ";
            responseLabel = "\u041e\u0442\u0432\u0435\u0442: ";
            formTitle = "\u041e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441 Gemini";
        }
        this.form = new Form(formTitle);
        this.inputField = new TextField(inputLabel, "", 255, 0);
        this.responseItem = new StringItem(responseLabel, "");
        this.questionItem = new StringItem(questionLabel, "");
        this.form.append((Item)this.inputField);
        this.form.append((Item)this.questionItem);
        this.form.append((Item)this.responseItem);
        final Command sendCommand = new Command(sendLabel, 4, 1);
        final Command saveCommand = new Command(saveLabel, 1, 2);
        this.form.addCommand(sendCommand);
        this.form.addCommand(saveCommand);
        this.form.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == sendCommand) {
                    GeminiMIDlet.this.sendRequest(GeminiMIDlet.this.inputField.getString());
                } else if (c == saveCommand) {
                    GeminiMIDlet.this.saveResponseToFile();
                }
            }
        });
    }

    public void startApp() {
        if (this.form != null) {
            this.display.setCurrent((Displayable)this.form);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    private void sendRequest(final String query) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    int bytesRead;
                    String url = "http://gemini.tudo3655.workers.dev/?msg=" + GeminiMIDlet.this.encodeURL(query);
                    HttpConnection connection = (HttpConnection)Connector.open((String)url);
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    InputStream is = connection.openInputStream();
                    byte[] responseBytes = new byte[1024];
                    StringBuffer response = new StringBuffer();
                    while ((bytesRead = is.read(responseBytes)) != -1) {
                        response.append(new String(responseBytes, 0, bytesRead, "UTF-8"));
                    }
                    is.close();
                    final String responseString = response.toString().trim();
                    GeminiMIDlet.this.display.callSerially(new Runnable(){

                        public void run() {
                            GeminiMIDlet.this.questionItem.setText(GeminiMIDlet.this.questionItem.getLabel() + query);
                            GeminiMIDlet.this.responseItem.setText(responseString);
                        }
                    });
                    connection.close();
                }
                catch (IOException e) {
                    GeminiMIDlet.this.display.callSerially(new Runnable(){

                        public void run() {
                            GeminiMIDlet.this.responseItem.setText("Erro: " + e.getMessage());
                        }
                    });
                }
            }
        }).start();
    }

    private void saveResponseToFile() {
        try {
            String questionText = this.questionItem.getText().substring(this.questionItem.getLabel().length()).trim();
            String fileName = this.sanitizeFileName(questionText) + ".txt";
            String filePath = "file:///C:/" + fileName;
            FileConnection fileConn = (FileConnection)Connector.open((String)filePath, (int)2);
            if (!fileConn.exists()) {
                fileConn.create();
            }
            OutputStream os = fileConn.openOutputStream();
            String response = this.responseItem.getText().trim();
            byte[] data = response.getBytes();
            os.write(data);
            os.close();
            fileConn.close();
            this.responseItem.setText("Resposta salva em: " + fileName);
        }
        catch (IOException e) {
            this.responseItem.setText("Erro ao salvar: " + e.getMessage());
        }
    }

    private String sanitizeFileName(String text) {
        text = text.replace(' ', '_');
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && c != '-') continue;
            result.append(c);
        }
        text = result.toString();
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        return text;
    }

    private String encodeURL(String text) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                encoded.append(c);
                continue;
            }
            if (c == ' ') {
                encoded.append("%20");
                continue;
            }
            encoded.append("%").append(Integer.toHexString(c).toUpperCase());
        }
        return encoded.toString();
    }
}

