/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk;

import java.util.Timer;
import java.util.TimerTask;
import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.ILongPollCallback;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetLongPollServer;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetLongPollServerResponse;

public class LongPoll
extends TimerTask {
    public static ILongPollCallback callback;
    public static Timer lpTimer;
    public static LongPoll task;
    public static int ts;
    public static int slept;
    public static int limit;
    public static int sleptLimit;
    public static boolean slowMode;
    public static boolean skipWait;
    String key;
    String server;

    public static void stop(boolean confirm) {
        try {
            if (lpTimer != null) {
                lpTimer.cancel();
            }
            if (callback != null) {
                callback.sleeping();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!confirm && VKConstants.account != null) {
                LongPoll.start();
            }
        }
        catch (Exception expected) {
            VKConstants.debug(0, expected);
        }
    }

    public void stop() {
        LongPoll.stop(false);
    }

    public static void start() {
        task = new LongPoll();
        task.init();
    }

    public void init() {
        if (VKConstants.account == null) {
            return;
        }
        MessagesGetLongPollServerResponse resp = (MessagesGetLongPollServerResponse)new MessagesGetLongPollServer().execute();
        if (resp != null && resp.isSuccessful()) {
            ts = resp.ts;
            this.key = resp.key;
            this.server = resp.server;
            lpTimer = new Timer();
            lpTimer.schedule((TimerTask)this, 0L);
        } else {
            this.stop();
        }
    }

    public void run() {
        while (true) {
            try {
                block13: while (true) {
                    if (VKConstants.account == null) {
                        return;
                    }
                    slept = 0;
                    skipWait = false;
                    if (callback != null) {
                        callback.fetching();
                    }
                    String url = (this.server.startsWith("http") ? "" : (VKConstants.apiUrl().startsWith("http:") ? "http://" : "https://")) + this.server + "?act=a_check&key=" + this.key + "&ts=" + ts + "&wait=2&mode=202&version=3";
                    String response = null;
                    try {
                        response = HTTPClient.getURLString(url);
                    }
                    catch (Exception e) {
                        VKConstants.debug(0, e);
                    }
                    if (!VKObject.isEmpty(response)) {
                        JSONArray updates = null;
                        try {
                            JSONObject json = new JSONObject(response);
                            int failed = json.optInt("failed");
                            if (failed == 2 || failed == 3 || failed == 4) {
                                this.stop();
                                return;
                            }
                            int ts1 = json.optInt("ts");
                            if (ts1 != 0) {
                                ts = ts1;
                            }
                            updates = json.optJSONArray("updates");
                        }
                        catch (Exception e) {
                            VKConstants.debug(0, e);
                            try {
                                updates = new JSONArray(response);
                            }
                            catch (Exception ex) {
                                VKConstants.debug(0, ex);
                            }
                        }
                        try {
                            this.parse(updates);
                        }
                        catch (Exception e) {
                            VKConstants.debug(0, e);
                        }
                    }
                    if (callback != null) {
                        callback.sleeping();
                    }
                    while (true) {
                        if ((!slowMode || slept >= sleptLimit) && (slowMode || slept >= limit) || skipWait) continue block13;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++slept;
                    }
                    break;
                }
            }
            catch (Exception e) {
                VKConstants.debug(0, e);
                continue;
            }
            break;
        }
    }

    public void parse(JSONArray updates) {
        if (updates == null || callback == null) {
            return;
        }
        for (int i = 0; i < updates.length(); ++i) {
            JSONArray update = updates.optJSONArray(i);
            if (update == null) continue;
            try {
                callback.update(update);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        limit = 3;
        sleptLimit = 17;
    }
}

