/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk;

import java.util.TimeZone;
import java.util.Vector;

public class TextUtil {
    private static final String error_str = "[incorrect data]";
    public static final int TIME_SECOND = 0;
    public static final int TIME_MINUTE = 1;
    public static final int TIME_HOUR = 2;
    public static final int TIME_DAY = 3;
    public static final int TIME_MON = 4;
    public static final int TIME_YEAR = 5;
    private static final byte[] dayCounts = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static int gmtOffset = 10800;
    public static boolean summerTime = false;
    public static int dOffset = TimeZone.getDefault().getRawOffset() / 1000;

    public static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimeGMT() {
        return TextUtil.getCurrentTime() + (long)TextUtil.getGmtOffset();
    }

    public static long getMentionedTimeGMT(long time) {
        return time + (long)TextUtil.getGmtOffset();
    }

    public static int getGmtOffset() {
        return dOffset;
    }

    public static long createTimeLong(int year, int mon, int day, int hour, int min, int sec) {
        int febCount;
        int day_count = (year - 1970) * 365 + day;
        day_count += (year - 1968) / 4;
        if (year >= 2000) {
            --day_count;
        }
        if (year % 4 == 0 && year != 2000) {
            --day_count;
            febCount = 29;
        } else {
            febCount = 28;
        }
        for (int i = 0; i < mon - 1; ++i) {
            day_count += i == 1 ? febCount : dayCounts[i];
        }
        return (long)day_count * 24L * 3600L + (long)hour * 3600L + (long)min * 60L + (long)sec;
    }

    public static int[] createDateArray(long value) {
        int last_days;
        int sec = (int)(value % 60L);
        int min = (int)(value / 60L % 60L);
        int hour = (int)((value -= (long)(60 * min)) / 3600L % 24L);
        int total_days = (int)((value -= (long)(3600 * hour)) / 86400L);
        int year = 1970;
        while ((last_days = total_days - (year % 4 == 0 && year != 2000 ? 366 : 365)) > 0) {
            total_days = last_days;
            ++year;
        }
        int febrDays = year % 4 == 0 && year != 2000 ? 29 : 28;
        int mon = 1;
        for (int i = 0; i < 12 && (last_days = total_days - (i == 1 ? febrDays : dayCounts[i])) > 0; ++i) {
            ++mon;
            total_days = last_days;
        }
        int day = total_days;
        return new int[]{sec, min, hour, day, mon, year};
    }

    public static String delayToString(long seconds) {
        StringBuffer buf = new StringBuffer();
        int days = (int)(seconds / 86400L);
        int hours = (int)((seconds %= 86400L) / 3600L);
        int minutes = (int)((seconds %= 3600L) / 60L);
        if (days != 0) {
            buf.append(days).append(' ').append("days").append(' ');
        }
        if (hours != 0) {
            buf.append(hours).append(' ').append("hours").append(' ');
        }
        if (minutes != 0) {
            buf.append(minutes).append(' ').append("minutes");
        }
        return buf.toString();
    }

    public static String makeTwo(long number) {
        if (number < 10L) {
            return "0" + String.valueOf(number);
        }
        return String.valueOf(number);
    }

    public static String getDateString(long date, boolean time) {
        if (date == 0L) {
            return error_str;
        }
        int[] loclaDate = TextUtil.createDateArray(date);
        StringBuffer sb = new StringBuffer();
        sb.append(TextUtil.makeTwo(loclaDate[3])).append('.').append(TextUtil.makeTwo(loclaDate[4])).append('.').append(loclaDate[5]);
        if (time) {
            sb.append(' ').append(TextUtil.makeTwo(loclaDate[2])).append(':').append(TextUtil.makeTwo(loclaDate[1]));
        }
        return sb.toString();
    }

    public static String getTimeStringUTC(long date, boolean seconds) {
        if (date == 0L) {
            return error_str;
        }
        int[] loclaDate = TextUtil.createDateArray(date);
        StringBuffer sb = new StringBuffer();
        sb.append(TextUtil.makeTwo(loclaDate[2])).append(':').append(TextUtil.makeTwo(loclaDate[1]));
        if (seconds) {
            sb.append(':').append(TextUtil.makeTwo(loclaDate[0]));
        }
        return sb.toString();
    }

    public static String getUtcTimeString(long date) {
        if (date == 0L) {
            return error_str;
        }
        int[] loclaDate = TextUtil.createDateArray(date);
        StringBuffer sb = new StringBuffer();
        sb.append(TextUtil.makeTwo(loclaDate[5])).append('-').append(TextUtil.makeTwo(loclaDate[4])).append('-').append(TextUtil.makeTwo(loclaDate[3])).append('T').append(TextUtil.makeTwo(loclaDate[2])).append(':').append(TextUtil.makeTwo(loclaDate[1])).append(':').append(TextUtil.makeTwo(loclaDate[0])).append('Z');
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static long getUtcTimeLong(String stamp, boolean isLocalized) {
        int tIndex;
        if (!TextUtil.isNullOrEmpty(stamp) && (tIndex = stamp.indexOf(84)) != -1) {
            String date = stamp.substring(0, tIndex);
            int yIndex = date.indexOf(45);
            int rYears = Integer.parseInt(date.substring(0, yIndex));
            int mIndex = date.indexOf(45, yIndex + 1);
            int rMonths = Integer.parseInt(date.substring(yIndex + 1, mIndex));
            int rDays = Integer.parseInt(date.substring(mIndex + 1));
            String time = stamp.substring(tIndex + 1);
            int zIndex = Math.max(time.indexOf(43), time.indexOf(45));
            if ((zIndex = Math.max(zIndex, time.indexOf(90))) != -1) {
                String clearTime = time.substring(0, zIndex);
                String timeZone = time.substring(zIndex);
                int hIndex = clearTime.indexOf(58);
                int rHours = Integer.parseInt(clearTime.substring(0, hIndex));
                mIndex = clearTime.indexOf(58, hIndex + 1);
                int rMinutes = Integer.parseInt(clearTime.substring(hIndex + 1, mIndex));
                int rSeconds = Integer.parseInt(clearTime.substring(mIndex + 1));
                long timeLong = TextUtil.createTimeLong(rYears, rMonths, rDays, rHours, rMinutes, rSeconds);
                if (!timeZone.equals("Z") && !isLocalized) {
                    boolean isPlus = timeZone.charAt(0) == '+';
                    int dIndex = timeZone.indexOf(58);
                    if (dIndex != -1) {
                        timeLong -= (long)(((isPlus ? 1 : -1) * Integer.parseInt(timeZone.substring(1, dIndex)) * 60 + Integer.parseInt(timeZone.substring(dIndex + 1))) * 60);
                    }
                } else {
                    timeLong += (long)TextUtil.getGmtOffset();
                }
                return timeLong;
            }
        }
        return 0L;
    }

    static long getMillisOffset() {
        return dOffset;
    }

    public static String easyReplace(String s, String target, String replacement) {
        String[] split = TextUtil.easySplit(s, target);
        if (split == null) {
            return null;
        }
        if (split.length == 1) {
            return split[0];
        }
        return split[0] + replacement + split[1];
    }

    public static String[] easySplit(String s, String target) {
        if (s == null) {
            return null;
        }
        if (target == null) {
            return new String[]{s};
        }
        int index = s.indexOf(target);
        String[] split = new String[index != -1 ? 2 : 1];
        if (index == -1) {
            split[0] = s;
            return split;
        }
        split[1] = s.substring(index + target.length());
        split[0] = s.substring(0, s.length() - target.length() - split[1].length());
        return split;
    }

    public static Vector split(String splitStr, String delimiter) {
        StringBuffer token = new StringBuffer();
        Vector<String> tokens = new Vector<String>();
        char[] chars = splitStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            token.append(chars[i]);
            if (token.toString().indexOf(delimiter) == -1) continue;
            token.setLength(token.length() - delimiter.length());
            tokens.addElement(token.toString());
            token.setLength(0);
        }
        if (token.length() > 0) {
            tokens.addElement(token.toString());
        }
        return tokens;
    }

    public static String[] splitArray(String s, String d) {
        Vector<String> tokens;
        Vector<String> vector = tokens = s == null || d == null ? new Vector<String>(1, 1) : TextUtil.split(s, d);
        if (s != null && d == null) {
            tokens.addElement(s);
        }
        Object[] splitArray = new String[tokens.size()];
        tokens.copyInto(splitArray);
        return splitArray;
    }

    public static String join(String delimiter, Vector v) {
        StringBuffer buff = new StringBuffer();
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                buff.append(v.elementAt(i));
                if (i == v.size() - 1) continue;
                buff.append(delimiter);
            }
        }
        return buff.toString();
    }

    public static String getTimeString(long time, boolean seconds) {
        return TextUtil.getTimeStringUTC(time + (long)dOffset, seconds);
    }

    public static int[] parseDateString(String date) {
        if (date == null) {
            return null;
        }
        int[] dateArray = new int[6];
        Vector v = TextUtil.split(date, ".");
        if (v.size() > 2) {
            try {
                dateArray[5] = Integer.parseInt((String)v.elementAt(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v.size() > 1) {
            try {
                dateArray[4] = Integer.parseInt((String)v.elementAt(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v.size() > 0) {
            try {
                dateArray[3] = Integer.parseInt((String)v.elementAt(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateArray;
    }
}

