/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects;

import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.j2vk.api.requests.account.AccountSetOffline;
import ru.curoviyxru.j2vk.api.requests.auth.AuthRefreshToken;
import ru.curoviyxru.j2vk.api.requests.users.UsersGet;
import ru.curoviyxru.j2vk.api.responses.account.AccountSetOfflineResponse;
import ru.curoviyxru.j2vk.api.responses.auth.AuthRefreshTokenResponse;
import ru.curoviyxru.j2vk.api.responses.auth.AuthResponse;
import ru.curoviyxru.j2vk.api.responses.users.UsersGetResponse;

public class Account
extends VKObject {
    public String token;
    public boolean refreshed;
    public long id;

    public long getId() {
        return this.id;
    }

    public Account(String token) throws Exception {
        this.setToken(token);
        UsersGetResponse get = (UsersGetResponse)new UsersGet().execute(this, false);
        if (get == null || !get.hasUser() || get.getUser().id == 0L) {
            throw new Exception("No user_id.");
        }
        this.setId(get.getUser().id);
    }

    public Account setIsRefreshed(boolean r) {
        this.refreshed = r;
        return this;
    }

    public Account setToken(String token) {
        this.token = token;
        return this;
    }

    public Account setId(long id) {
        this.id = id;
        return this;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public String getToken() {
        return this.token;
    }

    public boolean hasToken() {
        return !Account.isEmpty(this.token);
    }

    public Account refreshToken() {
        AuthRefreshTokenResponse r;
        String gcm = HTTPClient.requestToken();
        if (!Account.isEmpty(gcm) && (r = (AuthRefreshTokenResponse)new AuthRefreshToken(gcm).execute(this, false)) != null && r.hasToken()) {
            this.setToken(r.token);
            this.setIsRefreshed(true);
            VKConstants.client.saveConfig();
        }
        return this;
    }

    public Account(AuthResponse auth) {
        if (auth == null || !auth.isSuccessful()) {
            throw new IllegalArgumentException("AuthReponse is invalid.");
        }
        this.setToken(auth.access_token);
        this.setId(auth.user_id);
    }

    public boolean setOffline() {
        if (!this.hasToken()) {
            return false;
        }
        try {
            AccountSetOfflineResponse resp = (AccountSetOfflineResponse)new AccountSetOffline().execute();
            return resp.isSuccessful();
        }
        catch (Exception e) {
            return false;
        }
    }
}

