/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.api.objects.IHistoryConversation;
import ru.curoviyxru.j2vk.api.objects.Message;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.user.Page;

public class Conversation
extends VKSerializableObject
implements IHistoryConversation {
    public Peer peer;
    public int inRead;
    public int outRead;
    public int unreadCount;
    public boolean important;
    public boolean unanswered;
    public CanWrite canWrite;
    public ChatSettings chatSettings;
    public PushSettings pushSettings;

    public long getId() {
        return this.hasPeer() ? this.peer.id : 0L;
    }

    public boolean isChannel() {
        return this.hasChatSettings() && this.chatSettings.isGroupChannel;
    }

    public boolean canWrite() {
        return this.hasCanWrite() && this.canWrite.allowed;
    }

    public boolean hasCanWrite() {
        return this.canWrite != null;
    }

    public long getLocalId() {
        return this.hasPeer() ? this.peer.localId : 0L;
    }

    public boolean hasPushSettings() {
        return this.pushSettings != null;
    }

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        JSONObject obj = json.optJSONObject("peer");
        if (obj != null) {
            this.peer = (Peer)new Peer().deserialize(obj);
        }
        if ((obj = json.optJSONObject("can_write")) != null) {
            this.canWrite = (CanWrite)new CanWrite().deserialize(obj);
        }
        if ((obj = json.optJSONObject("chat_settings")) != null) {
            this.chatSettings = (ChatSettings)new ChatSettings().deserialize(obj);
        }
        if ((obj = json.optJSONObject("push_settings")) != null) {
            this.pushSettings = (PushSettings)new PushSettings().deserialize(obj);
        }
        this.inRead = json.optInt("in_read");
        this.outRead = json.optInt("out_read");
        this.unreadCount = json.optInt("unread_count");
        this.important = json.optBoolean("important");
        this.unanswered = json.optBoolean("unanswered");
        return this;
    }

    public boolean isPage() {
        return this.hasPeer() && (this.peer.peerType.equals("user") || this.peer.peerType.equals("group")) && !this.isChannel();
    }

    public boolean isChat() {
        return !this.isPage() && !this.isChannel();
    }

    public boolean hasPeer() {
        return this.peer != null;
    }

    public String getTitle() {
        Page poster;
        Page page = poster = this.isPage() ? PageStorage.get(this.peer.id) : null;
        return this.isPage() ? (poster != null ? poster.getName() : null) : (this.hasChatSettings() ? this.chatSettings.title : null);
    }

    public String getPhoto_50() {
        return this.hasPhoto_100() ? this.chatSettings.photo.photo_50 : null;
    }

    public String getPhoto_100() {
        return this.hasPhoto_100() ? this.chatSettings.photo.photo_100 : null;
    }

    public boolean hasPhoto_50() {
        return this.hasChatSettings() && this.chatSettings.hasPhoto() && this.chatSettings.photo.hasPhoto_50();
    }

    public boolean hasPhoto_100() {
        return this.hasChatSettings() && this.chatSettings.hasPhoto() && this.chatSettings.photo.hasPhoto_100();
    }

    public boolean hasChatSettings() {
        return this.chatSettings != null;
    }

    public static class Peer
    extends VKSerializableObject {
        public static final String USER = "user";
        public static final String CHAT = "chat";
        public static final String GROUP = "group";
        public static final String EMAIL = "email";
        public long id;
        public long localId;
        public String peerType;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.id = json.optLong("id");
            this.localId = json.optLong("local_id");
            this.peerType = json.optString("type");
            return this;
        }
    }

    public static class CanWrite
    extends VKSerializableObject {
        public boolean allowed;
        public int reason;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.allowed = json.optBoolean("allowed");
            this.reason = json.optInt("reason");
            return this;
        }
    }

    public static class ConversationPhoto
    extends VKSerializableObject {
        public String photo_50;
        public String photo_100;

        public final boolean hasPhoto_50() {
            return !ConversationPhoto.isEmpty(this.photo_50);
        }

        public final boolean hasPhoto_100() {
            return !ConversationPhoto.isEmpty(this.photo_100);
        }

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.photo_50 = json.optString("photo_50");
            this.photo_100 = json.optString("photo_100");
            return this;
        }
    }

    public static class ChatSettings
    extends VKSerializableObject {
        public int membersCount;
        public String title;
        public String state;
        public Message pinnedMessage;
        public ConversationPhoto photo;
        public boolean isGroupChannel;
        public long[] activeIds;
        public long[] adminIds;
        public int owner_id;

        public boolean hasPinnedMessage() {
            return this.pinnedMessage != null;
        }

        public VKSerializableObject deserialize(JSONObject json) {
            int i;
            if (json == null) {
                return this;
            }
            this.owner_id = json.optInt("owner_id");
            this.membersCount = json.optInt("members_count");
            this.title = json.optString("title");
            this.state = json.optString("state");
            JSONObject obj = json.optJSONObject("pinned_message");
            if (obj != null) {
                this.pinnedMessage = (Message)new Message().deserialize(obj);
            }
            if ((obj = json.optJSONObject("photo")) != null) {
                this.photo = (ConversationPhoto)new ConversationPhoto().deserialize(obj);
            }
            this.isGroupChannel = json.optBoolean("is_group_channel");
            JSONArray array = json.optJSONArray("active_ids");
            if (array != null) {
                this.activeIds = new long[array.length()];
                for (i = 0; i < this.activeIds.length; ++i) {
                    this.activeIds[i] = array.optLong(i);
                }
            }
            if ((array = json.optJSONArray("admin_ids")) != null) {
                this.adminIds = new long[array.length()];
                for (i = 0; i < this.adminIds.length; ++i) {
                    this.adminIds[i] = array.optLong(i);
                }
            }
            return this;
        }

        public boolean hasPhoto() {
            return this.photo != null;
        }

        public boolean isAdmin(long fromId) {
            if ((long)this.owner_id == fromId) {
                return true;
            }
            if (!this.hasAdminIds()) {
                return false;
            }
            for (int i = 0; i < this.adminIds.length; ++i) {
                if (fromId != this.adminIds[i]) continue;
                return true;
            }
            return false;
        }

        public boolean hasAdminIds() {
            return this.adminIds != null && this.adminIds.length > 0;
        }
    }

    public static class PushSettings
    extends VKSerializableObject {
        public int disabled_until;
        public boolean disabled_forever;
        public boolean no_sound;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.disabled_until = json.optInt("disabled_until");
            this.disabled_forever = json.optBoolean("disabled_forever");
            this.no_sound = json.optBoolean("no_sound");
            return this;
        }
    }
}

