/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.TextUtil;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.Conversation;
import ru.curoviyxru.j2vk.api.objects.ImItem;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.user.Page;
import ru.curoviyxru.j2vk.api.objects.user.User;

public class Message
extends VKSerializableObject
implements ImItem {
    public long peerId;
    public long fromId;
    public long randomId;
    public int id;
    public int date;
    public int updateTime;
    public int conversationMessageId;
    public Attachment[] attachments;
    public boolean important;
    public boolean out;
    public Message[] fwdMessages;
    public Message replyMessage;
    public ChatAction action;
    public String text;
    public static String LOCALE_YOU = "\u0412\u044b";
    public static String LOCALE_CREATED_IT = "\u0441\u043e\u0437\u0434\u0430\u043b\u043e \u0431\u0435\u0441\u0435\u0434\u0443";
    public static String LOCALE_CREATED_M = "\u0441\u043e\u0437\u0434\u0430\u043b \u0431\u0435\u0441\u0435\u0434\u0443";
    public static String LOCALE_CREATED_F = "\u0441\u043e\u0437\u0434\u0430\u043b\u0430 \u0431\u0435\u0441\u0435\u0434\u0443";
    public static String LOCALE_JOINED_IT = "\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u043e\u0441\u044c";
    public static String LOCALE_JOINED_M = "\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f";
    public static String LOCALE_JOINED_F = "\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0430\u0441\u044c";
    public static String LOCALE_INVITED_IT = "\u043f\u0440\u0438\u0433\u043b\u0430\u0441\u0438\u043b\u043e";
    public static String LOCALE_INVITED_M = "\u043f\u0440\u0438\u0433\u043b\u0430\u0441\u0438\u043b";
    public static String LOCALE_INVITED_F = "\u043f\u0440\u0438\u0433\u043b\u0430\u0441\u0438\u043b\u0430";
    public static String LOCALE_TO_CHAT = "\u043a \u0431\u0435\u0441\u0435\u0434\u0435";
    public static String LOCALE_TO_CHAT_VIA_LINK = "\u043a \u0431\u0435\u0441\u0435\u0434\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435";
    public static String LOCALE_FROM_CHAT = "\u0438\u0437 \u0431\u0435\u0441\u0435\u0434\u044b";
    public static String LOCALE_KICKED_IT = "\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u043b\u043e";
    public static String LOCALE_KICKED_M = "\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u043b";
    public static String LOCALE_KICKED_F = "\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u043b\u0430";
    public static String LOCALE_LEFT_IT = "\u0432\u044b\u0448\u043b\u043e";
    public static String LOCALE_LEFT_M = "\u0432\u044b\u0448\u0435\u043b";
    public static String LOCALE_LEFT_F = "\u0432\u044b\u0448\u043b\u0430";
    public static String LOCALE_EMPTY = "*\u043f\u0443\u0441\u0442\u043e*";
    public static String LOCALE_ATTACH = "[\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435]";
    public static String LOCALE_ATTACHS = "[\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u044f]";
    public static String LOCALE_FORWARD = "[\u041f\u0435\u0440\u0435\u0441\u043b\u0430\u043d\u043d\u043e\u0435]";
    public static String LOCALE_FORWARDS = "[\u041f\u0435\u0440\u0435\u0441\u043b\u0430\u043d\u043d\u044b\u0435]";
    public static String LOCALE_REPLY = "[\u041e\u0442\u0432\u0435\u0442]";
    public static String LOCALE_CHAT_TITLE_TO = "\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u0435\u0441\u0435\u0434\u044b \u043d\u0430";
    public static String LOCALE_CHAT_PHOTO = "\u0444\u043e\u0442\u043e \u0431\u0435\u0441\u0435\u0434\u044b";
    public static String LOCALE_MESSAGE = "\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435";
    public static String LOCALE_UPDATED_IT = "\u043e\u0431\u043d\u043e\u0432\u0438\u043b\u043e";
    public static String LOCALE_UPDATED_M = "\u043e\u0431\u043d\u043e\u0432\u0438\u043b";
    public static String LOCALE_UPDATED_F = "\u043e\u0431\u043d\u043e\u0432\u0438\u043b\u0430";
    public static String LOCALE_REMOVED_IT = "\u0443\u0434\u0430\u043b\u0438\u043b\u043e";
    public static String LOCALE_REMOVED_M = "\u0443\u0434\u0430\u043b\u0438\u043b";
    public static String LOCALE_REMOVED_F = "\u0443\u0434\u0430\u043b\u0438\u043b\u0430";
    public static String LOCALE_PINNED_IT = "\u0437\u0430\u043a\u0440\u0435\u043f\u0438\u043b\u043e";
    public static String LOCALE_PINNED_M = "\u0437\u0430\u043a\u0440\u0435\u043f\u0438\u043b";
    public static String LOCALE_PINNED_F = "\u0437\u0430\u043a\u0440\u0435\u043f\u0438\u043b\u0430";
    public static String LOCALE_UNPINNED_IT = "\u043e\u0442\u043a\u0440\u0435\u043f\u0438\u043b\u043e";
    public static String LOCALE_UNPINNED_M = "\u043e\u0442\u043a\u0440\u0435\u043f\u0438\u043b";
    public static String LOCALE_UNPINNED_F = "\u043e\u0442\u043a\u0440\u0435\u043f\u0438\u043b\u0430";

    public VKSerializableObject deserialize(JSONObject json) {
        JSONObject obj;
        JSONObject obj1;
        int i;
        if (json == null) {
            return this;
        }
        this.updateTime = json.optInt("update_time");
        this.id = json.optInt("id");
        this.out = Message.fromInteger(json.optInt("out"));
        this.conversationMessageId = json.optInt("conversation_message_id");
        this.date = json.optInt("date");
        this.peerId = json.optLong("peer_id");
        this.fromId = json.optLong("from_id");
        this.text = json.optString("text");
        this.randomId = json.optLong("random_id");
        JSONArray array = json.optJSONArray("attachments");
        if (array != null) {
            this.attachments = new Attachment[array.length()];
            for (i = 0; i < this.attachments.length; ++i) {
                obj1 = array.optJSONObject(i);
                if (obj1 == null) continue;
                this.attachments[i] = Attachment.parse(obj1);
            }
        }
        this.important = json.optBoolean("important");
        array = json.optJSONArray("fwd_messages");
        if (array != null) {
            this.fwdMessages = new Message[array.length()];
            for (i = 0; i < this.fwdMessages.length; ++i) {
                obj1 = array.optJSONObject(i);
                if (obj1 == null) continue;
                this.fwdMessages[i] = (Message)new Message().deserialize(obj1);
            }
        }
        if ((obj = json.optJSONObject("reply_message")) != null) {
            this.replyMessage = (Message)new Message().deserialize(obj);
        }
        if ((obj = json.optJSONObject("action")) != null) {
            this.action = (ChatAction)new ChatAction().deserialize(obj);
        }
        return this;
    }

    public boolean hasChatAction() {
        return this.action != null && !Message.isEmpty(this.action.type);
    }

    public boolean hasForwardedMessages() {
        return this.fwdMessages != null && this.fwdMessages.length > 0;
    }

    public boolean hasReplyMessage() {
        return this.replyMessage != null;
    }

    public String toString(boolean showName, boolean isPMs, boolean shortName, boolean mentionReply, boolean mentionFwd) {
        Page u;
        Page p;
        String str2 = "";
        if (showName) {
            p = PageStorage.get(this.fromId);
            str2 = !isPMs ? str2 + (this.out ? LOCALE_YOU : (p != null ? (shortName ? p.getMessageTitle() : p.getName()) : "")) : str2 + (this.out ? LOCALE_YOU : "");
            if (!isPMs || this.out) {
                str2 = str2 + ": ";
            }
        }
        if (this.hasChatAction()) {
            boolean myself;
            p = PageStorage.get(this.fromId);
            String str1 = "";
            boolean bl = myself = (long)this.action.memberId == this.fromId;
            if (showName) {
                str1 = str1 + (p != null ? (!shortName ? p.getName() : p.getMessageTitle()) : "");
                str1 = str1 + " ";
            }
            if (this.action.type.equals("chat_create")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_CREATED_IT : (((User)p).sex == 1 ? LOCALE_CREATED_F : LOCALE_CREATED_M));
                }
                str1 = str1 + " \"" + this.action.text + "\"";
            } else if (this.action.type.equals("chat_invite_user")) {
                if (p != null) {
                    str1 = !myself ? str1 + (p.isGroup ? LOCALE_INVITED_IT : (((User)p).sex == 1 ? LOCALE_INVITED_F : LOCALE_INVITED_M)) : str1 + (p.isGroup ? LOCALE_JOINED_IT : (((User)p).sex == 1 ? LOCALE_JOINED_F : LOCALE_JOINED_M));
                }
                if (!myself) {
                    p = PageStorage.get(this.action.memberId);
                    if (p != null) {
                        str1 = str1 + " " + (shortName ? p.getMessageTitle("acc") : p.getName("acc"));
                    }
                } else {
                    str1 = str1 + " " + LOCALE_TO_CHAT;
                }
            } else if (this.action.type.equals("chat_kick_user")) {
                if (p != null) {
                    str1 = !myself ? str1 + (p.isGroup ? LOCALE_KICKED_IT : (((User)p).sex == 1 ? LOCALE_KICKED_F : LOCALE_KICKED_M)) : str1 + (p.isGroup ? LOCALE_LEFT_IT : (((User)p).sex == 1 ? LOCALE_LEFT_F : LOCALE_LEFT_M));
                }
                if (!myself) {
                    p = PageStorage.get(this.action.memberId);
                    if (p != null) {
                        str1 = str1 + " " + (shortName ? p.getMessageTitle("acc") : p.getName("acc"));
                    }
                } else {
                    str1 = str1 + " " + LOCALE_FROM_CHAT;
                }
            } else if (this.action.type.equals("chat_invite_user_by_link")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_JOINED_IT : (((User)p).sex == 1 ? LOCALE_JOINED_F : LOCALE_JOINED_M));
                }
                str1 = str1 + " " + LOCALE_TO_CHAT_VIA_LINK;
            } else if (this.action.type.equals("chat_photo_remove")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_REMOVED_IT : (((User)p).sex == 1 ? LOCALE_REMOVED_F : LOCALE_REMOVED_M));
                }
                str1 = str1 + " " + LOCALE_CHAT_PHOTO;
            } else if (this.action.type.equals("chat_photo_update")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_UPDATED_IT : (((User)p).sex == 1 ? LOCALE_UPDATED_F : LOCALE_UPDATED_M));
                }
                str1 = str1 + " " + LOCALE_CHAT_PHOTO;
            } else if (this.action.type.equals("chat_title_update")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_UPDATED_IT : (((User)p).sex == 1 ? LOCALE_UPDATED_F : LOCALE_UPDATED_M));
                }
                str1 = str1 + " " + LOCALE_CHAT_TITLE_TO + " \"" + this.action.text + "\"";
            } else if (this.action.type.equals("chat_unpin_message")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_UNPINNED_IT : (((User)p).sex == 1 ? LOCALE_UNPINNED_F : LOCALE_UNPINNED_M));
                }
                str1 = str1 + " " + LOCALE_MESSAGE;
            } else if (this.action.type.equals("chat_pin_message")) {
                if (p != null) {
                    str1 = str1 + (p.isGroup ? LOCALE_PINNED_IT : (((User)p).sex == 1 ? LOCALE_PINNED_F : LOCALE_PINNED_M));
                }
                str1 = str1 + " " + LOCALE_MESSAGE;
                if (!Message.isEmpty(this.action.message)) {
                    str1 = str1 + " \"" + (this.action.message.length() > 24 ? this.action.message.substring(0, 24) + "..." : this.action.message) + "\"";
                }
            }
            return str1;
        }
        if (mentionReply && this.hasReplyMessage() && (u = PageStorage.get(this.replyMessage.fromId)) != null) {
            str2 = str2 + LOCALE_REPLY + "\n";
        }
        if (this.hasAttachments()) {
            str2 = this.attachments.length > 1 ? str2 + LOCALE_ATTACHS + "\n" : str2 + LOCALE_ATTACH + "\n";
        }
        if (mentionFwd && this.hasForwardedMessages()) {
            str2 = this.fwdMessages.length > 1 ? str2 + LOCALE_FORWARDS + "\n" : str2 + LOCALE_FORWARD + "\n";
        }
        if (!TextUtil.isNullOrEmpty(this.text)) {
            str2 = str2 + this.text.trim();
        } else if (!this.hasAttachments() && mentionFwd && !this.hasForwardedMessages()) {
            str2 = str2 + LOCALE_EMPTY;
        }
        return str2;
    }

    public String toString() {
        return this.toString(false, false, false, true, true);
    }

    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.length > 0;
    }

    public int getLastTime() {
        return this.updateTime > this.date ? this.updateTime : this.date;
    }

    public boolean hasText() {
        return !TextUtil.isNullOrEmpty(this.text);
    }

    public boolean canEdDel() {
        return (System.currentTimeMillis() / 1000L - (long)this.date) / 86400L < 1L;
    }

    public boolean out() {
        return this.out;
    }

    public int id() {
        return this.id;
    }

    public long fromId() {
        return this.fromId;
    }

    public ImItem replyMessage() {
        return this.replyMessage;
    }

    public Attachment[] attachments() {
        return this.attachments;
    }

    public String text() {
        return this.text;
    }

    public long ownerId() {
        return this.peerId;
    }

    public boolean isDeleted() {
        return false;
    }

    public ImItem[] forwardedMessages() {
        return this.fwdMessages;
    }

    public static class ChatAction
    extends VKSerializableObject {
        public String text;
        public String email;
        public String type;
        public String message;
        public int memberId;
        public Conversation.ConversationPhoto photo;
        public static final String chat_photo_update = "chat_photo_update";
        public static final String chat_photo_remove = "chat_photo_remove";
        public static final String chat_create = "chat_create";
        public static final String chat_title_update = "chat_title_update";
        public static final String chat_invite_user = "chat_invite_user";
        public static final String chat_kick_user = "chat_kick_user";
        public static final String chat_pin_message = "chat_pin_message";
        public static final String chat_unpin_message = "chat_unpin_message";
        public static final String chat_invite_user_by_link = "chat_invite_user_by_link";

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.text = json.optString("text");
            this.email = json.optString("email");
            this.type = json.optString("type");
            this.memberId = json.optInt("member_id");
            this.message = json.optString("message");
            JSONObject obj = json.optJSONObject("photo");
            if (obj != null) {
                this.photo = (Conversation.ConversationPhoto)new Conversation.ConversationPhoto().deserialize(obj);
            }
            return this;
        }

        public boolean equals(String str) {
            return !ChatAction.isEmpty(this.type) && !ChatAction.isEmpty(str) && this.type.equals(str);
        }
    }
}

