/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.Geo;
import ru.curoviyxru.j2vk.api.objects.Topic;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Comment;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.j2vk.api.objects.attachments.Post;
import ru.curoviyxru.j2vk.api.objects.attachments.Video;

public class Notification
extends VKSerializableObject {
    String type;
    int date;
    NotificationFeedback[] feedback;
    VKSerializableObject parent;
    NotificationReply reply;

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.type = json.optString("type");
        this.date = json.optInt("date");
        JSONObject obj = json.optJSONObject("parent");
        if (obj != null) {
            if (this.type.equals("mention_comments") || this.type.equals("comment_post") || this.type.equals("like_post") || this.type.equals("copy_post")) {
                this.parent = new Post().deserialize(obj);
            } else if (this.type.equals("comment_photo") || this.type.equals("like_photo") || this.type.equals("copy_photo") || this.type.equals("mention_comment_photo")) {
                this.parent = new Photo().deserialize(obj);
            } else if (this.type.equals("comment_video") || this.type.equals("like_video") || this.type.equals("copy_video") || this.type.equals("mention_comment_video")) {
                this.parent = new Video().deserialize(obj);
            } else if (this.type.equals("reply_comment") || this.type.equals("reply_comment_photo") || this.type.equals("reply_comment_video") || this.type.equals("reply_comment_market") || this.type.equals("like_comment") || this.type.equals("like_comment_photo") || this.type.equals("like_comment_video") || this.type.equals("like_comment_topic")) {
                this.parent = new Comment().deserialize(obj);
            } else if (this.type.equals("reply_topic")) {
                this.parent = new Topic().deserialize(obj);
            }
        }
        if ((obj = json.optJSONObject("feedback")) != null) {
            JSONArray feedbackItems = obj.optJSONArray("items");
            if (feedbackItems == null) {
                this.feedback = new NotificationFeedback[]{(NotificationFeedback)new NotificationFeedback().deserialize(obj)};
            } else {
                this.feedback = new NotificationFeedback[feedbackItems.length()];
                for (int i = 0; i < this.feedback.length; ++i) {
                    JSONObject item1 = feedbackItems.optJSONObject(i);
                    if (item1 == null) continue;
                    this.feedback[i] = (NotificationFeedback)new NotificationFeedback().deserialize(item1);
                }
            }
        }
        if ((obj = json.optJSONObject("reply")) != null) {
            this.reply = (NotificationReply)new NotificationReply().deserialize(obj);
        }
        return this;
    }

    public static class NotificationReply
    extends VKSerializableObject {
        int id;
        int date;
        String text;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.id = json.optInt("id");
            this.date = json.optInt("date");
            this.text = json.optString("text");
            return this;
        }
    }

    public static class NotificationFeedback
    extends VKSerializableObject {
        int id;
        long to_id;
        long from_id;
        String text;
        Post.Likes likes;
        Attachment[] attachments;
        Geo geo;

        public VKSerializableObject deserialize(JSONObject json) {
            JSONArray array;
            if (json == null) {
                return this;
            }
            this.id = json.optInt("id");
            this.to_id = json.optLong("to_id");
            this.from_id = json.optLong("from_id");
            this.text = json.optString("text");
            JSONObject obj = json.optJSONObject("likes");
            if (obj != null) {
                this.likes = (Post.Likes)new Post.Likes().deserialize(obj);
            }
            if ((obj = json.optJSONObject("geo")) != null) {
                this.geo = (Geo)new Geo().deserialize(obj);
            }
            if ((array = json.optJSONArray("attachments")) != null) {
                this.attachments = new Attachment[array.length()];
                for (int i = 0; i < this.attachments.length; ++i) {
                    JSONObject obj1 = array.optJSONObject(i);
                    if (obj1 == null) continue;
                    this.attachments[i] = Attachment.parse(obj1);
                }
            }
            return this;
        }
    }
}

