/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ru.curoviyxru.j2vk.TextUtil;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.requests.VKRequest;

public class VKObject
extends VKConstants {
    public static String[] MONTH_NAMES = new String[]{"", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static boolean isEmpty(String str) {
        return TextUtil.isNullOrEmpty(str);
    }

    public static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }

    public static String onlyTimeToString(int date) {
        return TextUtil.getTimeString(date, false);
    }

    public static String dateToString(int date) {
        int[] lD = TextUtil.createDateArray(date);
        return TextUtil.makeTwo(lD[3]) + " " + MONTH_NAMES[lD[4]];
    }

    public static String timeToString(int date) {
        if (System.currentTimeMillis() / 1000L / 86400L - (long)(date / 86400) > 0L) {
            return VKObject.dateToString(date);
        }
        return VKObject.onlyTimeToString(date);
    }

    public static String trackTimeToString(long date) {
        long hours = date / 60L;
        long mins = date % 60L;
        return hours + ":" + TextUtil.makeTwo(mins);
    }

    public static String formatArgs(VKRequest args) {
        StringBuffer str = new StringBuffer();
        if (args == null) {
            return str.toString();
        }
        Hashtable table = args.getArguments();
        Enumeration args1 = table.keys();
        while (args1.hasMoreElements()) {
            String arg = (String)args1.nextElement();
            String val = (String)table.get(arg);
            if (str.length() > 0) {
                str.append('&');
            }
            str.append(arg).append('=').append(val);
        }
        return str.toString();
    }

    public static String join(String joiner, Vector v) {
        StringBuffer str = new StringBuffer();
        if (v == null || joiner == null) {
            return str.toString();
        }
        for (int i = 0; i < v.size(); ++i) {
            Object obj = v.elementAt(i);
            if (obj == null) continue;
            if (str.length() > 0) {
                str.append(joiner);
            }
            str.append(obj.toString());
        }
        return str.toString();
    }

    public static boolean fromInteger(int val) {
        return val == 1;
    }
}

