/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;

public class AudioMessage
extends Attachment {
    public int id;
    public long owner_id;
    public int duration;
    public int[] waveform;
    public String link_ogg;
    public String link_mp3;
    public int minWaveform = Integer.MAX_VALUE;
    public int maxWaveform = Integer.MIN_VALUE;

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.id = json.optInt("id");
        this.owner_id = json.optLong("owner_id");
        this.duration = json.optInt("duration");
        this.link_ogg = json.optString("link_ogg");
        this.link_mp3 = json.optString("link_mp3");
        JSONArray array = json.optJSONArray("waveform");
        if (array != null) {
            this.waveform = new int[array.length()];
            for (int i = 0; i < this.waveform.length; ++i) {
                this.waveform[i] = array.optInt(i);
                this.minWaveform = Math.min(this.minWaveform, this.waveform[i]);
                this.maxWaveform = Math.max(this.maxWaveform, this.waveform[i]);
            }
        }
        return this;
    }

    public boolean hasMP3() {
        return !AudioMessage.isEmpty(this.link_mp3);
    }

    public String toString() {
        return "audio_message" + this.owner_id + "_" + this.id;
    }
}

