/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Audio;

public class AudioPlaylist
extends Attachment {
    public int id;
    public int type;
    public long owner_id;
    public String title;
    public String description;
    public Audio.Genre[] genres;
    public Audio.Thumbs photo;
    public Audio.Artist[] main_artists;
    public String access_key;

    public String toString() {
        return "audio_playlist" + this.owner_id + "_" + this.id;
    }

    public VKSerializableObject deserialize(JSONObject json) {
        JSONObject item;
        int i;
        JSONArray arr;
        if (json == null) {
            return this;
        }
        this.id = json.optInt("id");
        this.owner_id = json.optLong("owner_id");
        this.type = json.optInt("type");
        this.title = json.optString("title");
        this.access_key = json.optString("access_key");
        JSONObject obj = json.optJSONObject("photo");
        if (obj != null) {
            this.photo = (Audio.Thumbs)new Audio.Thumbs().deserialize(obj);
        }
        if ((arr = json.optJSONArray("main_artists")) != null) {
            this.main_artists = new Audio.Artist[arr.length()];
            for (i = 0; i < arr.length(); ++i) {
                item = arr.optJSONObject(i);
                if (item == null) continue;
                this.main_artists[i] = (Audio.Artist)new Audio.Artist().deserialize(item);
            }
        }
        if ((arr = json.optJSONArray("genres")) != null) {
            this.genres = new Audio.Genre[arr.length()];
            for (i = 0; i < arr.length(); ++i) {
                item = arr.optJSONObject(i);
                if (item == null) continue;
                this.genres[i] = (Audio.Genre)new Audio.Genre().deserialize(item);
            }
        }
        return this;
    }

    public String bottom() {
        if (!this.hasArtists()) {
            return this.description;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.main_artists.length; ++i) {
            Audio.Artist a = this.main_artists[i];
            if (a == null || a.name == null) continue;
            b.append(a.name);
            if (i == this.main_artists.length - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }

    public boolean hasArtists() {
        return this.main_artists != null && this.main_artists.length > 0;
    }
}

