/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.TextUtil;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.ImItem;
import ru.curoviyxru.j2vk.api.objects.Likeable;
import ru.curoviyxru.j2vk.api.objects.Message;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Post;
import ru.curoviyxru.j2vk.api.objects.user.Page;

public class Comment
extends Attachment
implements Likeable,
ImItem {
    public int id;
    public long fromId;
    public long ownerId;
    public int date;
    public int replyToUser;
    public int replyToComment;
    public String text;
    int[] parents_stack;
    public Attachment[] attachments;
    public Thread thread;
    public Post.Likes likes;
    public int postId;
    public boolean out;
    public Comment replyMessage;
    public boolean deleted;
    public static String COMMENT_DELETED = "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0443\u0434\u0430\u043b\u0451\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0438\u043b\u0438 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u0435\u043c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b";

    public boolean isDeleted() {
        return this.deleted || this.fromId == 0L;
    }

    public boolean hasThread() {
        return this.thread != null;
    }

    public String toString(boolean showName, boolean isPMs, boolean shortName, boolean mentionReply, boolean mentionFwd) {
        Page u;
        if (this.isDeleted()) {
            return COMMENT_DELETED;
        }
        String str2 = "";
        if (showName) {
            Page p = PageStorage.get(this.fromId);
            str2 = !isPMs ? str2 + (this.out ? Message.LOCALE_YOU : (p != null ? (shortName ? p.getMessageTitle() : p.getName()) : "")) : str2 + (this.out ? Message.LOCALE_YOU : "");
            if (!isPMs || this.out) {
                str2 = str2 + ": ";
            }
        }
        if (mentionReply && this.hasReplyMessage() && (u = PageStorage.get(this.replyMessage.fromId)) != null) {
            str2 = str2 + Message.LOCALE_REPLY + "\n";
        }
        if (this.hasAttachments()) {
            str2 = this.attachments.length > 1 ? str2 + Message.LOCALE_ATTACHS + "\n" : str2 + Message.LOCALE_ATTACH + "\n";
        }
        if (!TextUtil.isNullOrEmpty(this.text)) {
            str2 = str2 + this.text.trim();
        }
        return str2;
    }

    public String toString() {
        return "wall_reply" + this.ownerId + "_" + this.id;
    }

    public boolean hasReplyMessage() {
        return this.replyMessage != null;
    }

    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.length > 0;
    }

    public boolean hasReplyUser() {
        return this.replyToUser != 0;
    }

    public boolean hasText() {
        return !Comment.isEmpty(this.text);
    }

    public boolean canEdDel() {
        return true;
    }

    public int getLastTime() {
        return this.date;
    }

    public VKSerializableObject deserialize(JSONObject json) {
        int i;
        JSONArray array;
        if (json == null) {
            return this;
        }
        this.deleted = json.optBoolean("deleted");
        this.id = json.optInt("id");
        this.fromId = json.optLong("from_id");
        this.out = this.fromId == Comment.account.id;
        this.date = json.optInt("date");
        this.replyToUser = json.optInt("reply_to_user");
        this.replyToComment = json.optInt("reply_to_comment");
        this.text = json.optString("text");
        this.postId = json.optInt("post_id");
        this.ownerId = json.optLong("owner_id");
        JSONObject obj1 = json.optJSONObject("thread");
        this.thread = (Thread)new Thread().deserialize(obj1);
        obj1 = json.optJSONObject("likes");
        if (obj1 != null) {
            this.likes = (Post.Likes)new Post.Likes().deserialize(obj1);
        }
        if ((array = json.optJSONArray("parents_stack")) != null) {
            this.parents_stack = new int[array.length()];
            for (i = 0; i < this.parents_stack.length; ++i) {
                this.parents_stack[i] = array.optInt(i);
            }
        }
        if ((array = json.optJSONArray("attachments")) != null) {
            this.attachments = new Attachment[array.length()];
            for (i = 0; i < this.attachments.length; ++i) {
                JSONObject obj = array.optJSONObject(i);
                if (obj == null) continue;
                this.attachments[i] = Attachment.parse(obj);
            }
        }
        return this;
    }

    public String getLikeableType() {
        return "comment";
    }

    public long getLikeableOwnerId() {
        return this.ownerId;
    }

    public int getLikeableItemsId() {
        return this.id;
    }

    public boolean out() {
        return this.out;
    }

    public int id() {
        return this.id;
    }

    public long fromId() {
        return this.fromId;
    }

    public ImItem replyMessage() {
        return this.replyMessage;
    }

    public Attachment[] attachments() {
        return this.attachments;
    }

    public String text() {
        return this.text;
    }

    public long ownerId() {
        return this.ownerId;
    }

    public boolean hasForwadedMessages() {
        return false;
    }

    public boolean hasForwardedMessages() {
        return false;
    }

    public ImItem[] forwardedMessages() {
        return null;
    }

    public static class Thread
    extends VKSerializableObject {
        public int count;
        public Comment[] items;
        public boolean can_post;
        public boolean show_reply_button;
        public boolean groups_can_post;

        public boolean hasItems() {
            return this.items != null && this.items.length > 0;
        }

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.count = json.optInt("count");
            this.can_post = json.optBoolean("can_post");
            this.show_reply_button = json.optBoolean("show_reply_button");
            this.groups_can_post = json.optBoolean("groups_can_post");
            JSONArray array = json.optJSONArray("items");
            if (array != null) {
                this.items = new Comment[array.length()];
                for (int i = 0; i < this.items.length; ++i) {
                    JSONObject obj = array.optJSONObject(i);
                    if (obj == null) continue;
                    this.items[i] = (Comment)new Comment().deserialize(obj);
                }
            }
            return this;
        }
    }
}

