/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Graffiti;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;

public class Document
extends Attachment {
    public int id;
    public int size;
    public int date;
    public int type;
    public long owner_id;
    public String title;
    public String ext;
    public String url;
    public static final int TEXT = 1;
    public static final int ARCHIVE = 2;
    public static final int GIF = 3;
    public static final int IMAGE = 4;
    public static final int AUDIO = 5;
    public static final int VIDEO = 6;
    public static final int EBOOK = 7;
    public static final int UNKNOWN = 8;
    public DocumentPreview preview;

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.id = json.optInt("id");
        this.owner_id = json.optLong("owner_id");
        this.size = json.optInt("size");
        this.date = json.optInt("date");
        this.type = json.optInt("type");
        this.title = json.optString("title");
        this.ext = json.optString("ext");
        this.url = json.optString("url");
        JSONObject obj = json.optJSONObject("preview");
        if (obj != null) {
            this.preview = (DocumentPreview)new DocumentPreview().deserialize(obj);
        }
        return this;
    }

    public static String getSizeString(int size) {
        if (size >= 0x40000000) {
            return (float)((int)((float)size / 1.0737418E9f * 10.0f)) / 10.0f + " GiB";
        }
        if (size >= 0x100000) {
            return (float)((int)((float)size / 1048576.0f * 10.0f)) / 10.0f + " MiB";
        }
        if (size >= 1024) {
            return (float)((int)((float)size / 1024.0f * 10.0f)) / 10.0f + " KiB";
        }
        return size + " B";
    }

    public String bottom() {
        return this.title + "\n" + Document.getSizeString(this.size) + " - " + this.ext.toUpperCase();
    }

    public String toString() {
        return "doc" + this.owner_id + "_" + this.id;
    }

    public static class DocumentPreview
    extends VKSerializableObject {
        public Photo.Sizes sizes;
        public Graffiti graffiti;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            JSONObject obj = json.optJSONObject("photo");
            if (obj != null) {
                this.sizes = (Photo.Sizes)new Photo.Sizes().deserialize(obj);
            }
            if ((obj = json.optJSONObject("graffiti")) != null) {
                this.graffiti = (Graffiti)new Graffiti().deserialize(obj);
            }
            return this;
        }
    }
}

