/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.ImageAttachment;

public class Photo
extends Attachment
implements ImageAttachment {
    public int id;
    public int album_id;
    public int date;
    public long owner_id;
    public long user_id;
    public String text;
    public String access_key;
    public Sizes sizes;

    public boolean hasSizes() {
        return this.sizes != null && this.sizes.hasSizes();
    }

    public Size getSize(int width, boolean dnc) {
        return this.hasSizes() ? this.sizes.getSize(width, dnc) : null;
    }

    public boolean hasAccessKey() {
        return !Photo.isEmpty(this.access_key);
    }

    public String toString() {
        return "photo" + this.owner_id + "_" + this.id;
    }

    public String getURL(int nearWidth) {
        if (this.sizes == null) {
            return null;
        }
        Size s = this.sizes.getSize(nearWidth, false);
        if (s == null) {
            return null;
        }
        return s.url;
    }

    public String getURL(String size) {
        if (this.sizes == null) {
            return null;
        }
        Size s = this.sizes.getSize(size);
        if (s == null) {
            return null;
        }
        return s.url;
    }

    public int getWidth(int nearWidth) {
        if (this.sizes == null) {
            return nearWidth;
        }
        Size s = this.sizes.getSize(nearWidth, false);
        if (s == null) {
            return nearWidth;
        }
        return s.width > 0 ? s.width : nearWidth;
    }

    public int getHeight(int nearWidth) {
        if (this.sizes == null) {
            return nearWidth;
        }
        Size s = this.sizes.getSize(nearWidth, false);
        if (s == null) {
            return nearWidth;
        }
        return s.height > 0 ? s.height : nearWidth;
    }

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.id = json.optInt("id");
        this.album_id = json.optInt("album_id");
        this.owner_id = json.optLong("owner_id");
        this.user_id = json.optLong("user_id");
        this.date = json.optInt("date");
        this.text = json.optString("text");
        this.access_key = json.optString("access_key");
        this.sizes = (Sizes)new Sizes().deserialize(json);
        return this;
    }

    public static class Size
    extends VKSerializableObject {
        public String type;
        public String url;
        public int width;
        public int height;

        public boolean hasType() {
            return !Size.isEmpty(this.type);
        }

        public static int getMaxSize(char t) {
            switch (t) {
                case 's': {
                    return 75;
                }
                case 'm': 
                case 'o': {
                    return 130;
                }
                case 'x': {
                    return 604;
                }
                case 'p': {
                    return 200;
                }
                case 'q': {
                    return 320;
                }
                case 'r': {
                    return 510;
                }
                case 'y': {
                    return 807;
                }
                case 'z': {
                    return 1080;
                }
                case 'w': {
                    return 2560;
                }
            }
            return 0;
        }

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.type = json.optString("type");
            this.url = json.optString("url");
            this.width = json.optInt("width");
            this.height = json.optInt("height");
            if (this.hasType() && (this.width == 0 || this.height == 0)) {
                int calc = Size.getMaxSize(this.type.charAt(0));
                this.width = Math.max(this.width, calc);
                this.height = Math.max(this.height, calc);
            }
            return this;
        }
    }

    public static class Sizes
    extends VKSerializableObject {
        public Size[] sizes;

        public Size getSize(int width, boolean doNotCut) {
            int smallestIndex = -1;
            int smallest = Integer.MAX_VALUE;
            int biggestIndex = -1;
            int biggest = Integer.MIN_VALUE;
            for (int i = 0; i < this.sizes.length; ++i) {
                Size s = this.sizes[i];
                if (s == null) continue;
                if (s.width == width) {
                    return s;
                }
                if (!(s.width <= width || s.width >= smallest || doNotCut && s.type != null && (s.type.equals("o") || s.type.equals("p") || s.type.equals("q") || s.type.equals("r")))) {
                    smallest = s.width;
                    smallestIndex = i;
                }
                if (s.width <= biggest || doNotCut && s.type != null && (s.type.equals("o") || s.type.equals("p") || s.type.equals("q") || s.type.equals("r"))) continue;
                biggest = s.width;
                biggestIndex = i;
            }
            return smallestIndex != -1 ? this.sizes[smallestIndex] : (biggestIndex != -1 ? this.sizes[biggestIndex] : null);
        }

        public Size getSize(String size) {
            if (size != null) {
                for (int i = 0; i < this.sizes.length; ++i) {
                    Size s = this.sizes[i];
                    if (s == null || s.type == null || !s.type.equals(size)) continue;
                    return s;
                }
            }
            return this.getSize(Integer.MAX_VALUE, true);
        }

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            JSONArray array = json.optJSONArray("sizes");
            if (array != null) {
                this.sizes = new Size[array.length()];
                for (int i = 0; i < this.sizes.length; ++i) {
                    JSONObject obj = array.optJSONObject(i);
                    if (obj == null) continue;
                    this.sizes[i] = (Size)new Size().deserialize(obj);
                }
            }
            return this;
        }

        public boolean hasSizes() {
            return this.sizes != null && this.sizes.length > 0;
        }
    }
}

