/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.IHistoryConversation;
import ru.curoviyxru.j2vk.api.objects.Likeable;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;

public class Post
extends Attachment
implements Likeable,
IHistoryConversation {
    public String type;
    public long owner_id;
    public long from_id;
    public int date;
    public String post_type;
    public String text;
    public long signer_id;
    public boolean marked_as_ads;
    public Attachment[] attachments;
    public Comments comments;
    public Likes likes;
    public Reposts reposts;
    public int views_count;
    public boolean is_favorite;
    public int post_id;
    public Post[] copy_history;
    boolean isAdBool;
    public static final String TYPE_POST = "post";

    public String toString() {
        return "wall" + this.owner_id + "_" + this.post_id;
    }

    public boolean isAd() {
        return this.isAdBool;
    }

    public boolean hasCopyHistory() {
        return this.copy_history != null && this.copy_history.length > 0;
    }

    public VKSerializableObject deserialize(JSONObject json) {
        JSONObject jsonobjj;
        int i;
        if (json == null) {
            return this;
        }
        this.owner_id = json.has("owner_id") ? json.optLong("owner_id") : (json.has("to_id") ? json.optLong("to_id") : json.optLong("source_id"));
        this.from_id = json.optLong("from_id");
        this.type = json.optString("type");
        this.post_id = json.has("id") ? json.optInt("id") : json.optInt("post_id");
        this.date = json.optInt("date");
        this.text = json.optString("text");
        JSONObject obj = json.optJSONObject("comments");
        this.comments = (Comments)new Comments().deserialize(obj);
        obj = json.optJSONObject("likes");
        this.likes = (Likes)new Likes().deserialize(obj);
        obj = json.optJSONObject("reposts");
        this.reposts = (Reposts)new Reposts().deserialize(obj);
        obj = json.optJSONObject("views");
        if (obj != null) {
            this.views_count = obj.optInt("count");
        }
        this.post_type = json.optString("post_type");
        JSONArray array = json.optJSONArray("attachments");
        if (array != null) {
            this.attachments = new Attachment[array.length()];
            for (i = 0; i < this.attachments.length; ++i) {
                jsonobjj = array.optJSONObject(i);
                if (jsonobjj == null) continue;
                this.attachments[i] = Attachment.parse(jsonobjj);
            }
        }
        if ((array = json.optJSONArray("copy_history")) != null) {
            this.copy_history = new Post[array.length()];
            for (i = 0; i < this.copy_history.length; ++i) {
                jsonobjj = array.optJSONObject(i);
                if (jsonobjj == null) continue;
                this.copy_history[i] = (Post)new Post().deserialize(jsonobjj);
            }
        }
        this.signer_id = json.has("from_id") ? json.optLong("from_id") : json.optLong("signer_id");
        this.marked_as_ads = Post.fromInteger(json.optInt("marked_as_ads"));
        this.is_favorite = json.optBoolean("is_favorite");
        this.isAdBool = this.marked_as_ads || !Post.isEmpty(json.optString("ext_id")) && (!Post.isEmpty(this.type) || this.type.equals(TYPE_POST)) || json.has("authors_rec") || json.has("app_widget") || json.has("promo_button") || json.has("friends_recomm") || json.has("live_recommended");
        return this;
    }

    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.length > 0;
    }

    public boolean hasText() {
        return !Post.isEmpty(this.text);
    }

    public boolean hasSigner() {
        return this.signer_id != 0L;
    }

    public String getLikeableType() {
        return TYPE_POST;
    }

    public long getLikeableOwnerId() {
        return this.owner_id;
    }

    public int getLikeableItemsId() {
        return this.post_id;
    }

    public boolean canWrite() {
        return this.comments != null && this.comments.can_post;
    }

    public boolean hasChatSettings() {
        return false;
    }

    public long getId() {
        return this.post_id;
    }

    public String getTitle() {
        return "";
    }

    public long getLocalId() {
        return this.post_id;
    }

    public boolean isChat() {
        return true;
    }

    public static class Likes
    extends VKSerializableObject {
        public int count;
        public boolean user_likes;
        public boolean can_like;
        public boolean can_publish;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.count = json.optInt("count");
            this.user_likes = Likes.fromInteger(json.optInt("user_likes"));
            this.can_like = Likes.fromInteger(json.optInt("can_like"));
            this.can_publish = Likes.fromInteger(json.optInt("can_publish"));
            return this;
        }
    }

    public class Comments
    extends VKSerializableObject {
        public int count;
        public boolean can_post;
        public boolean groups_can_post;
        public boolean can_close;
        public boolean can_open;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.count = json.optInt("count");
            this.can_post = Comments.fromInteger(json.optInt("can_post"));
            this.groups_can_post = Comments.fromInteger(json.optInt("groups_can_post"));
            this.can_close = json.optBoolean("can_close");
            this.can_open = json.optBoolean("can_open");
            return this;
        }
    }

    public class Reposts
    extends VKSerializableObject {
        public int count;
        public boolean user_reposted;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.count = json.optInt("count");
            this.user_reposted = Reposts.fromInteger(json.optInt("user_reposted"));
            return this;
        }
    }
}

