/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.attachments;

import org.json.me.JSONArray;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.ImageAttachment;

public class Sticker
extends Attachment
implements ImageAttachment {
    public int product_id;
    public int sticker_id;
    public StickerImage[] images;

    public String getURL(int nearWidth) {
        if (this.images == null) {
            return null;
        }
        StickerImage s = this.getSize(nearWidth);
        if (s == null) {
            return null;
        }
        return s.url;
    }

    public int getHeight(int nearWidth) {
        if (this.images == null) {
            return nearWidth;
        }
        StickerImage s = this.getSize(nearWidth);
        if (s == null) {
            return nearWidth;
        }
        return s.height > 0 ? s.height : nearWidth;
    }

    public int getWidth(int nearWidth) {
        if (this.images == null) {
            return nearWidth;
        }
        StickerImage s = this.getSize(nearWidth);
        if (s == null) {
            return nearWidth;
        }
        return s.width > 0 ? s.width : nearWidth;
    }

    public StickerImage getSize(int width) {
        int smallestIndex = -1;
        int smallest = Integer.MAX_VALUE;
        int biggestIndex = -1;
        int biggest = Integer.MIN_VALUE;
        for (int i = 0; i < this.images.length; ++i) {
            StickerImage s = this.images[i];
            if (s == null) continue;
            if (s.width == width) {
                return s;
            }
            if (s.width > width && s.width < smallest) {
                smallest = s.width;
                smallestIndex = i;
            }
            if (s.width <= biggest) continue;
            biggest = s.width;
            biggestIndex = i;
        }
        return smallestIndex != -1 ? this.images[smallestIndex] : (biggestIndex != -1 ? this.images[biggestIndex] : null);
    }

    public VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.product_id = json.optInt("product_id");
        this.sticker_id = json.optInt("sticker_id");
        JSONArray array = json.optJSONArray("images");
        if (array != null) {
            this.images = new StickerImage[array.length()];
            for (int i = 0; i < this.images.length; ++i) {
                JSONObject obj = array.optJSONObject(i);
                if (obj == null) continue;
                this.images[i] = (StickerImage)new StickerImage().deserialize(obj);
            }
        }
        return this;
    }

    public boolean hasImages() {
        return this.images != null && this.images.length > 0;
    }

    public String toString() {
        return this.sticker_id + "";
    }

    public static class StickerImage
    extends VKSerializableObject {
        public String url;
        public int width;
        public int height;

        public VKSerializableObject deserialize(JSONObject json) {
            if (json == null) {
                return this;
            }
            this.url = json.optString("url");
            this.width = json.optInt("width");
            this.height = json.optInt("height");
            return this;
        }
    }
}

