/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.objects.user;

import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.j2vk.api.objects.user.Page;

public class Group
extends Page {
    public static final int OTHER_REASON = 0;
    public static final int SPAM_REASON = 1;
    public static final int INSULTING_REASON = 2;
    public static final int OFFTOPPING_REASON = 4;
    public static final int OBSCENING_REASON = 3;
    public static final int MODERATOR = 1;
    public static final int EDITOR = 2;
    public static final int ADMINISTATOR = 3;
    public static final int OPENED = 0;
    public static final int CLOSED = 1;
    public static final int PRIVATE = 2;
    public long id;
    public int is_closed;
    public int admin_level;
    public int invited_by;
    public String name;
    public String screen_name;
    public String deactivated;
    public String type;
    public String photo_50;
    public String photo_100;
    public String status;
    public boolean blacklisted;
    public boolean is_member;
    public boolean is_admin;
    public boolean is_advertiser;
    public boolean can_message;
    public int ban_end_date;
    public int members_count;
    public int ban_reason;
    public int audios_count;
    public int albums_count;
    public int photos_count;
    public int topics_count;
    public int docs_count;
    public int videos_count;
    public String ban_comment;
    public String description;
    public String activity;
    public int age_limits;
    public String city_title;
    public String country_title;
    public String site;
    public Photo crop_photo;

    public Group() {
        super(true);
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getPhoto_50() {
        return !Group.isEmpty(this.photo_50) ? this.photo_50 : null;
    }

    public final String getPhoto_100() {
        return !Group.isEmpty(this.photo_100) ? this.photo_100 : this.getPhoto_50();
    }

    public final String getName(String s) {
        return this.name;
    }

    public final long getId() {
        return -this.id;
    }

    public final VKSerializableObject deserialize(JSONObject json) {
        if (json == null) {
            return this;
        }
        this.id = json.optLong("id");
        this.is_closed = json.optInt("is_closed");
        this.admin_level = json.optInt("admin_level");
        this.invited_by = json.optInt("invited_by");
        this.name = json.optString("name");
        this.screen_name = json.optString("screen_name");
        this.deactivated = json.optString("deactivated");
        this.type = json.optString("type");
        this.photo_50 = json.optString("photo_50");
        this.photo_100 = json.optString("photo_100");
        this.members_count = json.optInt("members_count");
        this.is_member = Group.fromInteger(json.optInt("is_member"));
        this.is_admin = Group.fromInteger(json.optInt("is_admin"));
        this.is_advertiser = Group.fromInteger(json.optInt("is_advertiser"));
        this.status = json.optString("status");
        this.can_message = json.optBoolean("can_message");
        JSONObject obj = json.optJSONObject("ban_info");
        if (obj != null) {
            this.blacklisted = true;
            this.ban_comment = obj.optString("comment");
            this.ban_reason = obj.optInt("reason", -1);
            this.ban_end_date = obj.optInt("end_date");
        }
        if ((obj = json.optJSONObject("counters")) != null) {
            this.audios_count = obj.optInt("audios");
            this.albums_count = obj.optInt("albums");
            this.photos_count = obj.optInt("photos");
            this.videos_count = obj.optInt("videos");
            this.topics_count = obj.optInt("topics");
            this.docs_count = obj.optInt("docs");
        }
        this.description = json.optString("description");
        this.activity = json.optString("activity");
        this.age_limits = json.optInt("age_limits");
        this.site = json.optString("site");
        obj = json.optJSONObject("city");
        if (obj != null) {
            this.city_title = obj.optString("title");
        }
        if ((obj = json.optJSONObject("country")) != null) {
            this.country_title = obj.optString("title");
        }
        if ((obj = json.optJSONObject("crop_photo")) != null && (obj = obj.optJSONObject("photo")) != null) {
            this.crop_photo = (Photo)new Photo().deserialize(obj);
        }
        return this;
    }

    public String getShortName(String s) {
        return this.name == null || this.name.length() < 1 ? this.name : this.name.charAt(0) + ".";
    }

    public String getFirstName(String s) {
        return this.name;
    }

    public String getNickname() {
        return this.screen_name;
    }
}

