/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.api.responses.auth;

import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.api.objects.VKSerializableObject;
import ru.curoviyxru.j2vk.api.responses.VKResponse;

public class AuthResponse
extends VKResponse {
    public String access_token;
    public String captcha_sid;
    public String captcha_img;
    public String validation_type;
    public String phone_mask;
    public String validation_sid;
    public long user_id;

    public final boolean needs2FA() {
        return this.hasPhoneMask() || this.hasValidationType() || this.hasValidationSID();
    }

    public final boolean hasValidationSID() {
        return !AuthResponse.isEmpty(this.validation_sid);
    }

    public final boolean isAuthPairInvalid() {
        return this.hasErrorType() && this.error_type.equals("username_or_password_is_incorrect");
    }

    public final boolean isOTPFormatIncorrect() {
        return this.hasErrorType() && this.error_type.equals("otp_format_is_incorrect");
    }

    public final boolean isOTPWrong() {
        return this.hasErrorType() && this.error_type.equals("wrong_otp");
    }

    public final boolean needsCaptcha() {
        return this.hasCaptchaSID() || this.hasCaptchaImage();
    }

    public final boolean isSuccessful() {
        return super.isSuccessful() && this.isAuthorized();
    }

    public final boolean isAuthorized() {
        return this.hasAccessToken() && this.hasUserId();
    }

    public final boolean hasAccessToken() {
        return !AuthResponse.isEmpty(this.access_token);
    }

    public final boolean hasCaptchaSID() {
        return !AuthResponse.isEmpty(this.captcha_sid);
    }

    public final boolean hasCaptchaImage() {
        return !AuthResponse.isEmpty(this.captcha_img);
    }

    public final boolean hasValidationType() {
        return !AuthResponse.isEmpty(this.validation_type);
    }

    public final boolean hasPhoneMask() {
        return !AuthResponse.isEmpty(this.phone_mask);
    }

    public final boolean hasUserId() {
        return this.user_id > 0L;
    }

    public final VKSerializableObject deserialize(JSONObject obj) {
        super.deserialize(obj);
        if (obj == null) {
            return this;
        }
        this.access_token = obj.optString("access_token");
        this.captcha_sid = obj.optString("captcha_sid");
        this.captcha_img = obj.optString("captcha_img");
        this.validation_type = obj.optString("validation_type");
        this.phone_mask = obj.optString("phone_mask");
        this.validation_sid = obj.optString("validation_sid");
        this.user_id = obj.optLong("user_id");
        return this;
    }
}

