/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.auth;

import org.json.me.JSONException;
import org.json.me.JSONObject;
import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.Account;
import ru.curoviyxru.j2vk.api.requests.auth.AuthRequest;
import ru.curoviyxru.j2vk.api.requests.auth.AuthValidatePhone;
import ru.curoviyxru.j2vk.api.responses.auth.AuthResponse;
import ru.curoviyxru.j2vk.api.responses.auth.AuthValidatePhoneResponse;
import ru.curoviyxru.j2vk.auth.AuthorizationResponse;

public class Authorization {
    public static AuthorizationResponse authorize(String email, String password, String captcha, String sid, String tfa, boolean sms) throws Exception {
        JSONObject obj;
        AuthRequest req = new AuthRequest(email, password).setCaptchaKey(captcha).setCaptchaSID(sid).set2FACode(tfa).setSMSForced(sms);
        String result = HTTPClient.makeResponseUnsafe(req);
        try {
            obj = new JSONObject(result);
        }
        catch (JSONException e) {
            VKConstants.debug(0, e);
            obj = null;
        }
        AuthResponse response = (AuthResponse)req.newEmptyResponse();
        response = obj == null || response == null ? null : (AuthResponse)response.deserialize(obj);
        int secs = 0;
        if (response == null) {
            return new AuthorizationResponse(0, response, secs, obj);
        }
        if (response.hasValidationSID() && sms) {
            AuthValidatePhoneResponse resp = (AuthValidatePhoneResponse)new AuthValidatePhone(response.validation_sid).execute();
            if (resp != null) {
                secs = resp.delay;
            }
            if (secs < 120) {
                secs = 120;
            }
        }
        if (response.isSuccessful()) {
            VKConstants.account = new Account(response.access_token);
            return new AuthorizationResponse(4, response, secs, obj);
        }
        if (response.needs2FA()) {
            return new AuthorizationResponse(2, response, secs, obj);
        }
        if (response.needsCaptcha()) {
            return new AuthorizationResponse(1, response, secs, obj);
        }
        if (response.isAuthPairInvalid()) {
            return new AuthorizationResponse(3, response, secs, obj);
        }
        if (response.isOTPWrong()) {
            return new AuthorizationResponse(-2, response, secs, obj);
        }
        if (response.isOTPFormatIncorrect()) {
            return new AuthorizationResponse(-1, response, secs, obj);
        }
        if (response.isErrored()) {
            return new AuthorizationResponse(-3, response, secs, obj);
        }
        return new AuthorizationResponse(0, response, secs, obj);
    }

    public static class AuthSignals {
        public static final int UNKNOWN_ERROR = 0;
        public static final int NEEDS_CAPTCHA = 1;
        public static final int NEEDS_VERIFICATION = 2;
        public static final int INVALID_PASSWORD = 3;
        public static final int WRONG_OTP = -2;
        public static final int WRONG_OTP_FORMAT = -1;
        public static final int SUCCESSFUL = 4;
        public static final int SPECIFIC_ERROR = -3;
    }
}

