/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.j2vk.platform;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import ru.curoviyxru.j2vk.ProgressProvider;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.requests.VKRequest;
import ru.curoviyxru.j2vk.platform.Charset;
import ru.curoviyxru.j2vk.platform.IHTTPClient;

public class HTTPMEClient
implements IHTTPClient {
    public static boolean useFlush = false;

    public byte[] readStream(InputStream inputStream) throws Exception {
        int length;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        inputStream.close();
        byte[] bb = result.toByteArray();
        result.close();
        return bb;
    }

    public String getURLString(String request) {
        try {
            return new String(this.getURL(request), Charset.current);
        }
        catch (Exception e) {
            VKConstants.debug(0, e);
            return null;
        }
    }

    public Object openHttpConnection(String url, boolean checkForRedir) throws Exception {
        return this.openHttpConnection(url, checkForRedir, false);
    }

    public Object openHttpConnection(String url, boolean checkForRedir, boolean ignorePost) throws Exception {
        String refLink;
        if (VKConstants.apiUrl().startsWith("http:") && url.startsWith("https:")) {
            url = "http" + url.substring(5);
        }
        VKConstants.debug(0, "[OHC]: " + url);
        HttpConnection rawConnection = (HttpConnection)Connector.open((String)(VKConstants.proxyUrl != null && !url.startsWith("http:") ? VKConstants.proxyUrl : url));
        if (VKConstants.proxyUrl != null && !url.startsWith("http:")) {
            rawConnection.setRequestMethod("POST");
        }
        rawConnection.setRequestProperty("User-Agent", "VKAndroidApp/5.40-3906 (Android 6.0.0; SDK 23; armeabi-v7a; LGE Nexus 5; ru; 1920x1080)");
        if (VKConstants.proxyUrl != null && !url.startsWith("http:") && !ignorePost) {
            String boundary = System.currentTimeMillis() + "" + System.currentTimeMillis();
            byte[] boundaryBytes = ("--" + boundary + "\r\n").getBytes(Charset.current);
            byte[] finishBoundaryBytes = ("--" + boundary + "--").getBytes(Charset.current);
            rawConnection.setRequestProperty("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
            OutputStream out = rawConnection.openOutputStream();
            out.write(boundaryBytes);
            this.sendField(out, "proxy_link", url);
            out.write(finishBoundaryBytes);
            out.close();
        }
        if (checkForRedir && (refLink = rawConnection.getHeaderField("Location")) != null) {
            rawConnection.close();
            return this.openHttpConnection(refLink, checkForRedir, ignorePost);
        }
        return rawConnection;
    }

    public String makeResponse(VKRequest request) {
        if (request == null) {
            return null;
        }
        String str = request.toString();
        VKConstants.debug(0, "[REQ]: " + str);
        String raw = this.getURLString(str);
        VKConstants.debug(0, "[RES]: " + raw);
        return raw;
    }

    public String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ('A' <= c && c <= 'Z') {
                sb.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                sb.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                sb.append("%20");
                continue;
            }
            if (c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                sb.append(c);
                continue;
            }
            if (c <= '\u007f') {
                sb.append(HTTPMEClient.hex(c));
                continue;
            }
            if (c <= '\u07ff') {
                sb.append(HTTPMEClient.hex(0xC0 | c >> 6));
                sb.append(HTTPMEClient.hex(0x80 | c & 0x3F));
                continue;
            }
            sb.append(HTTPMEClient.hex(0xE0 | c >> 12));
            sb.append(HTTPMEClient.hex(0x80 | c >> 6 & 0x3F));
            sb.append(HTTPMEClient.hex(0x80 | c & 0x3F));
        }
        return sb.toString();
    }

    private static String hex(int i) {
        String s = Integer.toHexString(i);
        return "%" + (s.length() < 2 ? "0" : "") + s;
    }

    public byte[] getURL(String request) {
        try {
            HttpConnection conn = (HttpConnection)this.openHttpConnection(request, true);
            InputStream i = conn.openInputStream();
            byte[] buf = this.readStream(i);
            conn.close();
            return buf;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String uploadFile(String desturl, String field, String fileName, long fileLength, InputStream stream, ProgressProvider pp) throws Exception {
        try {
            String s = this._uploadFile(desturl, field, fileName, fileLength, stream, pp);
            if (pp != null) {
                if (s != null) {
                    pp.successful();
                } else {
                    pp.failed("Upload failed.");
                }
            }
            return s;
        }
        catch (Exception e) {
            if (pp != null) {
                pp.failed(e.toString());
            }
            throw e;
        }
    }

    public void sendFile(OutputStream out, String name, InputStream in, String fileName, long fileLength, ProgressProvider pp) throws Exception {
        fileLength = Math.max(fileLength, (long)in.available());
        String o = "Content-Disposition: form-data; name=\"" + this.urlEncode(name) + "\"; filename=\"" + this.urlEncode(fileName) + "\"\r\n\r\n";
        out.write(o.getBytes(Charset.current));
        byte[] buffer = new byte[2048];
        long readed = 0L;
        int n = 0;
        while (n >= 0) {
            readed += (long)n;
            out.write(buffer, 0, n);
            if (useFlush) {
                out.flush();
            }
            if (pp != null) {
                pp.setProgress(Math.max(0L, readed * 100L / fileLength - 1L));
            }
            n = in.read(buffer);
        }
        out.write("\r\n".getBytes(Charset.current));
    }

    public void sendField(OutputStream out, String name, String field) throws Exception {
        String o = "Content-Disposition: form-data; name=\"" + this.urlEncode(name) + "\"\r\n\r\n";
        out.write(o.getBytes(Charset.current));
        out.write(field.getBytes(Charset.current));
        out.write("\r\n".getBytes(Charset.current));
    }

    private String _uploadFile(String desturl, String field, String fileName, long fileLength, InputStream stream, ProgressProvider pp) throws Exception {
        VKConstants.debug(0, "[UPL]: " + desturl);
        String boundary = System.currentTimeMillis() + "" + System.currentTimeMillis();
        byte[] boundaryBytes = ("--" + boundary + "\r\n").getBytes(Charset.current);
        byte[] finishBoundaryBytes = ("--" + boundary + "--").getBytes(Charset.current);
        HttpConnection rawConnection = (HttpConnection)this.openHttpConnection(desturl, false, true);
        if (VKConstants.proxyUrl == null || desturl.startsWith("http:")) {
            rawConnection.setRequestMethod("POST");
        }
        rawConnection.setRequestProperty("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
        OutputStream out = rawConnection.openOutputStream();
        out.write(boundaryBytes);
        if (VKConstants.proxyUrl != null && !desturl.startsWith("http:")) {
            this.sendField(out, "proxy_link", desturl);
        }
        out.write(boundaryBytes);
        this.sendFile(out, field, stream, fileName, fileLength, pp);
        out.write(finishBoundaryBytes);
        out.close();
        InputStream in = rawConnection.openInputStream();
        String str = new String(this.readStream(in), Charset.current);
        rawConnection.close();
        if (pp != null) {
            pp.setProgress(100L);
        }
        return str;
    }

    public long downloadFile(String url, OutputStream s, ProgressProvider pp, int check) throws Exception {
        try {
            long l = this._downloadFile(url, s, pp, check);
            if (pp != null) {
                if (l != 0L) {
                    pp.successful();
                } else {
                    pp.failed("File corrupted.");
                }
            }
            return l;
        }
        catch (Exception e) {
            if (pp != null) {
                pp.failed(e.toString());
            }
            throw e;
        }
    }

    private long _downloadFile(String url, OutputStream oS, ProgressProvider pp, int check) throws Exception {
        int length;
        HttpConnection rawConnection = (HttpConnection)this.openHttpConnection(url, true);
        InputStream is = rawConnection.openInputStream();
        long avaliable = rawConnection.getLength();
        byte[] buffer = new byte[16384];
        long readed = 0L;
        while ((length = is.read(buffer)) != -1) {
            readed += (long)length;
            oS.write(buffer, 0, length);
            oS.flush();
            if (pp == null) continue;
            pp.setProgress(readed * 100L / avaliable);
        }
        is.close();
        rawConnection.close();
        oS.close();
        if (pp != null) {
            pp.setProgress(100L);
        }
        return avaliable;
    }

    public String makeResponseUnsafe(VKRequest request) throws Exception {
        int length;
        if (request == null) {
            return null;
        }
        String url = request.toString();
        VKConstants.debug(0, "[REQ]: " + url);
        HttpConnection rawConnection = (HttpConnection)this.openHttpConnection(url, true);
        if (rawConnection == null) {
            throw new Exception("Can't connect to destination.");
        }
        InputStream stream = rawConnection.openInputStream();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = stream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        stream.close();
        byte[] bb = result.toByteArray();
        result.close();
        rawConnection.close();
        String raw = new String(bb, Charset.current);
        VKConstants.debug(0, "[RES]: " + raw);
        return raw;
    }
}

