/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix;

import ru.curoviyxru.j2vk.api.objects.attachments.Audio;
import ru.curoviyxru.phoenix.HexMe;
import ru.curoviyxru.phoenix.midlet.Midlet;

public class AudioCache {
    public static final String[] transTable = new String[]{"A", "B", "V", "G", "D", "E", "ZH", "Z", "I", "I", "K", "L", "M", "N", "O", "P", "R", "S", "T", "U", "F", "KH", "TS", "CH", "SH", "SHCH", "IE", "Y", "", "E", "IU", "IA", "a", "b", "v", "g", "d", "e", "zh", "z", "i", "i", "k", "l", "m", "n", "o", "p", "r", "s", "t", "u", "f", "kh", "ts", "ch", "sh", "shch", "ie", "y", "", "e", "iu", "ia"};

    public static String get(Audio audio) {
        if (audio == null) {
            return null;
        }
        return AudioCache.getName(audio) + ".mp3";
    }

    private static String translit(String string) {
        if (!Midlet.instance.config.translitFiles) {
            return string;
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0410' && c <= '\u044f') {
                stringBuffer.append(transTable[c - 1040]);
                continue;
            }
            if (c == '\u0451') {
                stringBuffer.append('e');
                continue;
            }
            if (c == '\u0401') {
                stringBuffer.append('E');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String getName(Audio audio) {
        if (audio == null) {
            return null;
        }
        String string = AudioCache.translit(audio.artist);
        String string2 = AudioCache.translit(audio.title);
        String string3 = AudioCache.cleanNLimit(string) + " - " + AudioCache.cleanNLimit(string2) + " - " + AudioCache.getID(audio);
        if (string3.length() <= 46) {
            return string3;
        }
        string3 = AudioCache.cleanNLimit(string2) + " - " + AudioCache.getID(audio);
        if (string3.length() <= 46) {
            return string3;
        }
        return AudioCache.getID(audio);
    }

    private static String getID(Audio audio) {
        return new String(HexMe.basify(new byte[]{(byte)(audio.owner_id >>> 24), (byte)(audio.owner_id >>> 16), (byte)(audio.owner_id >>> 8), (byte)audio.owner_id, (byte)(audio.id >>> 24), (byte)(audio.id >>> 16), (byte)(audio.id >>> 8), (byte)audio.id, 0}));
    }

    private static String cleanNLimit(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 20) {
            stringBuffer.setLength(20);
        }
        return stringBuffer.toString().trim();
    }
}

