/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix;

import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.ProgressProvider;
import ru.curoviyxru.phoenix.ui.AppCanvas;

public class DownloadUtils {
    private static String mp3Type;
    private static Boolean hasHTTPS;

    public static String getMP3Type() {
        if (mp3Type != null) {
            return mp3Type;
        }
        try {
            String[] stringArray = Manager.getSupportedContentTypes(null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].toLowerCase().equals("audio/mp3")) continue;
                mp3Type = "audio/mp3";
                return "audio/mp3";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        mp3Type = "audio/mpeg";
        return "audio/mpeg";
    }

    public static boolean hasHTTPS() {
        if (hasHTTPS != null) {
            return hasHTTPS;
        }
        try {
            String[] stringArray = Manager.getSupportedProtocols(null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].toLowerCase().indexOf("https") == -1) continue;
                hasHTTPS = Boolean.TRUE;
                return hasHTTPS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hasHTTPS = Boolean.FALSE;
        return hasHTTPS;
    }

    public static boolean folderExists(String string) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)3);
            boolean bl = fileConnection.exists() && fileConnection.isDirectory() && fileConnection.canWrite() && fileConnection.canRead();
            fileConnection.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long downloadFile(String string, Object object, ProgressProvider progressProvider, int n) throws Exception {
        AppCanvas.instance.setProgress(true);
        try {
            long l = DownloadUtils._downloadFile(string, object, progressProvider, n);
            if (progressProvider != null) {
                if (l != 0L) {
                    progressProvider.successful();
                } else {
                    progressProvider.failed("Download failed.");
                }
            }
            AppCanvas.instance.setProgress(false);
            return l;
        }
        catch (Exception exception) {
            if (progressProvider != null) {
                progressProvider.failed(exception.toString());
            }
            AppCanvas.instance.setProgress(false);
            throw exception;
        }
    }

    public static long _downloadFile(String string, Object object, final ProgressProvider progressProvider, int n) throws Exception {
        FileConnection fileConnection = (FileConnection)object;
        if (!fileConnection.exists()) {
            fileConnection.create();
        }
        OutputStream outputStream = fileConnection.openOutputStream();
        DProgressProvider dProgressProvider = new DProgressProvider(){

            public void setProgress(long l) {
                if (progressProvider != null) {
                    progressProvider.setProgress(l);
                }
            }

            public void failed(String string) {
                this.failed = string;
                this.successful = false;
            }

            public void successful() {
                this.failed = null;
                this.successful = true;
            }

            public String getName() {
                if (progressProvider == null) {
                    return null;
                }
                return progressProvider.getName();
            }
        };
        long l = HTTPClient.downloadFile(string, outputStream, dProgressProvider, n);
        if (dProgressProvider.failed != null) {
            throw new Exception(dProgressProvider.failed);
        }
        if (progressProvider != null) {
            progressProvider.setProgress(100L);
        }
        return Math.max(fileConnection.fileSize(), l);
    }

    public static abstract class DProgressProvider
    implements ProgressProvider {
        String failed;
        boolean successful;
    }
}

