/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.TextUtil;
import ru.curoviyxru.j2vk.platform.Charset;
import ru.curoviyxru.phoenix.Logger;

public class Localization {
    public static LocaleEntry[] avaliable;
    public static Localization locale;
    public Hashtable table = new Hashtable();

    public Localization(String string) {
        this.parse(string);
    }

    public String getString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.table.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private void parse(String string) {
        if (string == null) {
            return;
        }
        try {
            Vector vector = TextUtil.split(string, "\n");
            for (int i = 0; i < vector.size(); ++i) {
                int n;
                String string2 = (String)vector.elementAt(i);
                if (string2 == null || string2.startsWith("#") || (n = string2.indexOf(61)) == -1) continue;
                String string3 = string2.substring(n + 1);
                String string4 = string2.substring(0, string2.length() - 1 - string3.length()).trim();
                this.table.put(string4, string3.trim());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.table = new Hashtable();
            System.gc();
        }
    }

    public static LocaleEntry[] avaliable() {
        if (avaliable != null) {
            return avaliable;
        }
        Vector<LocaleEntry> vector = new Vector<LocaleEntry>();
        try {
            String string = new String(HTTPClient.readStream(Runtime.getRuntime().getClass().getResourceAsStream("/lang/list.langs")), Charset.current);
            Vector vector2 = TextUtil.split(string, "\n");
            for (int i = 0; i < vector2.size(); ++i) {
                String string2 = (String)vector2.elementAt(i);
                if (string2 == null || string2.startsWith("#")) continue;
                Vector vector3 = TextUtil.split(string2, ";");
                LocaleEntry localeEntry = new LocaleEntry();
                if (vector3.size() > 2) {
                    localeEntry.version = ((String)vector3.elementAt(2)).trim();
                    localeEntry.name = ((String)vector3.elementAt(1)).trim();
                    localeEntry.code = ((String)vector3.elementAt(0)).trim();
                }
                if (TextUtil.isNullOrEmpty(localeEntry.code) || !Localization.exists(localeEntry.code)) continue;
                vector.addElement(localeEntry);
            }
            avaliable = new LocaleEntry[vector.size()];
            vector.copyInto(avaliable);
        }
        catch (Exception exception) {
            avaliable = new LocaleEntry[0];
            System.gc();
        }
        return avaliable;
    }

    public static String get(String string) {
        if (string == null) {
            return string;
        }
        return locale == null ? string : locale.getString(string);
    }

    public static String get(String string, String string2) {
        return Localization.get(string, string2, null);
    }

    public static String get(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        String string4 = Localization.get(string);
        if (string2 == null) {
            return string4;
        }
        string4 = TextUtil.easyReplace(string4, "%%", string2);
        if (string3 == null) {
            return string4;
        }
        string4 = TextUtil.easyReplace(string4, "%%", string3);
        return string4;
    }

    private static boolean exists(String string) {
        try {
            InputStream inputStream = Runtime.getRuntime().getClass().getResourceAsStream("/lang/" + string + ".lang");
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getSystem() {
        String string = System.getProperty("microedition.locale");
        if (string == null) {
            return "en";
        }
        LocaleEntry[] localeEntryArray = Localization.avaliable();
        for (int i = 0; i < localeEntryArray.length; ++i) {
            LocaleEntry localeEntry = localeEntryArray[i];
            if (localeEntry == null || localeEntry.code == null || string.indexOf(localeEntry.code) == -1) continue;
            return localeEntry.code;
        }
        return "en";
    }

    public static void loadSelected(String string) {
        try {
            locale = new Localization(new String(HTTPClient.readStream(Runtime.getRuntime().getClass().getResourceAsStream("/lang/" + string + ".lang")), Charset.current));
        }
        catch (Throwable throwable) {
            Logger.l(throwable);
            System.gc();
            locale = new Localization(null);
        }
    }

    public static class LocaleEntry {
        public String code;
        public String name;
        public String version;

        public void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeUTF(this.code == null ? "null" : this.code);
            dataOutputStream.writeUTF(this.name == null ? "null" : this.name);
            dataOutputStream.writeUTF(this.version == null ? "null" : this.version);
        }

        public void read(DataInputStream dataInputStream) throws Exception {
            this.code = dataInputStream.readUTF();
            this.name = dataInputStream.readUTF();
            this.version = dataInputStream.readUTF();
        }
    }
}

