/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import ru.curoviyxru.phoenix.ui.AppCanvas;

public class AnimationInterp {
    public static final byte INTERP_LINEAR = 0;
    public static final byte INTERP_SQR = 1;
    public static final byte INTERP_INVSQR = 2;
    public static final byte INTERP_SIN = 3;
    public boolean started;
    private long startedAt;
    private int animationLength;
    public int startValue;
    public int endValue;
    public int value;
    public byte interpolationType;

    public AnimationInterp(int n) {
        this.interpolationType = (byte)n;
    }

    public int getAnimationLasted() {
        if (!this.started) {
            return this.animationLength;
        }
        return (int)(System.currentTimeMillis() - this.startedAt);
    }

    public void startContinue(int n) {
        this.animationLength = n;
        this.startedAt = System.currentTimeMillis();
        this.started = true;
        this.startValue = this.value;
    }

    public void start(int n) {
        this.animationLength = n;
        this.startedAt = System.currentTimeMillis();
        this.started = true;
        this.value = this.startValue;
    }

    public void end() {
        this.value = this.endValue;
        this.started = false;
    }

    public boolean update() {
        if (!this.started) {
            return false;
        }
        long l = System.currentTimeMillis() - this.startedAt;
        if (l >= (long)this.animationLength) {
            this.end();
            return true;
        }
        switch (this.interpolationType) {
            case 1: {
                l = l * l / (long)this.animationLength;
                break;
            }
            case 2: {
                l = (long)this.animationLength - l;
                l = l * l / (long)this.animationLength;
                l = (long)this.animationLength - l;
                break;
            }
            case 3: {
                l = (int)AppCanvas.round((0.5 - Math.cos((double)l * Math.PI / (double)this.animationLength) / 2.0) * (double)this.animationLength);
                break;
            }
        }
        long l2 = (long)this.animationLength - l;
        this.value = (int)(((long)this.startValue * l2 + (long)this.endValue * l) / (long)this.animationLength);
        return false;
    }
}

