/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Graphics;
import midletintegration.MIDletIntegration;
import midletintegration.MIDletNotFoundException;
import midletintegration.ProtocolNotSupportedException;
import midletintegration.Util;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.ProgressProvider;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.PhotoAlbum;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.j2vk.api.objects.attachments.Audio;
import ru.curoviyxru.j2vk.api.objects.attachments.AudioMessage;
import ru.curoviyxru.j2vk.api.objects.attachments.AudioPlaylist;
import ru.curoviyxru.j2vk.api.objects.attachments.Comment;
import ru.curoviyxru.j2vk.api.objects.attachments.Document;
import ru.curoviyxru.j2vk.api.objects.attachments.Graffiti;
import ru.curoviyxru.j2vk.api.objects.attachments.ImageAttachment;
import ru.curoviyxru.j2vk.api.objects.attachments.Link;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.j2vk.api.objects.attachments.Post;
import ru.curoviyxru.j2vk.api.objects.attachments.Sticker;
import ru.curoviyxru.j2vk.api.objects.attachments.Video;
import ru.curoviyxru.j2vk.api.requests.audio.AudioAdd;
import ru.curoviyxru.j2vk.api.requests.execute.ExecuteGetPlaylist;
import ru.curoviyxru.j2vk.api.requests.wall.WallGetById;
import ru.curoviyxru.j2vk.api.responses.audio.AudioAddResponse;
import ru.curoviyxru.j2vk.api.responses.execute.ExecuteGetPlaylistResponse;
import ru.curoviyxru.j2vk.api.responses.wall.WallGetByIdResponse;
import ru.curoviyxru.phoenix.AudioCache;
import ru.curoviyxru.phoenix.DownloadUtils;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.kernel.FocusedProgressProvider;
import ru.curoviyxru.phoenix.kernel.ProgressKernel;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.FilePicker;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.PopupMenu;
import ru.curoviyxru.phoenix.ui.ProgressBar;
import ru.curoviyxru.phoenix.ui.RenderUtil;
import ru.curoviyxru.phoenix.ui.UserAudioView;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.ImageViewer;
import ru.curoviyxru.playvk.PlayerContent;
import ru.curoviyxru.playvk.Playlist;

public class AttachmentView
extends ListItem
implements ProgressProvider {
    ProgressBar bar;
    Attachment linked;
    int[] wfH;
    int[] wfY;
    int wfP;
    int lW;
    int lH;

    public AttachmentView(Attachment attachment) {
        super(attachment.toString(), (byte)3);
        this.noCircling = true;
        this.ignoreUnreadBackground = true;
        this.useFullTimestamp = true;
        this.setAttachment(attachment);
    }

    public void setAttachment(Attachment attachment) {
        this.linked = attachment;
        if (attachment == null) {
            return;
        }
        this.setFont(true);
        this.setStyle(attachment);
        this.initPP();
    }

    private void initPP() {
        FocusedProgressProvider focusedProgressProvider = ProgressKernel.getProvider(this.getName());
        if (focusedProgressProvider == null) {
            return;
        }
        focusedProgressProvider.setProvider(this);
    }

    private void setStyle(Attachment attachment) {
        if (attachment instanceof PhotoAlbum) {
            PhotoAlbum photoAlbum = (PhotoAlbum)attachment;
            String string = photoAlbum.description;
            if (VKObject.isEmpty(string)) {
                string = "";
            }
            this.setDescription(string);
            this.setPhotoAlbum((PhotoAlbum)attachment);
            this.setCaption(photoAlbum.title);
        } else if (attachment instanceof Photo) {
            String string = ((Photo)attachment).text;
            if (VKObject.isEmpty(string)) {
                string = "";
            }
            this.setDescription(string);
            this.setPhoto((Photo)attachment);
            this.setCaption(Localization.get("attachment.photo") + " #" + ((Photo)attachment).id);
        } else if (attachment instanceof Sticker) {
            this.setDescription(attachment.toString());
            this.setIcon("new/sticker-emoji.rle");
            this.setCaption(Localization.get("attachment.sticker"));
        } else if (attachment instanceof Audio) {
            Audio audio = (Audio)attachment;
            this.setDescription(audio.artist);
            this.setAudio(audio);
            this.setCaption(audio.title);
            this.setTimestamp(VKObject.trackTimeToString(audio.duration));
        } else if (attachment instanceof Graffiti) {
            this.setDescription(attachment.toString());
            this.setIcon("new/spray.rle");
            this.setCaption(Localization.get("attachment.graffiti"));
        } else if (attachment instanceof AudioMessage) {
            AudioMessage audioMessage = (AudioMessage)attachment;
            this.setDescription("");
            this.setTimestamp(VKObject.trackTimeToString(audioMessage.duration));
            this.setIcon("new/voicemail.rle");
            this.setCaption("");
        } else if (attachment instanceof Document) {
            Document document = (Document)attachment;
            this.setDescription(document.title);
            this.setTimestamp(Document.getSizeString(document.size));
            this.setIcon("new/file.rle");
            this.setCaption(Localization.get("attachment.document"));
        } else if (attachment instanceof AudioPlaylist) {
            AudioPlaylist audioPlaylist = (AudioPlaylist)attachment;
            this.setAudioPlaylist(audioPlaylist);
        } else if (attachment instanceof Video) {
            Video video = (Video)attachment;
            this.setDescription(VKObject.isEmpty(video.description) ? Localization.get("attachment.video") : video.description);
            this.setTimestamp(VKObject.trackTimeToString(video.duration));
            this.setIcon("new/filmstrip.rle");
            this.setCaption(video.title);
        } else if (attachment instanceof Link) {
            Link link = (Link)attachment;
            this.setDescription(link.url);
            this.setIcon("new/link.rle");
            this.setCaption(Localization.get(link.title));
        } else if (attachment instanceof Post) {
            Post post = (Post)attachment;
            this.setDescription(post.hasText() ? post.text : Localization.get("attachment.wall"));
            this.setTimestamp(VKObject.dateToString(post.date));
            this.setIcon("new/newspaper-variant.rle");
            this.setCaption(PageStorage.get(post.owner_id).getMessageTitle());
        } else if (attachment instanceof Comment) {
            Comment comment = (Comment)attachment;
            this.setDescription(comment.hasText() ? comment.text : Localization.get("attachment.wall_reply"));
            this.setTimestamp(VKObject.dateToString(comment.date));
            this.setIcon("new/message.rle");
            this.setCaption(PageStorage.get(comment.fromId).getMessageTitle());
        } else {
            this.setDescription(attachment.toString());
            this.setIcon("new/paperclip.rle");
            this.setCaption(Localization.get("attachment.general"));
        }
    }

    public void actionPerformed() {
        if (this.linked instanceof Post) {
            ContentController.showComments(this.content, (Post)this.linked, null);
        } else if (this.linked instanceof Comment) {
            Comment comment = (Comment)this.linked;
            WallGetByIdResponse wallGetByIdResponse = (WallGetByIdResponse)new WallGetById(comment.ownerId, comment.postId).execute();
            if (wallGetByIdResponse.post != null) {
                ContentController.showComments(this.content, wallGetByIdResponse.post, null);
            }
        } else if (this.linked instanceof AudioMessage) {
            if (ProgressKernel.hasProvider(this.getName())) {
                return;
            }
            AudioMessage audioMessage = (AudioMessage)this.linked;
            this.downloadAudioMessage(audioMessage);
        } else if (this.linked instanceof Document) {
            if (ProgressKernel.hasProvider(this.getName())) {
                return;
            }
            Document document = (Document)this.linked;
            this.downloadDocument(document);
        } else if (this.linked instanceof PhotoAlbum) {
            ContentController.showPhotos(((PhotoAlbum)this.linked).owner_id, ((PhotoAlbum)this.linked).id, this.content);
        } else if (this.linked instanceof Photo) {
            AppCanvas.instance.goTo(ImageViewer.instance.setPhoto((Photo)this.linked, this, null).parent(this.content));
        } else if (this.linked instanceof ImageAttachment) {
            if (ProgressKernel.hasProvider(this.getName())) {
                return;
            }
            ImageAttachment imageAttachment = (ImageAttachment)((Object)this.linked);
            String string = imageAttachment.getURL(Integer.MAX_VALUE);
            this.downloadImageAttachment(imageAttachment, string);
        } else if (this.linked instanceof AudioPlaylist) {
            AudioPlaylist audioPlaylist = (AudioPlaylist)this.linked;
            Content content = new Content(audioPlaylist.title).parent(this.content);
            ExecuteGetPlaylistResponse executeGetPlaylistResponse = (ExecuteGetPlaylistResponse)new ExecuteGetPlaylist(audioPlaylist.owner_id, audioPlaylist.id, audioPlaylist.access_key).execute();
            if (executeGetPlaylistResponse != null && executeGetPlaylistResponse.hasItems()) {
                for (int i = 0; i < executeGetPlaylistResponse.items.length; ++i) {
                    if (executeGetPlaylistResponse.items[i] == null) continue;
                    content.add(new AttachmentView(executeGetPlaylistResponse.items[i]));
                }
            }
            AppCanvas.instance.goTo(content);
        } else if (this.linked instanceof Audio) {
            if (ProgressKernel.hasProvider(this.getName())) {
                return;
            }
            Audio audio = (Audio)this.linked;
            this.downloadAudio(audio);
        } else if (this.linked instanceof Video) {
            if (ProgressKernel.hasProvider(this.getName())) {
                return;
            }
            PopupMenu popupMenu = new PopupMenu();
            final Video video = (Video)this.linked;
            if (video.isExternal()) {
                if (video.player != null && video.player.indexOf("youtube.com") != -1) {
                    popupMenu.add(new PopupButton(Localization.get("action.openJTube")){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            try {
                                if (MIDletIntegration.startApp(Midlet.instance, "JTube", "nnproject", "0xAFCE0816", 1260, "url=" + Util.encodeURL(video.player))) {
                                    Midlet.instance.exit();
                                }
                            }
                            catch (MIDletNotFoundException mIDletNotFoundException) {
                                AppCanvas.instance.dropError(Localization.get("error.jtubeError"));
                                mIDletNotFoundException.printStackTrace();
                            }
                            catch (ProtocolNotSupportedException protocolNotSupportedException) {
                                AppCanvas.instance.dropError("Launching protocol is not supported!");
                                protocolNotSupportedException.printStackTrace();
                            }
                            catch (Exception exception) {
                                AppCanvas.instance.dropError(exception);
                                exception.printStackTrace();
                            }
                        }
                    });
                    popupMenu.add(new PopupButton(Localization.get("action.webPlayer")){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            Midlet.goLink(video.player);
                        }
                    });
                }
            } else {
                if (video.mp4_144 != null) {
                    popupMenu.add(new PopupButton("144p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_144, "144p");
                        }
                    });
                }
                if (video.mp4_240 != null) {
                    popupMenu.add(new PopupButton("240p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_240, "240p");
                        }
                    });
                }
                if (video.mp4_360 != null) {
                    popupMenu.add(new PopupButton("360p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_360, "360p");
                        }
                    });
                }
                if (video.mp4_480 != null) {
                    popupMenu.add(new PopupButton("480p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_480, "480p");
                        }
                    });
                }
                if (video.mp4_720 != null) {
                    popupMenu.add(new PopupButton("720p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_720, "720p");
                        }
                    });
                }
                if (video.mp4_1080 != null) {
                    popupMenu.add(new PopupButton("1080p"){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.downloadVideo(video, video.mp4_1080, "1080p");
                        }
                    });
                }
                if (video.player != null) {
                    popupMenu.add(new PopupButton(Localization.get("action.webPlayer")){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            Midlet.goLink(video.player);
                        }
                    });
                }
            }
            if (popupMenu.size() == 0) {
                AppCanvas.instance.dropError(Localization.get("error.linksNotFound"));
            } else {
                AppCanvas.instance.showPopup(popupMenu);
            }
        } else if (this.linked instanceof Link) {
            Midlet.goLink(((Link)this.linked).url);
        }
    }

    public void downloadVideo(final Video video, final String string, final String string2) {
        if (video == null || string == null || string2 == null) {
            return;
        }
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadVideo(false, video, string, string2);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadVideo(true, video, string, string2);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadVideo(Midlet.instance.config.downloadMode == 2, video, string, string2);
            }
        }
    }

    public void downloadAudio(final Audio audio) {
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                if (!(this instanceof UserAudioView) && audio.owner_id != VKConstants.account.getId()) {
                    popupMenu.add(new PopupButton(Localization.get("settings.addToLibrary")){

                        public void actionPerformed() {
                            AppCanvas.instance.closePopup();
                            AttachmentView.this.addAudio(audio);
                        }
                    }.setIcon("new/content-copy.rle"));
                }
                final Playlist playlist = !(this instanceof UserAudioView) ? new Playlist((Audio)this.linked) : new Playlist(((UserAudioView)this).ownerid);
                final int n = !(this instanceof UserAudioView) ? 0 : ((UserAudioView)this).index;
                popupMenu.add(new PopupButton(Localization.get("action.playAudio")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        PlayerContent.play(AttachmentView.this.content, playlist, n);
                    }
                }.setIcon("new/play.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadAudio(false, audio);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadAudio(true, audio);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadAudio(Midlet.instance.config.downloadMode == 2, audio);
            }
        }
    }

    public void addAudio(Audio audio) {
        AudioAddResponse audioAddResponse = (AudioAddResponse)new AudioAdd(audio.owner_id, audio.id).execute();
        if (!audioAddResponse.isSuccessful()) {
            AppCanvas.instance.dropError(Localization.get("element.addTrackError"));
        }
    }

    public void downloadImageAttachment(final ImageAttachment imageAttachment, final String string) {
        if (imageAttachment == null || string == null) {
            return;
        }
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadImageAttachment(false, imageAttachment, string);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadImageAttachment(true, imageAttachment, string);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadImageAttachment(Midlet.instance.config.downloadMode == 2, imageAttachment, string);
            }
        }
    }

    public void downloadDocument(final Document document) {
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadDocument(false, document);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadDocument(true, document);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadDocument(Midlet.instance.config.downloadMode == 2, document);
            }
        }
    }

    public void downloadAudioMessage(final AudioMessage audioMessage) {
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadAudioMessage(false, audioMessage);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        AttachmentView.this.downloadAudioMessage(true, audioMessage);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadAudioMessage(Midlet.instance.config.downloadMode == 2, audioMessage);
            }
        }
    }

    public void downloadVideo(boolean bl, final Video video, final String string, final String string2) {
        if (bl) {
            Midlet.goLink(string);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this.content){

            public void filePicked(String string3) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(AttachmentView.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string3 + video.toString() + "_" + string2 + ".mp4"), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string22 = Localization.get("fm.replaceConfirm", video.toString() + ".mp4");
                        popupMenu.add(new Label(string22).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void downloadAudio(boolean bl, final Audio audio) {
        if (bl) {
            Midlet.goLink(audio.url);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this.content){

            public void filePicked(String string) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(AttachmentView.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    String string2 = AudioCache.get(audio);
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string + string2), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string3 = Localization.get("fm.replaceConfirm", string2);
                        popupMenu.add(new Label(string3).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(((this).this).audio.url, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile((this).audio.url, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void downloadImageAttachment(boolean bl, ImageAttachment imageAttachment, final String string) {
        if (bl) {
            Midlet.goLink(string);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this.content){

            public void filePicked(String string4) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(AttachmentView.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    String string2 = AttachmentView.this.linked.toString() + (AttachmentView.this.linked instanceof Photo ? ".jpeg" : ".png");
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string4 + string2), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string3 = Localization.get("fm.replaceConfirm", string2);
                        popupMenu.add(new Label(string3).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void downloadDocument(boolean bl, final Document document) {
        if (bl) {
            Midlet.goLink(document.url);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this.content){

            public void filePicked(String string) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(AttachmentView.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string + document.title), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string2 = Localization.get("fm.replaceConfirm", document.title);
                        popupMenu.add(new Label(string2).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(((this).this).document.url, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile((this).document.url, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void downloadAudioMessage(boolean bl, final AudioMessage audioMessage) {
        if (bl) {
            Midlet.goLink(audioMessage.link_mp3);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this.content){

            public void filePicked(String string) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(AttachmentView.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string + audioMessage.toString() + ".mp3"), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string2 = Localization.get("fm.replaceConfirm", audioMessage.toString() + ".mp3");
                        popupMenu.add(new Label(string2).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(((this).this).audioMessage.link_mp3, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile((this).audioMessage.link_mp3, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        super.paint(graphics, n, n2);
        if (this.bar != null) {
            this.bar.pressed = this.pressed;
            this.bar.width = this.width - 2;
            this.bar.paint(graphics, this.y + n + this.height - this.bar.height, this.x + n2 + 1);
        }
        if (this.linked instanceof AudioMessage && this.width > 0 && this.lW != this.width && this.lH != this.height) {
            int n4;
            this.lW = this.width;
            this.lH = this.height;
            n3 = this.width - this.startX - this.rightCaptionX;
            int[] nArray = ((AudioMessage)this.linked).waveform;
            int n5 = AppCanvas.instance.perLineSpace + AppCanvas.instance.perLineSpace / 2;
            int n6 = Math.max(1, Math.min(nArray.length, n3 / Math.max(1, n5) - 1));
            int n7 = nArray.length / n6;
            this.wfH = new int[n6];
            this.wfY = new int[n6];
            this.wfP = n3 / n6;
            int n8 = 0;
            int n9 = Integer.MAX_VALUE;
            int n10 = Integer.MIN_VALUE;
            for (n4 = 0; n4 < nArray.length; n4 += n7) {
                n9 = Math.min(n9, nArray[n4]);
                n10 = Math.max(n10, nArray[n4]);
            }
            n4 = (this.height - n5) / Math.max(1, n10 - n9);
            for (int i = 0; i < nArray.length; i += n7) {
                this.wfH[n8] = n5 + (nArray[i] - n9) * n4;
                this.wfY[n8] = (this.height - this.wfH[n8]) / 2;
                if (++n8 >= n6) break;
            }
        }
        if (this.wfH != null && this.wfY != null) {
            n2 += AppCanvas.instance.perLineSpace * 3 / 2;
            for (n3 = 0; n3 < this.wfH.length; ++n3) {
                RenderUtil.fillRect(graphics, this.x + n2 + this.startX, this.y + n + this.wfY[n3], AppCanvas.instance.perLineSpace, this.wfH[n3], this.focusable && this.pressed ? Theming.now.focusedIconColor : Theming.now.iconColor, this.focusable && this.pressed ? Theming.now.focusedIconColor_ : Theming.now.iconColor_);
                n2 += this.wfP;
            }
        }
    }

    public void setProgress(long l) {
        if (this.bar == null) {
            this.bar = (ProgressBar)new ProgressBar().setFocusable(true);
        }
        if (this.bar != null) {
            this.bar.setProgress(l);
        }
        if (this.content != null) {
            this.content.renderIfNeeded();
        }
    }

    public void failed(String string) {
        this.bar = null;
        if (this.content != null) {
            this.content.renderIfNeeded();
        }
        this.setDescription(Localization.get("general.error") + ": Attachment view: " + string);
        AppCanvas.instance.dropError(string);
    }

    public void successful() {
        this.bar = null;
        if (this.content != null) {
            this.content.renderIfNeeded();
        }
        this.setDescription(Localization.get("general.downloadFinished"));
    }

    public String getName() {
        return this.linked == null ? null : this.linked.toString();
    }

    public Attachment getAttachment() {
        return this.linked;
    }
}

