/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Field;
import ru.curoviyxru.phoenix.ui.ImageProvider;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PopupMenu;
import ru.curoviyxru.phoenix.ui.Slider;
import ru.curoviyxru.phoenix.ui.SoftButton;
import ru.curoviyxru.phoenix.ui.SuperString;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.ScrollContent;
import ru.curoviyxru.phoenix.ui.contents.TwoScrollContent;

public class Content {
    public Content parent;
    private SoftButton parentBack;
    public Hashtable screenCache = new Hashtable();
    private Vector container = new Vector(10, 20);
    public int totalHeight;
    public int scrollY;
    public int toScrollY;
    public int selectedY;
    private float kineticScroll;
    private float kineticStore;
    public int perOneY;
    private boolean needUpdate;
    public SuperString title;
    public SuperString renderTitle;
    public int lW;
    public int lastWidth;
    public int lastHeight;
    public int contentHeight;
    public PopupMenu rightSoft;
    public String cornerIcon;

    public Content setCornerIcon(String string) {
        if (this.cornerIcon == null && string != null || this.cornerIcon != null && string == null) {
            this.renderTitle = null;
        }
        this.cornerIcon = string;
        return this;
    }

    public Content parent(final Content content) {
        this.parent = content;
        this.parentBack = content == null && (!Midlet.instance.config.gui_useDrawer || !Midlet.instance.config.gui_touchHud || ContentController.menu == null) ? null : new SoftButton(Localization.get("action.back"), true){

            public void trigger() {
                if (Midlet.instance.config.gui_useDrawer && Midlet.instance.config.gui_touchHud && ContentController.menu != null) {
                    if (AppCanvas.instance.drawerBack == null) {
                        if (ContentController.menu != null) {
                            AppCanvas.instance.backTo(ContentController.menu.parent(Content.this));
                        }
                        AppCanvas.instance.drawerBack = Content.this;
                    } else {
                        AppCanvas.instance.goTo(AppCanvas.instance.drawerBack);
                        if (ContentController.menu != null) {
                            ContentController.menu.parent(null);
                        }
                        AppCanvas.instance.drawerBack = null;
                    }
                } else {
                    if (ContentController.menu != null) {
                        ContentController.menu.parent(null);
                    }
                    AppCanvas.instance.backTo(content);
                }
            }
        };
        if (AppCanvas.instance.content != null && AppCanvas.instance.content.equals(this)) {
            AppCanvas.instance.setLeftSoft(this.parentBack);
        }
        return this;
    }

    public void goBack() {
        AppCanvas.instance.backTo(this.parent);
    }

    public void opened() {
        AppCanvas.instance.setLeftSoft(this.parentBack);
    }

    public void renderIfNeeded() {
        if (AppCanvas.instance.content == this) {
            AppCanvas.instance.render();
        }
    }

    public void itemRendered(PaneItem paneItem, Graphics graphics, int n, int n2) {
    }

    public Content(String string) {
        this.setTitle(string);
    }

    public Content imOut() {
        this.removeAll();
        AppCanvas.instance.dropError(Localization.get("general.outOfMemory"));
        AppCanvas.instance.setProgress(false);
        return this;
    }

    public int getWidth() {
        return AppCanvas.instance.lW;
    }

    public void updateHeightsFromEnd(int n, int n2) {
        this.updateHeights(n, -1, n2, false);
    }

    public void updateHeights(int n, int n2) {
        this.updateHeights(n, n2, -1, false);
    }

    public void updateHeightsAdd(int n, int n2) {
        this.updateHeights(n, n2, -1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHeights(int n, int n2, int n3, boolean bl) {
        Content content = this;
        synchronized (content) {
            int n4 = AppCanvas.instance.perLineSpace + AppCanvas.instance.perLineSpace;
            int n5 = 0;
            int n6 = n - AppCanvas.instance.perLineSpace * 4;
            for (int i = 0; i < this.container.size(); ++i) {
                PaneItem paneItem = (PaneItem)this.container.elementAt(i);
                if (paneItem == null) continue;
                paneItem.content = this;
                if (paneItem instanceof PaneItem.ItemThatUsesFullWidth) {
                    paneItem.width = n;
                    paneItem.x = 0;
                } else {
                    paneItem.width = n6;
                    paneItem.x = n4;
                }
                if (paneItem.separatorBefore) {
                    // empty if block
                }
                paneItem.y = ++n5;
                if (i > this.container.size() - n3 - 1 || i < n2) {
                    paneItem.updateHeight();
                }
                n5 += paneItem.height + (paneItem.separatorAfter ? 1 : 0);
            }
            if (n2 != -1 && this.selectedY >= n2) {
                this.scrollY += n5 - this.totalHeight;
                this.toScrollY += n5 - this.totalHeight;
            }
            this.totalHeight = n5;
        }
    }

    public void paint(Graphics graphics, int n) {
        this.paint(graphics, n, AppCanvas.instance.contentY, AppCanvas.instance.getWidth(), AppCanvas.instance.contentOriginalHeight, AppCanvas.instance.getHeight(), true);
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.paint(graphics, n2, AppCanvas.instance.contentY, AppCanvas.instance.getWidth(), n, AppCanvas.instance.getHeight(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Content content = this;
        synchronized (content) {
            int n6;
            AppCanvas.instance.contentHeight = this.contentHeight = n4;
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipY();
            int n9 = graphics.getClipWidth();
            int n10 = graphics.getClipHeight();
            graphics.setClip(n, n2, n3, n4);
            if (bl) {
                graphics.setColor(Theming.now.backgroundColor);
                graphics.fillRect(n, n2, n3, n4);
            }
            boolean bl2 = false;
            if (this.kineticScroll != 0.0f) {
                this.kineticScroll *= AppCanvas.instance.pressed ? 0.5f : 0.96f;
                if (this.kineticScroll > 1.0f || this.kineticScroll < -1.0f) {
                    this.toScrollY += (int)this.kineticScroll;
                    this.checkY();
                    this.scrollY = this.toScrollY;
                } else {
                    this.kineticScroll = 0.0f;
                }
                bl2 = true;
            }
            this.checkY();
            if (this.toScrollY != this.scrollY) {
                this.scrollY = !Midlet.instance.config.gui_smoothScroll ? this.toScrollY : (Math.abs(this.toScrollY - this.scrollY) < 4 ? (this.scrollY += this.toScrollY > this.scrollY ? 1 : -1) : (this.scrollY += (this.toScrollY - this.scrollY) / 4));
                if (this.toScrollY != this.scrollY) {
                    bl2 = true;
                }
            }
            int n11 = AppCanvas.instance.perLineSpace + AppCanvas.instance.perLineSpace;
            int n12 = 0;
            int n13 = n2 - this.scrollY;
            int n14 = n3 - AppCanvas.instance.perLineSpace * 4;
            for (n6 = 0; n6 < this.container.size(); ++n6) {
                PaneItem paneItem = (PaneItem)this.container.elementAt(n6);
                if (paneItem == null) continue;
                paneItem.content = this;
                if (AppCanvas.instance.showSelection) {
                    boolean bl3 = paneItem.pressed = n6 == this.selectedY;
                }
                if (paneItem instanceof PaneItem.ItemThatUsesFullWidth) {
                    paneItem.width = n3;
                    paneItem.x = 0;
                } else {
                    paneItem.width = n14;
                    paneItem.x = n11;
                }
                if (paneItem.separatorBefore) {
                    graphics.setColor(Theming.now.itemSeparatorColor);
                    graphics.drawLine(n, n12 + n13, n3 + n, n12 + n13);
                }
                paneItem.y = ++n12;
                if (paneItem.y + paneItem.height - this.scrollY >= 0) {
                    if (paneItem.y - this.scrollY < n4) {
                        this.itemRendered(paneItem, graphics, n13, n);
                        paneItem.paint(graphics, n13, n);
                        if (paneItem.separatorAfter) {
                            graphics.setColor(Theming.now.itemSeparatorColor);
                            graphics.drawLine(n, n12 + n13 + paneItem.height, n3 + n, n12 + n13 + paneItem.height);
                        }
                    } else if (paneItem.y - this.scrollY <= n5) {
                        paneItem.updateHeight();
                    }
                }
                n12 += paneItem.height + (paneItem.separatorAfter ? 1 : 0);
            }
            this.needUpdate = this.lastHeight != n4 && this.lastWidth != n3 || this.totalHeight < n12 && this.totalHeight <= this.contentHeight || this.totalHeight > n12 && n12 <= this.contentHeight;
            this.lastWidth = n3;
            this.lastHeight = n4;
            this.totalHeight = n12;
            if (this.totalHeight > this.contentHeight && this.toScrollY + this.contentHeight > this.totalHeight) {
                this.toScrollY = this.totalHeight - this.contentHeight;
            } else if (this.toScrollY < 0) {
                this.toScrollY = 0;
            }
            if (this.toScrollY != this.scrollY) {
                bl2 = true;
            }
            graphics.setClip(n7, n8, n9, n10);
            if (this.needUpdate) {
                for (n6 = 0; n6 < this.container.size(); ++n6) {
                    ((PaneItem)this.container.elementAt(n6)).resetCache();
                }
                AppCanvas.instance.render();
                return;
            }
            if (!this.needUpdate && bl2) {
                AppCanvas.instance.render();
            }
        }
    }

    public void onScrollUpdate() {
    }

    public void pointerPressed(int n, int n2) {
        for (int i = 0; i < this.container.size(); ++i) {
            PaneItem paneItem = (PaneItem)this.container.elementAt(i);
            if (paneItem == null) continue;
            boolean bl = paneItem.pressed;
            paneItem.pointerPressed(n, n2, this.toScrollY);
            if (bl || !paneItem.pressed) continue;
            this.selectedY = i;
        }
    }

    public void pointerReleased(int n, int n2) {
        for (int i = 0; i < this.container.size(); ++i) {
            PaneItem paneItem = (PaneItem)this.container.elementAt(i);
            if (paneItem == null) continue;
            paneItem.pointerReleased(n, n2, this.toScrollY);
        }
        this.kineticScroll += this.kineticStore;
        this.kineticStore = 0.0f;
    }

    public void pointerDragged(int n, int n2) {
        int n3;
        boolean bl = false;
        for (n3 = 0; n3 < this.container.size(); ++n3) {
            PaneItem paneItem = (PaneItem)this.container.elementAt(n3);
            if (paneItem == null) continue;
            paneItem.pointerDragged(n, n2, this.toScrollY);
            if (!(paneItem instanceof Slider)) continue;
            Slider slider = (Slider)paneItem;
            if (!slider.pressed) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        n3 = AppCanvas.instance.lY - AppCanvas.instance.pY;
        this.toScrollY += n3;
        this.kineticStore = n3;
        this.checkY();
        this.scrollY = this.toScrollY;
        this.onScrollUpdate();
    }

    public boolean parseKeyRepeated(int n) {
        switch (n) {
            case 1: {
                if (this.container.size() <= 1) break;
                this.up();
                return true;
            }
            case 6: {
                if (this.container.size() <= 1) break;
                this.down();
                return true;
            }
            case 50: {
                if (this.container.size() <= 1) break;
                this.pageScroll(true);
                return true;
            }
            case 56: {
                if (this.container.size() <= 1) break;
                this.pageScroll(false);
                return true;
            }
        }
        return false;
    }

    public boolean parseKeyPressed(int n) {
        switch (n) {
            case 1: 
            case 6: 
            case 50: 
            case 56: {
                return this.parseKeyRepeated(n);
            }
        }
        return false;
    }

    public void keyPressed(int n) {
        if (this.parseKeyPressed(n)) {
            return;
        }
        PaneItem paneItem = this.getSelected();
        if (paneItem != null) {
            paneItem.keyPressed(n, this.toScrollY);
        }
    }

    public void keyReleased(int n) {
        PaneItem paneItem = this.getSelected();
        if (paneItem != null) {
            paneItem.keyReleased(n, this.toScrollY);
        }
    }

    public void keyRepeated(int n) {
        if (this.parseKeyRepeated(n)) {
            return;
        }
        PaneItem paneItem = this.getSelected();
        if (paneItem != null) {
            paneItem.keyRepeated(n, this.toScrollY);
        }
    }

    public void down() {
        AppCanvas.instance.showScroll();
        PaneItem paneItem = this.getSelected();
        if (paneItem != null && paneItem.height + AppCanvas.instance.perLineSpace * 2 > this.contentHeight && this.perOneY != paneItem.height) {
            int n = paneItem.y + paneItem.height - this.contentHeight + AppCanvas.instance.perLineSpace;
            this.toScrollY += this.contentHeight / 5;
            if (this.toScrollY >= n) {
                this.perOneY = paneItem.height;
                this.toScrollY = n;
            } else {
                this.perOneY += this.contentHeight / 5;
            }
            return;
        }
        ++this.selectedY;
        this.checkYValidity();
        this.scrollToItemDown();
        this.checkSkippableDown();
        this.checkYValidity();
        this.scrollToItemUp();
        this.scrollToItemDown();
        this.onScrollUpdate();
    }

    private void up() {
        AppCanvas.instance.showScroll();
        PaneItem paneItem = this.getSelected();
        if (paneItem != null && paneItem.height + AppCanvas.instance.perLineSpace * 2 > this.contentHeight && this.perOneY != 0) {
            int n = paneItem.y - AppCanvas.instance.perLineSpace;
            this.toScrollY -= this.contentHeight / 5;
            if (this.toScrollY <= n) {
                this.perOneY = 0;
                this.toScrollY = n;
            } else {
                this.perOneY -= this.contentHeight / 5;
            }
            return;
        }
        --this.selectedY;
        this.checkYValidity();
        this.scrollToItemUp();
        this.checkSkippableUp();
        this.checkYValidity();
        this.scrollToItemDown();
        this.scrollToItemUp();
        this.onScrollUpdate();
    }

    private void pageScroll(boolean bl) {
        AppCanvas.instance.showScroll();
        this.toScrollY += (this.contentHeight - AppCanvas.instance.normalFont.getHeight()) * (bl ? -1 : 1);
        this.checkY();
        this.selectElementInCenter();
        this.onScrollUpdate();
    }

    public void selectElementInCenter() {
        PaneItem paneItem = this.getSelected();
        if (paneItem == null) {
            return;
        }
        int n = paneItem.y + paneItem.height / 2;
        int n2 = 1;
        if (this.toScrollY < n) {
            n2 = -1;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i = this.selectedY; i >= 0 && i < this.container.size(); i += n2) {
            PaneItem paneItem2 = (PaneItem)this.container.elementAt(i);
            if (paneItem2.skipSelection) continue;
            if (paneItem2.y < this.toScrollY + this.contentHeight / 2 && paneItem2.y + paneItem2.height - this.toScrollY > this.toScrollY + this.contentHeight / 2) {
                this.selectedY = i;
                break;
            }
            int n5 = Math.abs(this.toScrollY + this.contentHeight / 2 - (paneItem2.y + paneItem2.height / 2)) - paneItem2.height / 2;
            if (n5 < n3) {
                n3 = n5;
                n4 = i;
                continue;
            }
            this.selectedY = i - n2;
            break;
        }
        if (n4 != -1) {
            this.selectedY = n4;
        }
    }

    public PaneItem getSelected() {
        if (this.selectedY >= 0 && this.selectedY < this.container.size()) {
            return (PaneItem)this.container.elementAt(this.selectedY);
        }
        return null;
    }

    public Field getSelectedField() {
        PaneItem paneItem = this.getSelected();
        return paneItem != null && paneItem instanceof Field ? (Field)paneItem : null;
    }

    boolean isFieldSelected() {
        Field field = this.getSelectedField();
        return field != null;
    }

    public void setTitle(String string) {
        this.title = string == null ? null : new SuperString(string);
        this.renderTitle = null;
        if (AppCanvas.instance.content != null && AppCanvas.instance.content.equals(this)) {
            AppCanvas.instance.setTitle(string == null ? "VK4ME" : string);
        }
    }

    public String getRightSoft() {
        if (this.rightSoft == null) {
            return null;
        }
        return this.rightSoft.title.toString();
    }

    public void rightSoft() {
        if (AppCanvas.instance.popupOpened()) {
            AppCanvas.instance.closePopup();
            return;
        }
        if (this.rightSoft != null) {
            AppCanvas.instance.showRightsoftPopup(this.rightSoft);
        }
    }

    public void scrollTo(int n) {
        this.selectedY = n;
        this.checkYValidity();
        PaneItem paneItem = this.getSelected();
        if (paneItem == null) {
            return;
        }
        this.scrollToItemUp();
        this.scrollToItemDown();
        this.checkSkippableUp();
        this.checkYValidity();
        AppCanvas.instance.render();
    }

    private void checkY() {
        if (this.contentHeight < this.totalHeight) {
            int n;
            if (this.toScrollY < 0) {
                this.toScrollY = 0;
            }
            if (this.toScrollY > (n = this.totalHeight - this.contentHeight)) {
                this.toScrollY = n;
            }
        } else {
            this.toScrollY = 0;
        }
    }

    private void checkSkippableDown() {
        int n = this.selectedY - 1;
        boolean bl = false;
        while (this.selectedY != n) {
            PaneItem paneItem = this.getSelected();
            if (paneItem != null && !paneItem.skipSelection) {
                return;
            }
            ++this.selectedY;
            if (this.selectedY < this.container.size()) continue;
            this.selectedY = 0;
            if (bl) break;
            bl = true;
        }
    }

    private void checkSkippableUp() {
        int n = this.selectedY + 1;
        boolean bl = false;
        while (this.selectedY != n) {
            PaneItem paneItem = this.getSelected();
            if (paneItem != null && !paneItem.skipSelection) {
                return;
            }
            --this.selectedY;
            if (this.selectedY >= 0) continue;
            int n2 = this.selectedY = this.container.isEmpty() ? 0 : this.size() - 1;
            if (bl) break;
            bl = true;
        }
    }

    private void checkYValidity() {
        if (this.selectedY > this.container.size() - 1) {
            this.selectedY = this instanceof ScrollContent || this instanceof TwoScrollContent ? this.container.size() - 1 : 0;
            this.checkSkippableDown();
        }
        if (this.selectedY < 0) {
            this.selectedY = this instanceof ScrollContent || this instanceof TwoScrollContent || this.container.isEmpty() ? 0 : this.container.size() - 1;
            this.checkSkippableUp();
        }
    }

    private void scrollToItemDown() {
        boolean bl;
        PaneItem paneItem = this.getSelected();
        if (paneItem == null) {
            return;
        }
        boolean bl2 = bl = paneItem.height + AppCanvas.instance.perLineSpace * 2 > this.contentHeight;
        if (!bl) {
            if (paneItem.y - this.toScrollY + paneItem.height + AppCanvas.instance.perLineSpace >= this.contentHeight) {
                this.toScrollY = paneItem.y + paneItem.height - this.contentHeight + AppCanvas.instance.perLineSpace;
                this.perOneY = paneItem.height;
            }
        } else if (paneItem.y + paneItem.height - this.toScrollY >= this.contentHeight) {
            this.toScrollY = paneItem.y - AppCanvas.instance.perLineSpace;
            this.perOneY = this.contentHeight - AppCanvas.instance.perLineSpace;
        }
        AppCanvas.instance.render();
    }

    private void scrollToItemUp() {
        boolean bl;
        PaneItem paneItem = this.getSelected();
        if (paneItem == null) {
            return;
        }
        boolean bl2 = bl = paneItem.height + AppCanvas.instance.perLineSpace * 2 > this.contentHeight;
        if (!bl) {
            if (paneItem.y - this.toScrollY - AppCanvas.instance.perLineSpace <= 0) {
                this.toScrollY = paneItem.y - AppCanvas.instance.perLineSpace;
                this.perOneY = 0;
            }
        } else if (paneItem.y + paneItem.height - this.contentHeight - this.toScrollY <= 0) {
            this.toScrollY = paneItem.y + paneItem.height - this.contentHeight + AppCanvas.instance.perLineSpace;
            this.perOneY = paneItem.height - this.contentHeight + AppCanvas.instance.perLineSpace;
        }
        AppCanvas.instance.render();
    }

    public Content removeAt(int n) {
        if (n < 0 || n >= this.size()) {
            return this;
        }
        this.container.removeElementAt(n);
        return this;
    }

    public Content insert(PaneItem paneItem, int n) {
        if (paneItem == null) {
            return this;
        }
        paneItem.content = this;
        if (paneItem instanceof ImageProvider) {
            AppCanvas.instance.queue((ImageProvider)((Object)paneItem));
        }
        this.container.insertElementAt(paneItem, n);
        return this;
    }

    public Content remove(PaneItem paneItem) {
        return this.removeAt(this.indexOf(paneItem));
    }

    public int indexOf(PaneItem paneItem) {
        return this.container.indexOf(paneItem);
    }

    public boolean contains(PaneItem paneItem) {
        return this.indexOf(paneItem) != -1;
    }

    public Content add(PaneItem paneItem) {
        if (paneItem == null) {
            return this;
        }
        paneItem.content = this;
        if (paneItem instanceof ImageProvider) {
            AppCanvas.instance.queue((ImageProvider)((Object)paneItem));
        }
        this.container.addElement(paneItem);
        return this;
    }

    public PaneItem at(int n) {
        return (PaneItem)this.container.elementAt(n);
    }

    public int size() {
        return this.container.size();
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public PaneItem last() {
        return (PaneItem)this.container.lastElement();
    }

    public Content removeAll() {
        this.container.removeAllElements();
        System.gc();
        return this;
    }
}

