/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.Conversation;
import ru.curoviyxru.j2vk.api.objects.Message;
import ru.curoviyxru.j2vk.api.objects.user.Page;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetConversationsById;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetConversationsByIdResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.SuperString;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.ConversationList;
import ru.curoviyxru.phoenix.ui.contents.MessageContent;

public class ConversationItem
extends ListItem {
    public Message msg;
    public Conversation conv;
    public int typing;
    public String oldCornerIcon;
    public SuperString oldDescription;
    final Object sync = new Object();

    public ConversationItem setConversation(Conversation conversation) {
        if (conversation == null) {
            return this;
        }
        this.conv = conversation;
        if (conversation.unreadCount == 0 && ConversationList.instance != null) {
            ConversationList.instance.unread.removeElement(new Long(conversation.getId()));
            ContentController.updateMessagesItem();
        }
        if (conversation.isPage()) {
            PageStorage.load(conversation.getId());
        }
        Page page = conversation.isPage() ? PageStorage.get(conversation.getId()) : null;
        this.setConver(conversation);
        if (conversation.getId() != VKConstants.account.getId()) {
            this.setCornerIcon(ContentController.getStatusIcon(page));
            this.setCaption(conversation.getTitle());
        } else {
            this.setCornerIcon(0);
            this.setCaption(Localization.get("element.favorites"));
        }
        this.setTimestamp(this.msg != null ? this.msg.getLastTime() : 0);
        this.setState((short)Math.min(9999, this.conv.unreadCount));
        if (conversation.hasPushSettings() && this.conv.unreadCount > 0) {
            this.setMode(conversation.pushSettings.no_sound ? (byte)4 : 3);
        }
        return this;
    }

    public ConversationItem setMessage(Conversation conversation, Message message) {
        if (conversation == null || message == null) {
            return this;
        }
        this.msg = message;
        this.setTyping(0);
        this.setTimestamp(this.msg != null ? this.msg.getLastTime() : 0);
        this.setDescription(message.toString(true, conversation.isPage(), true, true, true));
        boolean bl = message.out && message.id > conversation.outRead;
        this.setMode(bl ? (byte)5 : 3);
        return this;
    }

    public ConversationItem(Content content, Conversation conversation, Message message) {
        super(null, (byte)3);
        this.setFont(true);
        this.content = content;
        this.setMessage(conversation, message);
        this.setConversation(conversation);
    }

    public void actionPerformed() {
        ConversationList conversationList = (ConversationList)this.content;
        MessageContent messageContent = ConversationItem.getConversationContent(conversationList.forward != null && conversationList.forwardType != 0 && this.content.parent != null ? this.content.parent : this.content, this.conv.getId());
        if (conversationList.forward != null && conversationList.forwardType != 0) {
            switch (conversationList.forwardType) {
                case 1: {
                    messageContent.msgField.addForward(conversationList.forward);
                    break;
                }
                case 2: 
                case 3: {
                    messageContent.msgField.attachment = conversationList.forward.firstElement();
                    messageContent.msgField.attachmentType = 4;
                }
            }
            conversationList.forward(null, 0);
        }
        AppCanvas.instance.goTo(messageContent);
    }

    public static MessageContent getConversationContent(Content content, long l) {
        MessagesGetConversationsByIdResponse messagesGetConversationsByIdResponse = (MessagesGetConversationsByIdResponse)new MessagesGetConversationsById().addPeerId(l).execute();
        if (messagesGetConversationsByIdResponse == null || !messagesGetConversationsByIdResponse.hasConversation()) {
            return null;
        }
        return (MessageContent)new MessageContent(messagesGetConversationsByIdResponse.getConversation()).parent(content);
    }

    public static MessageContent showConversation(Content content, long l) {
        MessageContent messageContent = ConversationItem.getConversationContent(content, l);
        AppCanvas.instance.goTo(messageContent);
        return messageContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTyping(int n) {
        Object object = this.sync;
        synchronized (object) {
            this.typing = Math.max(n, 0);
            if (this.oldCornerIcon == null) {
                this.oldCornerIcon = this.cornerIcon;
                this.oldDescription = this.desc;
            }
            if (this.typing == 0) {
                if (this.cornerIcon != null && this.cornerIcon.equals(ConversationItem.getCornerPath(7))) {
                    this.cornerIcon = this.oldCornerIcon;
                }
                this.oldCornerIcon = null;
                this.setDescription(this.oldDescription);
                this.oldDescription = null;
            } else {
                this.cornerIcon = ConversationItem.getCornerPath(7);
                if (this.typing == 5) {
                    this.setDescription(Localization.get(!this.conv.isPage() ? "title.manyUsersTyping" : "title.userTyping", "").trim());
                }
            }
        }
    }

    public void updateTyping() {
        if (this.typing > 0) {
            this.setTyping(this.typing - 1);
        }
    }
}

