/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.Field;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.PopupMenu;

public class FilePicker
extends Content {
    boolean chooseFolder;
    Vector selected;
    public static String SEPARATOR = null;
    ListItem upItem;
    ListItem thisItem;
    PopupMenu popup;
    static String currentPath;

    public FilePicker(boolean bl, Content content) {
        super(Localization.get("title.filePicker"));
        this.parent(content);
        this.chooseFolder = bl;
        this.init();
    }

    public String getRightSoft() {
        if (AppCanvas.instance.touchHud) {
            return null;
        }
        return super.getRightSoft();
    }

    public void reloadContent() {
        if (currentPath == null || currentPath.equals("file://")) {
            this.loadRoots();
        } else {
            this.loadFiles(currentPath);
        }
    }

    private void init() {
        this.setTitle(Localization.get(this.chooseFolder ? "title.chooseFolder" : "title.chooseFile"));
        this.popup = new PopupMenu(Localization.get("general.actions"));
        this.popup.add(new PopupButton(Localization.get(this.chooseFolder ? "fm.chooseThisFolder" : "fm.chooseThisFile")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                if (FilePicker.this.selectedY == 0) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                if (FilePicker.this.selectedY == 1 && FilePicker.this.chooseFolder) {
                    FilePicker.this.selectFile(currentPath);
                    return;
                }
                ListItem listItem = (ListItem)FilePicker.this.getSelected();
                if (FilePicker.isFolder(listItem) && !FilePicker.this.chooseFolder) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                if (!FilePicker.isFolder(listItem) && FilePicker.this.chooseFolder) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                FilePicker.this.selectFile(currentPath + listItem.caption + (FilePicker.isFolder(listItem) ? SEPARATOR : ""));
            }
        }.setIcon("new/paperclip.rle"));
        this.popup.add(new PopupButton(Localization.get("fm.createFolder")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                FilePicker.this.makeFolderPopup();
            }
        }.setIcon("new/folder.rle"));
        this.popup.add(new PopupButton(Localization.get("fm.rename")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                if (FilePicker.this.selectedY == 0) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                if (FilePicker.this.selectedY == 1 && FilePicker.this.chooseFolder) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                FilePicker.this.renamePopup();
            }
        }.setIcon("new/pencil.rle"));
        this.popup.add(new PopupButton(Localization.get("fm.delete")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                if (FilePicker.this.selectedY == 0) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                if (FilePicker.this.selectedY == 1 && FilePicker.this.chooseFolder) {
                    AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
                    return;
                }
                FilePicker.this.removeFilePopup();
            }
        }.setIcon("new/delete.rle"));
        this.popup.add(new PopupButton(Localization.get("action.cancelChoosing")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                FilePicker.this.goBack();
            }
        }.setIcon("new/close.rle"));
        this.reloadContent();
    }

    private void makeFolderPopup() {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(new Label(Localization.get("fm.enterFolderName")).setFont(true).skipSelection(true));
        final Field field = new Field(this.title != null ? this.title.toString() : null, Localization.get("fm.newFolder"));
        popupMenu.add(field);
        popupMenu.add(new PopupButton(Localization.get("action.ok")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                FilePicker.this.makeFolder(currentPath + field.getText() + SEPARATOR);
            }
        });
        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
            }
        });
        AppCanvas.instance.showPopup(popupMenu);
        popupMenu.selectedY = 1;
    }

    private void makeFolder(String string) {
        try {
            FileConnection fileConnection = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)string);
                if (fileConnection.exists()) {
                    throw new Exception(Localization.get("fm.folderExists"));
                }
                fileConnection.mkdir();
                fileConnection.close();
                AppCanvas.instance.closePopup();
                this.loadFiles(currentPath);
                this.selectFileInList(string.substring(currentPath.length(), string.length() - SEPARATOR.length()));
            }
            catch (Exception exception) {
                try {
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                AppCanvas.instance.dropError(exception);
            }
        }
        catch (Throwable throwable) {
            AppCanvas.instance.dropError(throwable);
        }
    }

    private void renamePopup() {
        PopupMenu popupMenu = new PopupMenu();
        final ListItem listItem = (ListItem)this.getSelected();
        String string = Localization.get("fm.enterNewName", listItem.caption != null ? listItem.caption.toString() : null);
        popupMenu.add(new Label(string).setFont(true).skipSelection(true));
        final Field field = new Field(string, listItem.caption != null ? listItem.caption.toString() : null);
        popupMenu.add(field);
        popupMenu.add(new PopupButton(Localization.get("action.ok")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                FilePicker.this.renameFile(field.getText(), currentPath + listItem.caption + (FilePicker.isFolder(listItem) ? SEPARATOR : ""));
            }
        });
        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
            }
        });
        AppCanvas.instance.showPopup(popupMenu);
        popupMenu.selectedY = 1;
    }

    private void renameFile(String string, String string2) {
        try {
            FileConnection fileConnection = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)string2);
                fileConnection.rename(string);
                fileConnection.close();
                AppCanvas.instance.closePopup();
                this.loadFiles(currentPath);
                this.selectFileInList(string);
            }
            catch (Exception exception) {
                try {
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                AppCanvas.instance.dropError(exception);
            }
        }
        catch (Throwable throwable) {
            AppCanvas.instance.dropError(throwable);
        }
    }

    private void removeFilePopup() {
        PopupMenu popupMenu = new PopupMenu();
        final ListItem listItem = (ListItem)this.getSelected();
        String string = Localization.get("fm.deleteConfirm", listItem.caption != null ? listItem.caption.toString() : null);
        popupMenu.add(new Label(string).setFont(true).skipSelection(true));
        popupMenu.add(new PopupButton(Localization.get("action.ok")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                FilePicker.this.deleteFile(currentPath + listItem.caption + (FilePicker.isFolder(listItem) ? SEPARATOR : ""));
            }
        });
        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
            }
        });
        AppCanvas.instance.showPopup(popupMenu);
        popupMenu.selectedY = 2;
    }

    private void deleteFile(String string) {
        try {
            FileConnection fileConnection = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)string);
                fileConnection.delete();
                fileConnection.close();
                AppCanvas.instance.closePopup();
                int n = this.selectedY;
                this.loadFiles(currentPath);
                this.selectedY = n;
                if (this.selectedY >= this.size()) {
                    this.selectedY = this.size() - 1;
                }
                this.updateHeights(this.getWidth(), this.selectedY + 1);
                this.scrollTo(this.selectedY);
                this.scrollY = this.toScrollY;
            }
            catch (Exception exception) {
                try {
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                AppCanvas.instance.dropError(exception);
            }
        }
        catch (Throwable throwable) {
            AppCanvas.instance.dropError(throwable);
        }
    }

    public void showPopup() {
        this.popup.selectedY = 0;
        this.popup.toScrollY = 0;
        this.popup.scrollY = 0;
        AppCanvas.instance.showPopup(this.popup);
    }

    public void keyPressed(int n) {
        if (n == 2) {
            if (this.upItem != null) {
                this.upItem.actionPerformed();
            } else {
                this.goBack();
            }
        } else if (n == 1000010) {
            if (this.selectedY == 0) {
                AppCanvas.instance.dropError(Localization.get("fm.pleaseSelectFile"));
            } else {
                this.removeFilePopup();
            }
        } else {
            super.keyPressed(n == 5 ? 8 : n);
        }
    }

    public void filePicked(String string) {
        this.goBack();
    }

    public static boolean checkAPIAvailiability() {
        return System.getProperty("microedition.io.file.FileConnection.version") != null;
    }

    public static boolean checkPermission() {
        return Midlet.instance.checkPermission("javax.microedition.io.Connector.file.read") != 0;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(SEPARATOR.charAt(0));
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void loadRoots() {
        this.setTitle(Localization.get(this.chooseFolder ? "title.chooseFolder" : "title.chooseFile"));
        this.rightSoft = null;
        currentPath = "file://";
        this.removeAll();
        this.upItem = null;
        this.thisItem = null;
        this.selectedY = 0;
        this.scrollY = 0;
        this.toScrollY = 0;
        Enumeration enumeration = null;
        try {
            enumeration = FileSystemRegistry.listRoots();
        }
        catch (Throwable throwable) {
            AppCanvas.instance.dropError(throwable);
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null) continue;
            if (string.endsWith("/") && !SEPARATOR.equals("/")) {
                SEPARATOR = "/";
            }
            if (string.endsWith("/") || string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
            }
            final String string2 = string;
            ListItem listItem = new ListItem(string2, 2){

                public void actionPerformed() {
                    FilePicker.this.loadFiles(string2);
                }
            }.setDescription(AppCanvas.instance.touchHud ? Localization.get("general.root") : null).setIcon("new/sd.rle");
            this.add(listItem);
        }
    }

    private void loadFiles(String string) {
        final String string2 = (string.startsWith("file://") ? "" : (string.startsWith(SEPARATOR) ? "file://" : "file://" + SEPARATOR)) + string + (!string.endsWith(SEPARATOR) ? SEPARATOR : "");
        final String string3 = string2.substring(0, string2.length() - 1).substring(0, string2.substring(0, string2.length() - 1).lastIndexOf(SEPARATOR.charAt(0)));
        final boolean bl = string3.equals("file://");
        this.setTitle(string2.substring(7));
        this.rightSoft = this.popup;
        currentPath = string2;
        this.removeAll();
        this.selectedY = 0;
        this.scrollY = 0;
        this.toScrollY = 0;
        this.upItem = new ListItem(".." + SEPARATOR, 2){

            public void actionPerformed() {
                if (bl) {
                    FilePicker.this.loadRoots();
                } else {
                    FilePicker.this.loadFiles(string3);
                }
                FilePicker.this.selectFileInList(string2.substring(string3.length() + SEPARATOR.length(), string2.length() - SEPARATOR.length()));
            }
        }.setDescription(AppCanvas.instance.touchHud ? Localization.get("action.goUpwards") : null).setIcon("new/chevron-up.rle");
        this.add(this.upItem);
        try {
            int n = 1;
            FileConnection fileConnection = (FileConnection)Connector.open((String)string2, (int)1);
            if (fileConnection.isDirectory()) {
                Enumeration enumeration = fileConnection.list();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    if (string4 == null) continue;
                    final String string5 = string4;
                    final boolean bl2 = string5.endsWith(SEPARATOR);
                    String string6 = string5;
                    if (bl2) {
                        string6 = string5.substring(0, string5.length() - SEPARATOR.length());
                    }
                    ListItem listItem = new ListItem(string6, bl2 ? (byte)2 : 0){

                        public void actionPerformed() {
                            if (bl2) {
                                FilePicker.this.loadFiles(string2 + string5);
                            } else {
                                FilePicker.this.selectFile(string2 + string5 + (bl2 && !string5.endsWith(SEPARATOR) ? SEPARATOR : ""));
                            }
                        }

                        public void iconPressPerformed() {
                            FilePicker.this.showPopup();
                        }
                    }.setDescription(FilePicker.getDescription(string5)).setIcon(FilePicker.getIcon(string5));
                    if (bl2) {
                        this.insert(listItem, n);
                        ++n;
                        continue;
                    }
                    this.add(listItem);
                }
            }
            fileConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.chooseFolder) {
            this.thisItem = new ListItem(Localization.get("fm.chooseThisFolder")){

                public void actionPerformed() {
                    FilePicker.this.selectFile(string2);
                }
            }.setDescription(AppCanvas.instance.touchHud ? string2.substring(string3.length() + 1) : null).setIcon("new/folder-open.rle");
            this.insert(this.thisItem, 1);
        } else {
            this.thisItem = null;
        }
    }

    public void selectFileInList(String string) {
        int n = this.findElement(string);
        if (n != -1) {
            this.updateHeights(this.getWidth(), n + 1);
            this.scrollTo(n);
            this.scrollY = this.toScrollY;
        }
    }

    public int findElement(String string) {
        for (int i = 0; i < this.size(); ++i) {
            PaneItem paneItem = this.at(i);
            if (!(paneItem instanceof ListItem) || !((ListItem)paneItem).caption.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isImage(String string) {
        return string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".bmp");
    }

    public static String getDescription(String string) {
        if (!AppCanvas.instance.touchHud) {
            return null;
        }
        if ((string = FilePicker.getIcon(string)).equals("new/file.rle")) {
            return Localization.get("file.file");
        }
        if (string.equals("new/music-note.rle")) {
            return Localization.get("file.audio");
        }
        if (string.equals("new/image.rle")) {
            return Localization.get("file.photo");
        }
        if (string.equals("new/filmstrip.rle")) {
            return Localization.get("file.video");
        }
        if (string.equals("new/folder.rle")) {
            return Localization.get("file.folder");
        }
        return null;
    }

    public static String getIcon(String string) {
        if (string == null) {
            return "new/file.rle";
        }
        if ((string = string.toLowerCase()).endsWith(SEPARATOR)) {
            return "new/folder.rle";
        }
        if (string.endsWith(".mp3") || string.endsWith(".aac") || string.endsWith(".ogg") || string.endsWith(".wav")) {
            return "new/music-note.rle";
        }
        if (FilePicker.isImage(string)) {
            return "new/image.rle";
        }
        if (string.endsWith(".3gp") || string.endsWith(".avi") || string.endsWith(".mkv") || string.endsWith(".mp4")) {
            return "new/filmstrip.rle";
        }
        return "new/file.rle";
    }

    public static boolean isFolder(ListItem listItem) {
        return listItem.iconObj != null && listItem.iconObj.equals(FilePicker.getIcon(SEPARATOR));
    }

    private void selectFile(String string) {
        this.filePicked(string);
    }

    static {
        SEPARATOR = System.getProperty("file.separator");
        if (SEPARATOR == null) {
            SEPARATOR = "/";
        }
    }
}

