/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.curoviyxru.phoenix.Config;
import ru.curoviyxru.phoenix.Logger;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.SuperString;

public class FontWithEmoji {
    public Font nativeFont;
    public static Thread thr;
    static boolean disallowLoad;
    static Hashtable emojis;
    static Vector toLoad;
    public int height;

    public FontWithEmoji(Font font) {
        this.nativeFont = font;
        this.height = Math.max(16, this.nativeFont.getHeight());
        if (thr == null) {
            thr = new Thread(){

                public void run() {
                    FontWithEmoji.this.loadEmojis();
                }
            };
            thr.setPriority(1);
            thr.start();
        }
    }

    public void drawString(Graphics graphics, SuperString superString, int n, int n2, int n3) {
        if (superString == null || graphics == null) {
            return;
        }
        if ((n3 & 8) == 8) {
            n -= this.stringWidth(superString);
        }
        if ((n3 & 1) == 1) {
            n -= this.stringWidth(superString) / 2;
        }
        if ((n3 & 0x20) == 32) {
            n2 -= this.height;
        }
        if ((n3 & 2) == 2) {
            n2 -= this.height / 2;
        }
        graphics.setFont(this.nativeFont);
        if (!superString.hasEmoji) {
            if (superString.entities.length > 0) {
                graphics.drawString(superString.entities[0], n, n2 + (this.height - this.nativeFont.getHeight()) / 2, 20);
            }
            return;
        }
        int n4 = graphics.getColor();
        int n5 = 0;
        for (int i = 0; i < superString.types.length; ++i) {
            if (superString.types[i] == 1) {
                ++n5;
                if (!disallowLoad) {
                    if (!emojis.containsKey(superString.entities[i]) && !toLoad.contains(superString.entities[i])) {
                        toLoad.addElement(superString.entities[i]);
                        graphics.setColor(Theming.now.nonLoadedContentColor);
                        graphics.fillRect(n + n5, n2 + (this.height - 16) / 2, this.height, this.height);
                    } else {
                        Object v = emojis.get(superString.entities[i]);
                        if (v instanceof Image) {
                            if (Midlet.instance.config.debug_drawEmojiRed) {
                                graphics.setColor(0xFF0000);
                                graphics.fillRect(n + n5, n2 + (this.height - 16) / 2, ((Image)v).getWidth(), ((Image)v).getHeight());
                            }
                            graphics.drawImage((Image)v, n + n5, n2 + (this.height - 16) / 2, 20);
                        } else {
                            graphics.setColor(Theming.now.nonLoadedContentColor);
                            graphics.fillRect(n + n5, n2 + (this.height - 16) / 2, this.height, this.height);
                        }
                    }
                } else {
                    graphics.setColor(Theming.now.nonLoadedContentColor);
                    graphics.fillRect(n + n5, n2 + (this.height - 16) / 2, this.height, this.height);
                }
                n5 += 17;
                continue;
            }
            graphics.setColor(n4);
            graphics.drawString(superString.entities[i], n + n5, n2 + (this.height - this.nativeFont.getHeight()) / 2, 20);
            n5 += this.nativeFont.stringWidth(superString.entities[i]);
        }
        graphics.setColor(n4);
    }

    public void loadEmojis() {
        while (!disallowLoad) {
            try {
                if (toLoad.isEmpty() || AppCanvas.instance.content == null || AppCanvas.instance.slAnim.started) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                for (int i = 0; i < toLoad.size(); ++i) {
                    try {
                        String string = (String)toLoad.elementAt(i);
                        Logger.l("Trying to get emoji " + string);
                        Image image = AppCanvas.loadLocal("emoji/" + string + ".png");
                        if (image == null) {
                            Logger.l("Failed to get emoji " + string);
                        }
                        emojis.put(string, image != null ? image : "null");
                        toLoad.removeElementAt(i);
                        --i;
                        AppCanvas.instance.render();
                        continue;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw outOfMemoryError;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                toLoad.removeAllElements();
                emojis.clear();
                disallowLoad = true;
                System.gc();
            }
        }
    }

    public int stringWidth(SuperString superString) {
        if (superString == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < superString.types.length; ++i) {
            n += superString.types[i] == 1 ? 18 : this.nativeFont.stringWidth(superString.entities[i]);
        }
        return n;
    }

    public SuperString[] multiline(SuperString superString, int n) {
        if (superString == null || superString.length == 0) {
            return new SuperString[0];
        }
        Vector<SuperString> vector = new Vector<SuperString>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < superString.types.length; ++i) {
            if (superString.types[i] == 1) {
                if (n2 + this.nativeFont.stringWidth(stringBuffer2.toString()) + 16 > n) {
                    n2 = 0;
                    vector.addElement(new SuperString(stringBuffer.toString()));
                    stringBuffer2.setLength(0);
                    stringBuffer.setLength(0);
                }
                n2 += 18;
                stringBuffer.append(SuperString.hexToString(superString.entities[i]));
                continue;
            }
            String string = superString.entities[i];
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '\n') {
                    n2 = 0;
                    vector.addElement(new SuperString(stringBuffer.toString()));
                    stringBuffer2.setLength(0);
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(string.charAt(j));
                stringBuffer2.append(string.charAt(j));
                if (this.nativeFont.stringWidth(stringBuffer2.toString()) + n2 <= n) continue;
                if (stringBuffer.toString().lastIndexOf(32) != -1) {
                    String string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    n2 = 0;
                    int n3 = string2.lastIndexOf(32);
                    vector.addElement(new SuperString(string2.substring(0, n3)));
                    stringBuffer2.append(string2.substring(n3 + 1, string2.length()));
                    stringBuffer.append(string2.substring(n3 + 1, string2.length()));
                    continue;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                vector.addElement(new SuperString(stringBuffer.toString()));
                stringBuffer.setLength(0);
                stringBuffer2.setLength(0);
                n2 = 0;
                stringBuffer.append(string.charAt(j));
                stringBuffer2.append(string.charAt(j));
            }
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(new SuperString(stringBuffer.toString()));
        }
        Object[] objectArray = new SuperString[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SuperString limit(SuperString superString, int n, boolean bl) {
        if (superString == null || superString.length == 0) {
            return superString;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < superString.types.length; ++i) {
            if (superString.types[i] == 1) {
                if (n2 + this.nativeFont.stringWidth(stringBuffer2.toString().trim() + (bl ? "..." : "")) + 16 > n) {
                    return new SuperString(stringBuffer.toString().trim() + (bl ? "..." : ""));
                }
                n2 += 18;
                stringBuffer.append(SuperString.hexToString(superString.entities[i]));
                continue;
            }
            String string = superString.entities[i];
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '\n') {
                    stringBuffer.append(' ');
                    stringBuffer2.append(' ');
                } else {
                    stringBuffer.append(string.charAt(j));
                    stringBuffer2.append(string.charAt(j));
                }
                if (this.nativeFont.stringWidth(stringBuffer2.toString().trim() + (bl ? "..." : "")) + n2 <= n) continue;
                stringBuffer.setLength(stringBuffer.length() - 1);
                return new SuperString(stringBuffer.toString().trim() + (bl ? "..." : ""));
            }
        }
        return new SuperString(stringBuffer.toString());
    }

    public SuperString hide(SuperString superString, boolean bl) {
        if (superString == null) {
            return null;
        }
        int n = superString.types.length - 1;
        SuperString superString2 = new SuperString(null);
        superString2.types = new byte[superString.types.length];
        superString2.entities = new String[superString.entities.length];
        superString2.hasEmoji = bl && superString.types.length != 0 ? superString.types[n] == 1 : false;
        superString2.length = superString.length;
        for (int i = 0; i < superString.types.length - (bl ? 1 : 0); ++i) {
            superString2.types[n] = 0;
            superString2.entities[i] = superString.types[i] == 1 ? "*" : PaneItem.hide(superString.entities[i], false);
        }
        if (bl && superString.types.length != 0) {
            if (superString.types[n] == 1) {
                superString2.types[n] = 1;
                superString2.entities[n] = superString.entities[n];
            } else {
                superString2.types[n] = 0;
                superString2.entities[n] = PaneItem.hide(superString.entities[n], true);
            }
        }
        return superString2;
    }

    static {
        disallowLoad = !Config.hasEmojis;
        emojis = new Hashtable();
        toLoad = new Vector();
    }
}

