/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.ImageProvider;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.RenderUtil;
import ru.curoviyxru.phoenix.ui.contents.ImageViewer;

public class ImageItem
extends PaneItem
implements ImageProvider {
    public Image cached;
    public int iw;
    public int ih;
    public boolean local;
    public String url;
    public boolean doNotCircle;
    public byte align = (byte)4;
    int tries;
    Photo photo;

    public int tries() {
        return this.tries;
    }

    public void tried() {
        if (this.tries > 5) {
            return;
        }
        ++this.tries;
    }

    public ImageItem(Photo photo, String string, boolean bl, int n, int n2) {
        this.cAction = Localization.get("action.reveal");
        this.photo = photo;
        this.iw = n;
        this.ih = n2;
        this.local = bl;
        this.url = Midlet.instance.config.doNotLoadImages ? null : string;
        this.skipSelection(Midlet.instance.config.doNotLoadImages);
        AppCanvas.instance.queue(this);
    }

    public void actionPerformed() {
        if (this.photo != null) {
            AppCanvas.instance.goTo(ImageViewer.instance.setPhoto(this.photo, null, this).parent(this.content));
        }
    }

    public ImageItem setAlign(int n) {
        this.align = (byte)n;
        return this;
    }

    public void updateHeight() {
        if (this.url == null) {
            this.height = 0;
        } else {
            if (this.cached != null) {
                this.ih = Math.min(this.ih, this.cached.getHeight());
                this.iw = Math.min(this.iw, this.cached.getWidth());
            }
            this.height = this.ih + AppCanvas.instance.perLineSpace + AppCanvas.instance.perLineSpace;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        this.updateHeight();
        if (this.url == null) {
            return;
        }
        n += AppCanvas.instance.perLineSpace;
        int n4 = this.align == 4 ? 0 : (n3 = this.align == 8 ? this.width - this.iw : (this.width - this.iw) / 2);
        if (this.cached != null) {
            graphics.drawRegion(this.cached, (this.cached.getWidth() - this.iw) / 2, (this.cached.getHeight() - this.ih) / 2, this.iw, this.ih, 0, this.x + n2 + n3, this.y + n, 20);
        } else {
            AppCanvas.instance.queue(this);
            graphics.setColor(Theming.now.nonLoadedContentColor);
            graphics.fillRect(this.x + n2 + n3, this.y + n, this.iw, this.ih);
        }
        if (!this.doNotCircle && AppCanvas.tranImageStandard != null) {
            graphics.drawImage(AppCanvas.tranImageStandard, this.x + n2 + n3, this.y + n, 20);
            graphics.drawRegion(AppCanvas.tranImageStandard, 0, 0, AppCanvas.tranSize, AppCanvas.tranSize, 5, this.x + n2 + n3 + this.iw - AppCanvas.tranSize, this.y + n, 0);
            graphics.drawRegion(AppCanvas.tranImageStandard, 0, 0, AppCanvas.tranSize, AppCanvas.tranSize, 3, this.x + n2 + n3 + this.iw - AppCanvas.tranSize, this.y + n + this.ih - AppCanvas.tranSize, 0);
            graphics.drawRegion(AppCanvas.tranImageStandard, 0, 0, AppCanvas.tranSize, AppCanvas.tranSize, 6, this.x + n2 + n3, this.y + n + this.ih - AppCanvas.tranSize, 0);
        }
        if (this.pressed && this.focusable) {
            graphics.setColor(Theming.now.focusedBorderColor);
            graphics.drawRect(this.x + n2 + n3, this.y + n, this.iw, this.ih);
        }
    }

    public ImageItem doNotCircle(boolean bl) {
        this.doNotCircle = bl;
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean local(int n) {
        return this.local;
    }

    public String get(int n) {
        return this.cached == null ? this.url : null;
    }

    public void set(int n, Image image) {
        if (image == null) {
            return;
        }
        this.cached = RenderUtil.resizeImage(image, Math.min(this.ih, this.iw * image.getHeight() / Math.max(1, image.getWidth())));
        this.ih = this.cached.getHeight();
        this.iw = this.cached.getWidth();
    }

    public void errored(Throwable throwable) {
        AppCanvas.instance.dropError("Image item: " + throwable != null ? throwable.getMessage() : "Unknown error");
    }
}

