/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import ru.curoviyxru.phoenix.Logger;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.Field;
import ru.curoviyxru.phoenix.ui.PasswordField;

public class KeyboardUtil {
    static int last = -1;
    static int caret = -1;
    static int lang = 0;
    static int timeoutTicks = 0;
    static char[][] ENG12 = new char[][]{{' ', '*', '#', '+', '0'}, {'.', ',', '?', '!', '@', '\'', '-', '_', '(', ')', ':', ';', '/', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {' ', '*', '#'}};
    static char[][] RUS12 = new char[][]{{' ', '*', '#', '+', '0'}, {'.', ',', '?', '!', '@', '\'', '-', '_', '(', ')', ':', ';', '/', '1'}, {'\u0430', '\u0431', '\u0432', '\u0433', '2'}, {'\u0434', '\u0435', '\u0451', '\u0436', '\u0437', '3'}, {'\u0438', '\u0439', '\u043a', '\u043b', '4'}, {'\u043c', '\u043d', '\u043e', '\u043f', '5'}, {'\u0440', '\u0441', '\u0442', '\u0443', '6'}, {'\u0444', '\u0445', '\u0446', '\u0447', '7'}, {'\u0448', '\u0449', '\u044a', '\u044b', '8'}, {'\u044c', '\u044d', '\u044e', '\u044f', '9'}};

    public static void keyPressed(int n, Field field) {
        Logger.l("[KEY]: " + n);
        if (!KeyboardUtil.isAccepted(n)) {
            return;
        }
        if (field == null) {
            return;
        }
        char c = (char)n;
        if (n == 1000010) {
            field.setText(field.text == null || field.text.length == 0 ? null : field.text.deleteLast());
        } else if (Character.isDigit(c) || c == '*' || c == '#') {
            KeyboardUtil.digitPressed(field, c, false);
        } else if (n == 32) {
            field.setText((field.text == null ? "" : field.text.toString()) + ' ');
        } else if (n == 1000011) {
            field.setText((field.text == null ? "" : field.text.toString()) + '\n');
        } else if (n == 8) {
            field.actionPerformed();
            KeyboardUtil.tryVibrate();
        } else {
            String string;
            if (Midlet.instance.config.replaceEmailAtYo && c == '@') {
                c = '\u0451';
            }
            String string2 = string = field.text == null ? "" : field.text.toString();
            if (!(field instanceof PasswordField) && Midlet.instance.config.upperFirstChar && (field.text == null || field.text.length == 0 || string.trim().endsWith("."))) {
                c = Character.isUpperCase(c) ? Character.toLowerCase(c) : Character.toUpperCase(c);
            }
            field.setText(string + c);
        }
        if (field instanceof PasswordField) {
            ((PasswordField)field).showLastChar = 3;
            ((PasswordField)field).hideText = null;
        }
        KeyboardUtil.tryVibrate();
    }

    public static void keyRepeated(int n, Field field) {
        if (!KeyboardUtil.isAccepted(n)) {
            return;
        }
        if (field == null) {
            return;
        }
        char c = (char)n;
        if (Character.isDigit(c) || c == '*' || c == '#') {
            KeyboardUtil.digitPressed(field, c, true);
            KeyboardUtil.tryVibrate();
        } else if (n != 1000011) {
            KeyboardUtil.keyPressed(n, field);
        }
    }

    public static boolean isAccepted(int n) {
        switch (n) {
            case 8: 
            case 32: 
            case 1000010: 
            case 1000011: {
                return true;
            }
        }
        return n >= 32 || Character.isDigit((char)n) || Character.isLowerCase((char)n) || Character.isUpperCase((char)n);
    }

    public static void tryVibrate() {
        if (Midlet.instance.config.feed_keyVibro) {
            Display.getDisplay((MIDlet)Midlet.instance).vibrate(Midlet.instance.config.keyVibroTime);
        }
    }

    public static void messageVibrate() {
        if (Midlet.instance.config.vibroOnSend) {
            Display.getDisplay((MIDlet)Midlet.instance).vibrate(Midlet.instance.config.sendVibroTime);
        }
    }

    private static void digitPressed(Field field, int n, boolean bl) {
        if (field == null) {
            return;
        }
        if (!Midlet.instance.config.useKeypadInput) {
            field.setText((field.text == null ? "" : field.text.toString()) + (char)n);
            return;
        }
        n = n == 35 ? 10 : (n == 42 ? 11 : (n -= 48));
        if (n == 11) {
            lang = (lang + 1) % 4;
            last = 11;
            caret = -1;
            timeoutTicks = 6;
        } else if (n == 10) {
            last = 10;
            caret = -1;
            timeoutTicks = 6;
            field.setText(field.text == null || field.text.length == 0 ? null : field.text.deleteLast());
        } else if (last != n || caret == -1) {
            char c;
            last = n;
            caret = 0;
            if (bl) {
                caret = (lang / 2 == 0 ? ENG12[last].length : RUS12[last].length) - 1;
            }
            timeoutTicks = 6;
            char c2 = c = lang / 2 == 0 ? ENG12[last][caret] : RUS12[last][caret];
            if (lang % 2 == 1) {
                c = Character.toUpperCase(c);
            }
            field.setText((field.text == null ? "" : field.text.toString()) + c);
        } else {
            char c;
            timeoutTicks = 6;
            caret = (caret + 1) % (lang / 2 == 0 ? ENG12[last].length : RUS12[last].length);
            if (bl) {
                caret = (lang / 2 == 0 ? ENG12[last].length : RUS12[last].length) - 1;
            }
            char c3 = c = lang / 2 == 0 ? ENG12[last][caret] : RUS12[last][caret];
            if (lang % 2 == 1) {
                c = Character.toUpperCase(c);
            }
            field.setText(field.text == null || field.text.length == 0 ? null : field.text.deleteLast());
            field.setText((field.text == null ? "" : field.text.toString()) + c);
        }
    }
}

