/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;

public abstract class PaneItem {
    public Content content;
    public int width;
    public int height;
    public int x;
    public int y;
    public boolean pressed;
    public boolean focusable = true;
    public String cAction;
    boolean separatorAfter;
    boolean separatorBefore;
    boolean skipSelection;
    int lx;
    int ly;
    int dist;

    public void resetCache() {
    }

    public PaneItem separatorBefore(boolean bl) {
        this.separatorBefore = bl;
        return this;
    }

    public PaneItem skipSelection(boolean bl) {
        this.skipSelection = bl;
        return this;
    }

    public PaneItem separatorAfter(boolean bl) {
        this.separatorAfter = bl;
        return this;
    }

    public PaneItem keyPressed(int n, int n2) {
        return this;
    }

    public PaneItem keyReleased(int n, int n2) {
        if ((n == 8 || n == 1000011) && this.pressed && this.focusable) {
            this.actionPerformed();
        }
        return this;
    }

    public PaneItem keyRepeated(int n, int n2) {
        return this;
    }

    public PaneItem pointerPressed(int n, int n2, int n3) {
        this.pressed = this.focusable && n < this.x + this.width && n > this.x && n2 < this.y + this.height + AppCanvas.instance.contentY - n3 && n2 > this.y + AppCanvas.instance.contentY - n3;
        this.lx = n;
        this.ly = n2 - n3;
        this.dist = 0;
        return this;
    }

    public PaneItem pointerDragged(int n, int n2, int n3) {
        this.dist += (this.lx - n) * (this.lx - n) + (n2 - n3 - this.ly) * (n2 - n3 - this.ly);
        if ((double)this.dist > AppCanvas.instance.fingerDist) {
            this.pressed = false;
        }
        this.lx = n;
        this.ly = n2 - n3;
        return this;
    }

    public PaneItem pointerReleased(int n, int n2, int n3) {
        if (this.pressed && this.focusable) {
            this.actionPerformed();
        }
        this.pressed = false;
        return this;
    }

    public PaneItem setFocusable(boolean bl) {
        this.focusable = bl;
        return this;
    }

    public abstract void updateHeight();

    public abstract void paint(Graphics var1, int var2, int var3);

    public static String limit(String string, int n, boolean bl, Font font) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(string.charAt(i));
            }
            if (font.stringWidth(stringBuffer.toString().trim() + (bl ? "..." : "")) <= n) continue;
            stringBuffer.setLength(stringBuffer.length() - 1);
            return stringBuffer.toString().trim() + (bl ? "..." : "");
        }
        return stringBuffer.toString();
    }

    public static String[] multiline(String string, int n, Font font) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(string.charAt(i));
            if (font.stringWidth(stringBuffer.toString()) <= n) continue;
            if (stringBuffer.toString().lastIndexOf(32) != -1) {
                String string2 = stringBuffer.toString();
                stringBuffer.setLength(0);
                int n2 = string2.lastIndexOf(32);
                vector.addElement(string2.substring(0, n2));
                stringBuffer.append(string2.substring(n2 + 1, string2.length()));
                continue;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            vector.addElement(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String hide(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        for (int i = cArray.length - (bl ? 2 : 1); i >= 0; --i) {
            cArray[i] = 42;
        }
        if (bl && string.length() > 0) {
            cArray[cArray.length - 1] = string.charAt(cArray.length - 1);
        }
        return new String(cArray);
    }

    public void actionPerformed() {
    }

    public static interface ItemThatUsesFullWidth {
    }

    public static interface ItemThatUsesLeftAndRight {
    }
}

