/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Field;

public class RenderUtil {
    public static Hashtable iconsCache = new Hashtable();
    public static Image[] scrollBuffers;
    public static int sLength;
    public static int cloudPadding;
    public static final int TL = 1;
    public static final int TR = 2;
    public static final int BL = 8;
    public static final int BR = 4;
    public static final int ALL = 15;
    public static Image shadow;

    public static void init() {
        if (!Midlet.instance.config.gui_disableDimm && shadow == null) {
            shadow = AppCanvas.loadLocal("new/shadow.png");
        }
    }

    public static void clear() {
        iconsCache.clear();
        System.gc();
    }

    public static Image renderScroll(int n, int n2, int n3) {
        if (n2 <= 0) {
            n2 = 1;
        }
        int n4 = n2 * AppCanvas.instance.scrollWidth;
        if (scrollBuffers == null || sLength != n4) {
            scrollBuffers = new Image[7];
            sLength = n4;
        }
        if (scrollBuffers[n3] == null) {
            int n5 = 255 * n3 / 10 / 2 << 24;
            n5 |= n & 0xFFFFFF;
            int[] nArray = new int[sLength];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n5;
            }
            RenderUtil.scrollBuffers[n3] = Image.createRGBImage((int[])nArray, (int)AppCanvas.instance.scrollWidth, (int)n2, (boolean)true);
        }
        return scrollBuffers != null ? scrollBuffers[n3] : null;
    }

    public static Image circlify(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return RenderUtil.circlify(n, n2, n3, n4, n5, n6, 0, n2, bl);
    }

    public static Image circlify(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        int n11;
        if (!Midlet.instance.config.gui_drawGradients) {
            n4 = n5 = RenderUtil.mix(n4, n5, 128);
        }
        if (n < 1 || n2 < 1 || n3 < 1) {
            return null;
        }
        if (bl) {
            n4 |= 0xFF000000;
            n5 |= 0xFF000000;
        }
        int[] nArray = new int[n * n2];
        if (n4 == n5) {
            for (n11 = 0; n11 < nArray.length; ++n11) {
                nArray[n11] = n4;
            }
        } else {
            for (n11 = 0; n11 < n2; ++n11) {
                n10 = RenderUtil.mix(n4, n5, 255 * (n11 + n7) / Math.max(1, n8 - 1));
                for (n9 = 0; n9 < n; ++n9) {
                    nArray[n11 * n + n9] = n10;
                }
            }
        }
        n11 = Math.max(n6 & 1, n6 >> 1 & 1);
        n10 = Math.max(n6 >> 2 & 1, n6 >> 2 & 1);
        n9 = n11 <= 0 || n10 <= 0 ? 1 : 0;
        boolean bl2 = (n6 & 1) == 1;
        boolean bl3 = (n6 & 2) == 2;
        boolean bl4 = (n6 & 8) == 8;
        boolean bl5 = (n6 & 4) == 4;
        n3 = n9 != 0 ? Math.min(n3, Math.min(n, n2)) : Math.min(n3, Math.min(n / 2, n2 / 2));
        int n12 = n3 * 2;
        int n13 = n3 * n3;
        int n14 = n13 * 4;
        for (int i = 0; i < n3; ++i) {
            int n15 = (n3 - i) * (n3 - i);
            int n16 = n15 * 4;
            int n17 = (n12 - 1 - i * 2) * (n12 - 1 - i * 2);
            for (int j = 0; j < n3; ++j) {
                int n18 = (n3 - j) * (n3 - j);
                int n19 = n18 * 4;
                int n20 = (n12 - 1 - j * 2) * (n12 - 1 - j * 2);
                int n21 = n18 + n15 >= n13 ? 63 : 0;
                n21 += n19 + n17 >= n14 ? 64 : 0;
                n21 += n20 + n16 >= n14 ? 64 : 0;
                n21 += n20 + n17 >= n14 ? 64 : 0;
                if (bl) {
                    n21 = 255 - n21;
                }
                n21 <<= 24;
                int n22 = j;
                int n23 = i;
                if (bl2) {
                    int n24 = i * n + j;
                    int n25 = nArray[n24] & 0xFFFFFF;
                    nArray[n24] = n25;
                    nArray[i * n + j] = n21 | n25;
                }
                j = n - j - 1;
                if (bl3) {
                    int n26 = i * n + j;
                    int n27 = nArray[n26] & 0xFFFFFF;
                    nArray[n26] = n27;
                    nArray[i * n + j] = n21 | n27;
                }
                i = n2 - i - 1;
                if (bl5) {
                    int n28 = i * n + j;
                    int n29 = nArray[n28] & 0xFFFFFF;
                    nArray[n28] = n29;
                    nArray[i * n + j] = n21 | n29;
                }
                j = n22;
                if (bl4) {
                    int n30 = i * n + j;
                    int n31 = nArray[n30] & 0xFFFFFF;
                    nArray[n30] = n31;
                    nArray[i * n + j] = n21 | n31;
                }
                i = n23;
            }
        }
        return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
    }

    public static Image circlify(int n, Image image, int n2) {
        if (n < 1) {
            return image;
        }
        if (image == null) {
            return null;
        }
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int[] nArray = new int[n3 * n4];
        image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
        int n5 = Math.max(n2 & 1, n2 >> 1 & 1);
        int n6 = Math.max(n2 >> 2 & 1, n2 >> 2 & 1);
        boolean bl = n5 <= 0 || n6 <= 0;
        boolean bl2 = (n2 & 1) == 1;
        boolean bl3 = (n2 & 2) == 2;
        boolean bl4 = (n2 & 8) == 8;
        boolean bl5 = (n2 & 4) == 4;
        n = bl ? Math.min(n, Math.min(n3, n4)) : Math.min(n, Math.min(n3 / 2, n4 / 2));
        int n7 = n * 2;
        int n8 = n * n;
        int n9 = n8 * 4;
        for (int i = 0; i < n; ++i) {
            int n10 = (n - i) * (n - i);
            int n11 = n10 * 4;
            int n12 = (n7 - 1 - i * 2) * (n7 - 1 - i * 2);
            for (int j = 0; j < n; ++j) {
                int n13;
                int n14 = (n - j) * (n - j);
                int n15 = n14 * 4;
                int n16 = (n7 - 1 - j * 2) * (n7 - 1 - j * 2);
                int n17 = n14 + n10 >= n8 ? 63 : 0;
                n17 += n15 + n12 >= n9 ? 64 : 0;
                n17 += n16 + n11 >= n9 ? 64 : 0;
                n17 += n16 + n12 >= n9 ? 64 : 0;
                n17 = 255 - n17;
                int n18 = j;
                int n19 = i;
                if (bl2) {
                    n13 = nArray[i * n3 + j];
                    nArray[i * n3 + j] = n17 * (n13 >>> 24) / 255 << 24 | n13 & 0xFFFFFF;
                }
                j = n3 - j - 1;
                if (bl3) {
                    n13 = nArray[i * n3 + j];
                    nArray[i * n3 + j] = n17 * (n13 >>> 24) / 255 << 24 | n13 & 0xFFFFFF;
                }
                i = n4 - i - 1;
                if (bl5) {
                    n13 = nArray[i * n3 + j];
                    nArray[i * n3 + j] = n17 * (n13 >>> 24) / 255 << 24 | n13 & 0xFFFFFF;
                }
                j = n18;
                if (bl4) {
                    n13 = nArray[i * n3 + j];
                    nArray[i * n3 + j] = n17 * (n13 >>> 24) / 255 << 24 | n13 & 0xFFFFFF;
                }
                i = n19;
            }
        }
        return Image.createRGBImage((int[])nArray, (int)n3, (int)n4, (boolean)true);
    }

    public static Image genBorderOutline(int n, int n2) {
        if (n < 1) {
            return null;
        }
        int[] nArray = new int[n * n];
        n2 &= 0xFFFFFF;
        int n3 = n * 2;
        int n4 = n * n;
        for (int i = 0; i < n; ++i) {
            int n5 = i * n;
            int n6 = (n - i) * (n - i);
            int n7 = n6 * 4;
            int n8 = (n3 - 1 - i * 2) * (n3 - 1 - i * 2);
            for (int j = 0; j < n; ++j) {
                int n9 = (n - j) * (n - j);
                int n10 = n9 * 4;
                int n11 = (n3 - 1 - j * 2) * (n3 - 1 - j * 2);
                int n12 = Math.abs(n6 + n9 - n4) <= n ? 63 : 0;
                n12 += Math.abs(n7 / 4 + n11 / 4 - n4) <= n ? 64 : 0;
                n12 += Math.abs(n8 / 4 + n10 / 4 - n4) <= n ? 64 : 0;
                nArray[j + n5] = (n12 += Math.abs(n8 / 4 + n11 / 4 - n4) <= n ? 64 : 0) << 24 | n2;
            }
        }
        return Image.createRGBImage((int[])nArray, (int)n, (int)n, (boolean)true);
    }

    public static void drawTextField(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Image image;
        graphics.setColor(bl ? Theming.now.focusedBorderColor : Theming.now.borderColor);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        Image image2 = image = bl ? Field.borderImageSelected : Field.borderImage;
        if (image != null) {
            graphics.setColor(bl2 ? Theming.now.popupColor : Theming.now.backgroundColor);
            graphics.fillRect(n, n2, Field.circleSize, Field.circleSize);
            graphics.fillRect(n + n3 - Field.circleSize, n2 + n4 - Field.circleSize, Field.circleSize, Field.circleSize);
            graphics.fillRect(n + n3 - Field.circleSize, n2, Field.circleSize, Field.circleSize);
            graphics.fillRect(n, n2 + n4 - Field.circleSize, Field.circleSize, Field.circleSize);
            graphics.drawImage(image, n, n2, 20);
            graphics.drawRegion(image, 0, 0, Field.circleSize, Field.circleSize, 5, n + n3 - Field.circleSize, n2, 0);
            graphics.drawRegion(image, 0, 0, Field.circleSize, Field.circleSize, 3, n + n3 - Field.circleSize, n2 + n4 - Field.circleSize, 0);
            graphics.drawRegion(image, 0, 0, Field.circleSize, Field.circleSize, 6, n, n2 + n4 - Field.circleSize, 0);
        }
    }

    public static void fillRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getColor();
        if (!Midlet.instance.config.gui_drawGradients) {
            n5 = n6 = RenderUtil.mix(n5, n6, 128);
        }
        if (n5 == n6) {
            graphics.setColor(n5);
            graphics.fillRect(n, n2, n3, n4);
        } else {
            for (int i = 0; i < n4; ++i) {
                graphics.setColor(RenderUtil.mix(n5, n6, 255 * (i + 1) / n4));
                graphics.drawLine(n, n2 + i, n + n3 - 1, n2 + i);
            }
        }
        graphics.setColor(n7);
    }

    public static Image resizeImage(Image image, int n) {
        if (image == null) {
            return null;
        }
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        if (n <= 0) {
            return Image.createImage((int)1, (int)1);
        }
        int[] nArray = new int[n2 * n3];
        image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        return RenderUtil.resizeImage(nArray, n2, n3, n);
    }

    public static Image resizeImage(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        if (nArray == null) {
            return null;
        }
        if (n3 <= 0 || n <= 0 || n2 <= 0) {
            return Image.createImage((int)1, (int)1);
        }
        int n19 = n3;
        int n20 = n * n3 / Math.max(n2, 1);
        if (n20 <= 1 || n20 <= 1) {
            return Image.createImage((int)1, (int)1);
        }
        int[] nArray2 = new int[n20 * n2];
        int[] nArray3 = new int[n20 * n19];
        if (n20 < n) {
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n;
                n16 = n18 * n20;
                n15 = n20;
                n14 = 0;
                n13 = 0;
                n12 = 0;
                n11 = 0;
                n10 = 0;
                for (n9 = 0; n9 < n20; ++n9) {
                    n8 = n;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    if (n14 != 0) {
                        n7 = n13 * n14;
                        n6 = n12 * n14;
                        n5 = n11 * n14;
                        n4 = n10 * n14;
                        n8 -= n14;
                    }
                    while (0 < n8) {
                        n10 = nArray[n17] >> 24 & 0xFF;
                        n13 = nArray[n17] >> 16 & 0xFF;
                        n12 = nArray[n17] >> 8 & 0xFF;
                        n11 = nArray[n17++] & 0xFF;
                        if (n8 > n15) {
                            n7 += n13 * n15;
                            n6 += n12 * n15;
                            n5 += n11 * n15;
                            n4 += n10 * n15;
                        } else {
                            n14 = n15 - n8;
                            nArray2[n16++] = (n7 += n13 * n8) / n << 16 | (n6 += n12 * n8) / n << 8 | (n5 += n11 * n8) / n | (n4 += n10 * n8) / n << 24;
                        }
                        n8 -= n15;
                    }
                }
            }
        } else {
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n;
                n16 = n18 * n20;
                for (n15 = 0; n15 < n20; ++n15) {
                    n14 = (n15 << 8) * (n - 1) / (n20 - 1);
                    n13 = n14 >>> 8;
                    n12 = n14 & 0xFF;
                    n11 = nArray[n17 + n13];
                    if (n13 < n - 1) {
                        n10 = nArray[n17 + n13 + 1];
                        n11 = RenderUtil.mix(n11, n10, n12);
                    }
                    nArray2[n16++] = n11;
                }
            }
        }
        if (n19 < n2) {
            for (n18 = 0; n18 < n20; ++n18) {
                n17 = n18;
                n16 = n18;
                n15 = n19;
                n14 = 0;
                n13 = 0;
                n12 = 0;
                n11 = 0;
                n10 = 0;
                for (n9 = 0; n9 < n19; ++n9) {
                    n8 = n2;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    if (n14 != 0) {
                        n7 = n13 * n14;
                        n6 = n12 * n14;
                        n5 = n11 * n14;
                        n4 = n10 * n14;
                        n8 -= n14;
                    }
                    while (0 < n8) {
                        n10 = nArray2[n17] >> 24 & 0xFF;
                        n13 = nArray2[n17] >> 16 & 0xFF;
                        n12 = nArray2[n17] >> 8 & 0xFF;
                        n11 = nArray2[n17] & 0xFF;
                        n17 += n20;
                        if (n8 > n15) {
                            n7 += n13 * n15;
                            n6 += n12 * n15;
                            n5 += n11 * n15;
                            n4 += n10 * n15;
                        } else {
                            n14 = n15 - n8;
                            nArray3[n16] = 0 != (n4 += n10 * n8) ? (n7 += n13 * n8) / n2 << 16 | (n6 += n12 * n8) / n2 << 8 | (n5 += n11 * n8) / n2 | n4 / n2 << 24 : 0;
                            n16 += n20;
                        }
                        n8 -= n15;
                    }
                }
            }
        } else {
            for (n18 = 0; n18 < n20; ++n18) {
                n17 = n18;
                n16 = n18;
                for (n15 = 0; n15 < n19; ++n15) {
                    n14 = (n15 << 8) * (n2 - 1) / (n19 - 1);
                    n13 = n14 >>> 8;
                    n12 = n14 & 0xFF;
                    n11 = nArray2[n17 + n13 * n20];
                    if (n13 < n2 - 1) {
                        n10 = nArray2[n17 + (n13 + 1) * n20];
                        n11 = RenderUtil.mix(n11, n10, n12);
                    }
                    nArray3[n16] = n11;
                    n16 += n20;
                }
            }
        }
        return Image.createRGBImage((int[])nArray3, (int)n20, (int)n19, (boolean)true);
    }

    public static void renderListItemIcon(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        String string2 = string + "_" + n6 + "_" + n3;
        Integer n8 = (Integer)iconsCache.get(string2);
        int n9 = n8 == null ? 0 : n8;
        n9 = Theming.now.drawImage(graphics, n, n2, n9, string, n4, n5, n6, n7);
        if (n8 == null || n8 == 0) {
            iconsCache.put(string2, new Integer(n9));
        }
    }

    static void renderShadow(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (Midlet.instance.config.gui_disableDimm || shadow == null) {
            return;
        }
        int n7 = shadow.getWidth() / 3;
        int n8 = n7 >> 1;
        int n9 = Math.min(n8, n3 / 2);
        int n10 = Math.min(n8, n4 / 2);
        graphics.drawRegion(shadow, 0, 0, n8 + n9, n8 + n10, 0, n - n8, n2 - n8, 0);
        n9 = Math.min(n8, n3 - n3 / 2);
        graphics.drawRegion(shadow, n7 * 2 + n8 - n9, 0, n8 + n9, n8 + n10, 0, n + n3 - n9, n2 - n8, 0);
        n9 = Math.min(n8, n3 / 2);
        n10 = Math.min(n8, n4 - n4 / 2);
        graphics.drawRegion(shadow, 0, n7 * 2 + n8 - n10, n8 + n9, n8 + n10, 0, n - n8, n2 + n4 - n10, 0);
        n9 = Math.min(n8, n3 - n3 / 2);
        graphics.drawRegion(shadow, n7 * 2 + n8 - n9, n7 * 2 + n8 - n10, n8 + n9, n8 + n10, 0, n + n3 - n9, n2 + n4 - n10, 0);
        n9 = n + n3 - n8;
        for (n6 = n + n8; n6 < n9; n6 += n7) {
            n5 = Math.min(n9 - n6, n7);
            graphics.drawRegion(shadow, n7, 0, n5, n7, 0, n6, n2 - n8, 0);
            graphics.drawRegion(shadow, n7, n7 * 2, n5, n7, 0, n6, n2 + n4 - n8, 0);
        }
        n10 = n2 + n4 - n8;
        for (n6 = n2 + n8; n6 < n10; n6 += n7) {
            n5 = Math.min(n10 - n6, n7);
            graphics.drawRegion(shadow, 0, n7, n7, n5, 0, n - n8, n6, 0);
            graphics.drawRegion(shadow, n7 * 2, n7, n7, n5, 0, n + n3 - n8, n6, 0);
        }
    }

    public static int mix(int n, int n2, int n3) {
        if (n3 == 0) {
            return n;
        }
        if (n3 == 255) {
            return n2;
        }
        int n4 = 255 - n3;
        int n5 = ((n >>> 24 & 0xFF) * n4 + (n2 >>> 24 & 0xFF) * n3) / 255;
        int n6 = ((n >> 16 & 0xFF) * n4 + (n2 >> 16 & 0xFF) * n3) / 255;
        int n7 = ((n >> 8 & 0xFF) * n4 + (n2 >> 8 & 0xFF) * n3) / 255;
        int n8 = ((n & 0xFF) * n4 + (n2 & 0xFF) * n3) / 255;
        return n5 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    static int focused(int n) {
        int n2 = (n >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF);
        if (n2 >= 384) {
            return RenderUtil.mix(n, 0, 22);
        }
        return RenderUtil.mix(n, 0xFFFFFF, 40);
    }

    static int textColorOn(int n) {
        int n2 = (n >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF);
        if (n2 >= 384) {
            return 0;
        }
        return 0xFFFFFF;
    }

    static {
        sLength = -1;
        cloudPadding = AppCanvas.instance.normalEmojiFont.height / 3;
    }
}

