/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import javax.microedition.lcdui.Graphics;
import ru.curoviyxru.j2vk.api.objects.ImItem;
import ru.curoviyxru.j2vk.api.objects.attachments.Comment;
import ru.curoviyxru.j2vk.api.objects.attachments.Post;
import ru.curoviyxru.j2vk.api.requests.wall.WallGetComment;
import ru.curoviyxru.j2vk.api.requests.wall.WallGetComments;
import ru.curoviyxru.j2vk.api.responses.wall.WallGetCommentResponse;
import ru.curoviyxru.j2vk.api.responses.wall.WallGetCommentsResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.KeyboardUtil;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.PopupMenu;
import ru.curoviyxru.phoenix.ui.contents.NewsfeedContent;
import ru.curoviyxru.phoenix.ui.contents.PostContent;
import ru.curoviyxru.phoenix.ui.contents.ScrollContent;
import ru.curoviyxru.phoenix.ui.im.ImContent;
import ru.curoviyxru.phoenix.ui.im.ImField;
import ru.curoviyxru.phoenix.ui.im.ImHolder;
import ru.curoviyxru.phoenix.ui.im.MainImItem;
import ru.curoviyxru.phoenix.ui.im.ServiceImItem;

public class CommentContent
extends ScrollContent
implements PostContent,
ImContent {
    public final ImField msgField;
    boolean forceDown = false;
    int pressedY;
    long typingLong;
    public Post c;
    int deleteFrom = 0;
    public Comment thread;
    boolean showReplies;

    public void paint(Graphics graphics, int n) {
        this.msgField.width = AppCanvas.instance.getWidth();
        this.msgField.x = 0;
        this.msgField.updateHeight();
        this.contentHeight = AppCanvas.instance.contentOriginalHeight - this.msgField.height;
        this.msgField.y = AppCanvas.instance.contentY + this.contentHeight;
        if (graphics == null) {
            return;
        }
        super.paint(graphics, this.contentHeight, n);
        this.msgField.paint(graphics, 0, n);
    }

    public Content removeAll() {
        int n = this.deleteFrom;
        while (n < this.size()) {
            this.removeAt(n);
        }
        System.gc();
        return this;
    }

    public void addPostItem(PaneItem paneItem) {
        this.add(paneItem);
        ++this.deleteFrom;
    }

    public void pointerPressed(int n, int n2) {
        this.pressedY = n2;
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerPressed(n, n2, 0);
        } else {
            super.pointerPressed(n, n2);
        }
    }

    public void pointerReleased(int n, int n2) {
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerReleased(n, n2, 0);
        } else {
            super.pointerReleased(n, n2);
        }
    }

    public void pointerDragged(int n, int n2) {
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerDragged(n, n2, 0);
        } else {
            super.pointerDragged(n, n2);
        }
    }

    public void keyRepeated(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyRepeated(n, this.scrollY);
        } else {
            super.keyRepeated(n);
        }
    }

    public void keyReleased(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyReleased(n, this.scrollY);
        } else {
            super.keyReleased(n);
        }
    }

    public void keyPressed(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyPressed(n, this.scrollY);
        } else {
            super.keyPressed(n);
        }
    }

    public void rightSoft() {
        if (!Midlet.instance.config.oldCommentsSoft) {
            super.rightSoft();
            return;
        }
        if (this.c.canWrite()) {
            this.msgField.setOpened();
        }
    }

    public String getRightSoft() {
        if (!Midlet.instance.config.oldCommentsSoft) {
            return super.getRightSoft();
        }
        return !this.c.canWrite() ? null : (this.msgField.opened ? Localization.get("action.hide") : Localization.get("action.reveal"));
    }

    public CommentContent(Post post, Comment comment) {
        super(Localization.get("title.comments"), true);
        this.showReplies = Midlet.instance.config.showReplies;
        this.c = post;
        this.thread = comment;
        this.msgField = new ImField(this);
        this.rightSoft = new PopupMenu(Localization.get("general.actions"));
        if (post.canWrite()) {
            this.rightSoft.add(new PopupButton(Localization.get("action.fieldVisibility")){

                public void actionPerformed() {
                    CommentContent.this.msgField.setOpened();
                    AppCanvas.instance.closePopup();
                }
            }.setIcon("new/pencil.rle"));
        }
        this.rightSoft.add(new PopupButton(Localization.get("action.refresh")){

            public void actionPerformed() {
                CommentContent.this.refresh();
                AppCanvas.instance.closePopup();
            }
        }.setIcon("new/refresh.rle"));
        this.rightSoft.add(new PopupButton(Localization.get("action.upperComments")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed() {
                Object object = CommentContent.this.lock;
                synchronized (object) {
                    CommentContent.this.next = null;
                    CommentContent.this.thread = null;
                    CommentContent.this.noNext = false;
                    CommentContent.this.removeAll();
                    CommentContent.this.loadNext();
                }
                AppCanvas.instance.closePopup();
            }
        }.setIcon("new/chevron-up.rle"));
        this.rightSoft.add(new PopupButton(Localization.get("action.switchOrder")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed() {
                Object object = CommentContent.this.lock;
                synchronized (object) {
                    CommentContent.this.next = null;
                    CommentContent.this.forceDown = !CommentContent.this.forceDown;
                    CommentContent.this.noNext = false;
                    CommentContent.this.removeAll();
                    CommentContent.this.loadNext();
                }
                AppCanvas.instance.closePopup();
            }
        }.setIcon("new/chevron-down.rle"));
        this.rightSoft.add(new PopupButton(Localization.get("action.switchReplies")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed() {
                Object object = CommentContent.this.lock;
                synchronized (object) {
                    CommentContent.this.next = null;
                    CommentContent.this.showReplies = !CommentContent.this.showReplies;
                    CommentContent.this.noNext = false;
                    CommentContent.this.removeAll();
                    CommentContent.this.loadNext();
                }
                AppCanvas.instance.closePopup();
            }
        }.setIcon("new/message.rle"));
        NewsfeedContent.addPost(this, post);
        this.loadNext();
        this.paint(null, 0);
    }

    public void process() {
        AppCanvas.instance.setProgress(true);
        int n = this.size();
        WallGetComments wallGetComments = new WallGetComments(5, this.next == null ? 0 : 1).setPost(this.c).setSort(this.forceDown ? "desc" : "asc");
        if (this.thread != null) {
            wallGetComments.setCommentId(this.thread.id);
        }
        if (this.next != null) {
            wallGetComments.setStartCommentId((Integer)this.next);
        } else {
            this.next = new Integer(this.forceDown ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        }
        WallGetCommentsResponse wallGetCommentsResponse = (WallGetCommentsResponse)wallGetComments.execute();
        AppCanvas.instance.setProgress(false);
        if (wallGetCommentsResponse != null && wallGetCommentsResponse.hasItems()) {
            if (wallGetCommentsResponse.items.length < 5) {
                this.noNext = true;
            }
            for (int i = 0; i < wallGetCommentsResponse.items.length; ++i) {
                Comment comment = wallGetCommentsResponse.items[i];
                if (comment == null) continue;
                if (!this.forceDown && (Integer)this.next < comment.id || this.forceDown && (Integer)this.next > comment.id) {
                    this.next = new Integer(comment.id);
                }
                this.add(this.getMessageItem(comment));
                if (!this.showReplies || !comment.hasThread() || !comment.thread.hasItems()) continue;
                for (int j = 0; j < comment.thread.items.length; ++j) {
                    Comment comment2 = comment.thread.items[j];
                    if (comment2 == null) continue;
                    comment2.replyMessage = comment;
                    this.add(this.getMessageItem(comment2));
                }
            }
        } else {
            this.noNext = true;
            if (wallGetCommentsResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        this.updateHeightsFromEnd(this.getWidth(), this.size() - n);
    }

    private int indexOf(int n) {
        for (int i = this.size() - 1; i >= 0; --i) {
            PaneItem paneItem = this.at(i);
            if (!(paneItem instanceof ImHolder) || ((ImHolder)((Object)paneItem)).id() != n) continue;
            return i;
        }
        return -1;
    }

    public Content insert(PaneItem paneItem, int n) {
        super.insert(paneItem, n);
        this.updateMessageSender(n);
        this.updateMessageSender(n + 1);
        return this;
    }

    public Content remove(PaneItem paneItem) {
        return this.removeAt(this.indexOf(paneItem));
    }

    public Content removeAt(int n) {
        super.removeAt(n);
        this.updateMessageSender(n + 1);
        return this;
    }

    public Content add(PaneItem paneItem) {
        super.add(paneItem);
        this.updateMessageSender(this.size() - 1);
        return this;
    }

    private void updateMessageSender(int n) {
    }

    private PaneItem getMessageItem(Comment comment) {
        if (comment.isDeleted()) {
            return new ServiceImItem(this, comment);
        }
        return new MainImItem(this, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotDelete(int n) {
        Content content = AppCanvas.instance.content;
        if (content instanceof CommentContent) {
            CommentContent commentContent = (CommentContent)content;
            Object object = commentContent.lock;
            synchronized (object) {
                int n2 = commentContent.indexOf(n);
                if (n2 != -1) {
                    commentContent.removeAt(n2);
                    commentContent.renderIfNeeded();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotEdit(int n) {
        Content content = AppCanvas.instance.content;
        if (content instanceof CommentContent) {
            CommentContent commentContent = (CommentContent)content;
            Object object = commentContent.lock;
            synchronized (object) {
                WallGetCommentResponse wallGetCommentResponse = (WallGetCommentResponse)new WallGetComment(commentContent.c.owner_id, n).execute();
                if (wallGetCommentResponse != null && wallGetCommentResponse.hasComment()) {
                    Comment comment = wallGetCommentResponse.getComment();
                    int n2 = commentContent.indexOf(comment.id);
                    if (n2 != -1) {
                        commentContent.removeAt(n2);
                        commentContent.insert(commentContent.getMessageItem(comment), n2);
                        commentContent.renderIfNeeded();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotNew(int n) {
        Content content = AppCanvas.instance.content;
        if (content instanceof CommentContent) {
            CommentContent commentContent = (CommentContent)content;
            Object object = commentContent.lock;
            synchronized (object) {
                WallGetCommentResponse wallGetCommentResponse = (WallGetCommentResponse)new WallGetComment(commentContent.c.owner_id, n).execute();
                if (wallGetCommentResponse != null && wallGetCommentResponse.hasComment()) {
                    boolean bl = commentContent.totalHeight - content.toScrollY - commentContent.contentHeight <= AppCanvas.instance.normalEmojiFont.height * 2;
                    Comment comment = wallGetCommentResponse.getComment();
                    commentContent.add(commentContent.getMessageItem(comment));
                    commentContent.updateHeightsFromEnd(commentContent.getWidth(), 1);
                    if (bl && comment != null) {
                        commentContent.scrollTo(commentContent.size() - 1);
                    }
                }
            }
        }
    }

    public boolean isChat() {
        return this.c.isChat();
    }

    public boolean canWrite() {
        return this.c.canWrite();
    }

    public boolean isAdmin() {
        return this.c.hasChatSettings() && this.c.comments.can_close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThread(ImItem imItem) {
        Object object = this.lock;
        synchronized (object) {
            this.next = null;
            this.thread = (Comment)imItem;
            this.noNext = false;
            this.removeAll();
            this.loadNext();
        }
    }

    public long ownerId() {
        return this.c.owner_id;
    }

    public long id() {
        return this.c.post_id;
    }

    public ImField field() {
        return this.msgField;
    }

    public boolean isComments() {
        return true;
    }

    public void readTo(ImItem imItem) {
    }

    public int readedTo() {
        return 0;
    }

    public int outReadedTo() {
        return 0;
    }

    public int pinned() {
        return 0;
    }

    public void setPinned(ImItem imItem) {
    }
}

