/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import org.json.me.JSONArray;
import ru.curoviyxru.j2vk.api.objects.Conversation;
import ru.curoviyxru.j2vk.api.objects.Message;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetConversations;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetConversationsById;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetHistory;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetConversationsByIdResponse;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetConversationsResponse;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetHistoryResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.ConversationItem;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.PageContent;
import ru.curoviyxru.phoenix.ui.contents.ScrollContent;

public class ConversationList
extends ScrollContent {
    public static ConversationList instance;
    public Vector forward;
    public Vector unread = new Vector();
    public int forwardType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gotNew(boolean bl, long l) {
        if (instance == null) {
            return;
        }
        Object object = ConversationList.instance.lock;
        synchronized (object) {
            ConversationItem conversationItem = instance.get(l, true);
            if (conversationItem == null) {
                return;
            }
            if (!bl) {
                Long l2;
                if (conversationItem.mode != 4) {
                    if (Midlet.instance.config.feed_notVibro) {
                        Display.getDisplay((MIDlet)Midlet.instance).vibrate(Midlet.instance.config.notVibroTime);
                    }
                    if (Midlet.instance.config.feed_notSound) {
                        AppCanvas.playIncomingSound();
                    }
                }
                if (!ConversationList.instance.unread.contains(l2 = new Long(l))) {
                    ConversationList.instance.unread.addElement(l2);
                }
                ContentController.updateMessagesItem();
            }
            ConversationList.update(conversationItem);
            ConversationList.up(conversationItem);
        }
        instance.renderIfNeeded();
    }

    private static void update(ConversationItem conversationItem) {
        MessagesGetConversationsByIdResponse messagesGetConversationsByIdResponse = (MessagesGetConversationsByIdResponse)new MessagesGetConversationsById(conversationItem.conv.getId()).execute();
        Conversation conversation = messagesGetConversationsByIdResponse != null ? messagesGetConversationsByIdResponse.getConversation() : null;
        MessagesGetHistoryResponse messagesGetHistoryResponse = (MessagesGetHistoryResponse)new MessagesGetHistory(conversationItem.conv.getId(), 1).execute();
        if (messagesGetHistoryResponse != null && messagesGetHistoryResponse.hasItems()) {
            conversationItem.setMessage(conversation != null ? conversation : conversationItem.conv, messagesGetHistoryResponse.items[0]);
        }
        if (conversation != null) {
            conversationItem.setConversation(conversation);
        }
    }

    private static void up(ConversationItem conversationItem) {
        instance.remove(conversationItem);
        instance.insert(conversationItem, 0);
    }

    public static void gotRead(long l) {
        ConversationList.justUpdateConv(l);
    }

    public static void updateOnline(long l) {
        ConversationList.justUpdateConv(l);
    }

    public static void gotDelete(long l) {
        ConversationList.justUpdateConv(l);
    }

    public static void gotEdit(long l) {
        ConversationList.justUpdateConv(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void justUpdateConv(long l) {
        if (instance == null) {
            return;
        }
        Object object = ConversationList.instance.lock;
        synchronized (object) {
            ConversationItem conversationItem = instance.get(l, false);
            if (conversationItem == null) {
                return;
            }
            ConversationList.update(conversationItem);
        }
        instance.renderIfNeeded();
    }

    public ConversationList() {
        super(Localization.get("title.messaging"), false);
        instance = this;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = ConversationList.instance.lock;
        synchronized (object) {
            MessagesGetConversationsResponse messagesGetConversationsResponse;
            this.unread.removeAllElements();
            MessagesGetConversationsResponse messagesGetConversationsResponse2 = (MessagesGetConversationsResponse)new MessagesGetConversations().setCount(0).execute();
            if (messagesGetConversationsResponse2 != null && messagesGetConversationsResponse2.unreadCount != 0 && (messagesGetConversationsResponse = (MessagesGetConversationsResponse)new MessagesGetConversations().setCount(messagesGetConversationsResponse2.unreadCount).setFilter("unread").execute()) != null && messagesGetConversationsResponse.hasItems()) {
                for (int i = 0; i < messagesGetConversationsResponse.items.length; ++i) {
                    Long l;
                    MessagesGetConversationsResponse.ConversationResponseItem conversationResponseItem = messagesGetConversationsResponse.items[i];
                    if (conversationResponseItem == null || !conversationResponseItem.hasConversation() || this.unread.contains(l = new Long(conversationResponseItem.conversation.getId()))) continue;
                    this.unread.addElement(l);
                }
            }
            ContentController.updateMessagesItem();
        }
        super.refresh();
    }

    public void forward(Vector vector, int n) {
        this.forward = vector;
        this.forwardType = n;
        this.updateTitle();
        this.parent(ContentController.menu);
    }

    public void updateTitle() {
        String string = PageContent.count(Math.min(9999, this.unread.size()));
        this.setTitle(this.forward != null && this.forwardType != 0 ? Localization.get("title.forwardTo") : (this.unread.size() > 0 ? Localization.get("title.messagingWithCount", string) : Localization.get("title.messaging")));
    }

    public ConversationItem get(long l, boolean bl) {
        for (int i = 0; i < this.size(); ++i) {
            PaneItem paneItem = this.at(i);
            if (!(paneItem instanceof ConversationItem)) continue;
            ConversationItem conversationItem = (ConversationItem)paneItem;
            if (conversationItem.conv.getId() != l) continue;
            return conversationItem;
        }
        return bl ? this.create(l) : null;
    }

    public void process() {
        boolean bl;
        AppCanvas appCanvas = AppCanvas.instance;
        appCanvas.setProgress(true);
        boolean bl2 = bl = this.next == null;
        if (bl) {
            this.next = new Integer(-5);
        }
        this.next = new Integer((Integer)this.next + 5);
        MessagesGetConversations messagesGetConversations = new MessagesGetConversations().setCount(5).setOffset((Integer)this.next);
        if (!bl) {
            messagesGetConversations.setStartMessageId((Integer)this.addon);
        } else {
            this.addon = new Integer(Integer.MIN_VALUE);
        }
        MessagesGetConversationsResponse messagesGetConversationsResponse = (MessagesGetConversationsResponse)messagesGetConversations.execute();
        if (messagesGetConversationsResponse == null || messagesGetConversationsResponse.unreadCount > 0) {
            // empty if block
        }
        if (messagesGetConversationsResponse != null && messagesGetConversationsResponse.hasItems()) {
            if (messagesGetConversationsResponse.items.length < 5) {
                this.noNext = true;
            }
            for (int i = 0; i < messagesGetConversationsResponse.items.length; ++i) {
                MessagesGetConversationsResponse.ConversationResponseItem conversationResponseItem = messagesGetConversationsResponse.items[i];
                Conversation conversation = conversationResponseItem.conversation;
                Message message = conversationResponseItem.lastMessage;
                if (conversation == null || message == null) continue;
                if (bl && (Integer)this.addon < message.id) {
                    this.addon = new Integer(message.id);
                }
                this.add(new ConversationItem(this, conversation, message));
            }
        } else {
            this.noNext = true;
            if (messagesGetConversationsResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        this.updateHeightsFromEnd(this.getWidth(), 5);
        appCanvas.setProgress(false);
    }

    private ConversationItem create(long l) {
        MessagesGetConversationsByIdResponse messagesGetConversationsByIdResponse = (MessagesGetConversationsByIdResponse)new MessagesGetConversationsById(l).execute();
        if (messagesGetConversationsByIdResponse != null && !messagesGetConversationsByIdResponse.hasConversation()) {
            return null;
        }
        MessagesGetHistoryResponse messagesGetHistoryResponse = (MessagesGetHistoryResponse)new MessagesGetHistory(l, 1).execute();
        ConversationItem conversationItem = new ConversationItem(this, messagesGetConversationsByIdResponse.getConversation(), messagesGetHistoryResponse != null && messagesGetHistoryResponse.hasItems() ? messagesGetHistoryResponse.items[0] : null);
        this.insert(conversationItem, 0);
        return conversationItem;
    }

    public void updateTypingUser(long l, long l2) {
        if (!Midlet.instance.config.typingInDialogs) {
            return;
        }
        ConversationItem conversationItem = this.get(l, false);
        if (conversationItem == null) {
            return;
        }
        conversationItem.setTyping(5);
        this.renderIfNeeded();
    }

    public void updateTypingUsers(JSONArray jSONArray, long l, int n) {
        if (!Midlet.instance.config.typingInDialogs) {
            return;
        }
        ConversationItem conversationItem = this.get(l, false);
        if (conversationItem == null) {
            return;
        }
        conversationItem.setTyping(5);
        this.renderIfNeeded();
    }

    public void updateTyping() {
        if (!Midlet.instance.config.typingInDialogs) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            ConversationItem conversationItem = (ConversationItem)this.at(i);
            if (conversationItem == null) continue;
            conversationItem.updateTyping();
        }
        this.renderIfNeeded();
    }
}

