/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ru.curoviyxru.j2vk.ProgressProvider;
import ru.curoviyxru.j2vk.api.objects.attachments.ImageAttachment;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.phoenix.DownloadUtils;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.kernel.FocusedProgressProvider;
import ru.curoviyxru.phoenix.kernel.ProgressKernel;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.AttachmentView;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.FilePicker;
import ru.curoviyxru.phoenix.ui.ImageItem;
import ru.curoviyxru.phoenix.ui.ImageProvider;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.PopupMenu;

public class ImageViewer
extends Content
implements ImageProvider,
ProgressProvider {
    public static ImageViewer instance = new ImageViewer();
    AttachmentView aView;
    Image image;
    Photo photo;
    int tries;
    private String size;
    private String origSize;
    private int x;
    private int y;
    private int sH;
    private int sW;
    private ImageItem ii;
    private float kineticScrollX = 0.0f;
    private float kineticScrollY = 0.0f;
    private float kineticStoreX = 0.0f;
    private float kineticStoreY = 0.0f;
    private PopupButton resSwitchButton = null;

    public ImageViewer() {
        super(Localization.get("title.imageViewer"));
        this.rightSoft = new PopupMenu(Localization.get("general.actions")){

            public void actionPerformed(int n, int n2, int n3) {
                if (!this.open) {
                    if (this.contains(ImageViewer.this.resSwitchButton)) {
                        this.remove(ImageViewer.this.resSwitchButton);
                    }
                    if (ImageViewer.this.canSwitchResolution()) {
                        this.insert(ImageViewer.this.resSwitchButton, 0);
                    }
                    this.updateHeights(this.getWidth(), this.size());
                }
                super.actionPerformed(n, n2, n3);
            }
        };
        this.resSwitchButton = (PopupButton)new PopupButton(Localization.get("action.switchResolution")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                ImageViewer.this.switchResolution();
            }
        }.setIcon("new/refresh.rle");
        this.rightSoft.add(new PopupButton(Localization.get("action.downloadImage")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                if (ImageViewer.this.photo != null) {
                    ImageViewer.this.downloadImageAttachment(ImageViewer.this.photo, ImageViewer.this.photo.getURL(Integer.MAX_VALUE));
                }
            }
        }.setIcon("new/cloud-download.rle"));
    }

    public ImageViewer setPhoto(Photo photo, AttachmentView attachmentView, ImageItem imageItem) {
        this.photo = photo;
        this.ii = imageItem;
        this.aView = attachmentView;
        this.image = null;
        this.tries = 0;
        this.size = null;
        Photo.Size size = photo != null ? photo.getSize(Integer.MAX_VALUE, true) : null;
        this.origSize = size != null ? size.type : null;
        this.y = 0;
        this.x = 0;
        this.sW = 0;
        this.sH = 0;
        this.lastHeight = 0;
        this.lastWidth = 0;
        this.kineticScrollX = 0.0f;
        this.kineticScrollY = 0.0f;
        return this;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.lastWidth = n3;
        this.lastHeight = n4;
        if (bl) {
            graphics.setColor(Theming.now.backgroundColor);
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this.photo != null && this.image == null) {
            Photo.Size size;
            if (this.size == null && (size = this.photo.getSize(n3, true)) != null) {
                this.size = size.type;
                this.sH = size.height;
                this.sW = size.width;
                this.centralizeImage();
                this.kineticScrollY = 0.0f;
                this.kineticScrollX = 0.0f;
            }
            AppCanvas.instance.queue(this, 0);
        }
        boolean bl2 = false;
        if (this.kineticScrollX != 0.0f) {
            this.kineticScrollX *= AppCanvas.instance.pressed ? 0.5f : 0.96f;
            if (this.kineticScrollX > 1.0f || this.kineticScrollX < -1.0f) {
                this.x = (int)((float)this.x + this.kineticScrollX);
                this.boundOffsetX();
            } else {
                this.kineticScrollX = 0.0f;
            }
            bl2 = true;
        }
        if (this.kineticScrollY != 0.0f) {
            this.kineticScrollY *= AppCanvas.instance.pressed ? 0.5f : 0.96f;
            if (this.kineticScrollY > 1.0f || this.kineticScrollY < -1.0f) {
                this.y = (int)((float)this.y + this.kineticScrollY);
                this.boundOffsetY();
            } else {
                this.kineticScrollY = 0.0f;
            }
            bl2 = true;
        }
        if (this.image != null) {
            graphics.drawImage(this.image, n + this.x, n2 + this.y, 20);
        } else if (this.sW > 0 && this.sH > 0) {
            graphics.setColor(Theming.now.nonLoadedContentColor);
            graphics.fillRect(n + this.x, n2 + this.y, this.sW, this.sH);
        }
        if (bl2) {
            AppCanvas.instance.render();
        }
    }

    private void boundOffsetX() {
        this.x = this.sW > this.lastWidth ? Math.max(Math.min(this.x, 0), this.lastWidth - this.sW) : (this.lastWidth - this.sW) / 2;
    }

    private void boundOffsetY() {
        this.y = this.sH > this.lastHeight ? Math.max(Math.min(this.y, 0), this.lastHeight - this.sH) : (this.lastHeight - this.sH) / 2;
    }

    private void centralizeImage() {
        this.x = (this.lastWidth - this.sW) / 2;
        this.y = (this.lastHeight - this.sH) / 2;
    }

    public void pointerPressed(int n, int n2) {
        this.kineticStoreY = 0.0f;
        this.kineticStoreX = 0.0f;
    }

    public void pointerReleased(int n, int n2) {
        this.kineticScrollX += this.kineticStoreX;
        this.kineticScrollY += this.kineticStoreY;
        this.kineticStoreY = 0.0f;
        this.kineticStoreX = 0.0f;
    }

    public void pointerDragged(int n, int n2) {
        this.kineticStoreX = AppCanvas.instance.pX - AppCanvas.instance.lX;
        this.kineticStoreY = AppCanvas.instance.pY - AppCanvas.instance.lY;
        this.x = (int)((float)this.x + this.kineticStoreX);
        this.y = (int)((float)this.y + this.kineticStoreY);
        this.boundOffsetX();
        this.boundOffsetY();
    }

    public void keyRepeated(int n) {
        switch (n) {
            case 2: {
                this.x += AppCanvas.instance.lW / 10;
                this.boundOffsetX();
                break;
            }
            case 5: {
                this.x -= AppCanvas.instance.lW / 10;
                this.boundOffsetX();
                break;
            }
            case 1: {
                this.y += AppCanvas.instance.lH / 10;
                this.boundOffsetY();
                break;
            }
            case 6: {
                this.y -= AppCanvas.instance.lH / 10;
                this.boundOffsetY();
            }
        }
    }

    public void keyReleased(int n) {
    }

    public void keyPressed(int n) {
        switch (n) {
            case 2: {
                this.x += AppCanvas.instance.lW / 10;
                this.boundOffsetX();
                break;
            }
            case 5: {
                this.x -= AppCanvas.instance.lW / 10;
                this.boundOffsetX();
                break;
            }
            case 1: {
                this.y += AppCanvas.instance.lH / 10;
                this.boundOffsetY();
                break;
            }
            case 6: {
                this.y -= AppCanvas.instance.lH / 10;
                this.boundOffsetY();
                break;
            }
            case 8: 
            case 1000011: {
                if (!this.canSwitchResolution()) break;
                this.switchResolution();
            }
        }
    }

    private boolean canSwitchResolution() {
        Photo.Size size;
        if (this.origSize != null && !this.origSize.equals(this.size)) {
            return true;
        }
        return this.photo != null && (size = this.photo.getSize(this.lastWidth, true)) != null && this.origSize != null && this.origSize.equals(this.size) && !this.origSize.equals(size.type);
    }

    private void switchResolution() {
        Photo.Size size;
        if (this.photo != null && (size = this.photo.getSize(this.size == null || this.size.equals(this.origSize) ? this.lastWidth : Integer.MAX_VALUE, true)) != null) {
            if (size.type.equals(this.size)) {
                return;
            }
            this.size = size.type;
            this.image = null;
            this.tries = 0;
            if (this.sW != 0 && this.sH != 0) {
                this.x = (this.x - this.lastWidth / 2) * size.width / this.sW + this.lastWidth / 2;
                this.y = (this.y - this.lastHeight / 2) * size.height / this.sH + this.lastHeight / 2;
            } else {
                this.centralizeImage();
            }
            this.kineticScrollY = 0.0f;
            this.kineticScrollX = 0.0f;
            this.sW = size.width;
            this.sH = size.height;
            this.boundOffsetX();
            this.boundOffsetY();
        }
    }

    public boolean local(int n) {
        return false;
    }

    public String get(int n) {
        return this.photo != null && this.size != null ? this.photo.getURL(this.size) : null;
    }

    public void set(int n, Image image) {
        if (image == null) {
            return;
        }
        this.image = image;
        this.sW = image.getWidth();
        this.sH = image.getHeight();
    }

    public int tries() {
        return this.tries;
    }

    public void tried() {
        if (this.tries > 5) {
            return;
        }
        ++this.tries;
    }

    public int size() {
        return 1;
    }

    public void errored(Throwable throwable) {
        AppCanvas.instance.dropError("Image viewer: " + throwable != null ? throwable.getMessage() : "Unknown error");
    }

    public void downloadImageAttachment(final ImageAttachment imageAttachment, final String string) {
        if (imageAttachment == null || string == null) {
            return;
        }
        switch (Midlet.instance.config.downloadMode) {
            case 0: {
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(new PopupButton(Localization.get("settings.downloadFile")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        ImageViewer.this.downloadImageAttachment(false, imageAttachment, string);
                    }
                }.setIcon("new/cloud-download.rle"));
                popupMenu.add(new PopupButton(Localization.get("settings.openBrowser")){

                    public void actionPerformed() {
                        AppCanvas.instance.closePopup();
                        ImageViewer.this.downloadImageAttachment(true, imageAttachment, string);
                    }
                }.setIcon("new/web.rle"));
                AppCanvas.instance.showPopup(popupMenu);
                break;
            }
            case 1: 
            case 2: {
                this.downloadImageAttachment(Midlet.instance.config.downloadMode == 2, imageAttachment, string);
            }
        }
    }

    public void downloadImageAttachment(boolean bl, ImageAttachment imageAttachment, final String string) {
        final Photo photo = this.photo;
        if (bl) {
            Midlet.goLink(string);
            return;
        }
        AppCanvas.instance.goTo(new FilePicker(true, this){

            public void filePicked(String string4) {
                final FocusedProgressProvider focusedProgressProvider = new FocusedProgressProvider(ImageViewer.this);
                ProgressKernel.addProvider(focusedProgressProvider);
                try {
                    String string2 = photo.toString() + (photo instanceof Photo ? ".jpeg" : ".png");
                    final FileConnection fileConnection = (FileConnection)Connector.open((String)(string4 + string2), (int)3);
                    if (fileConnection.exists()) {
                        PopupMenu popupMenu = new PopupMenu();
                        String string3 = Localization.get("fm.replaceConfirm", string2);
                        popupMenu.add(new Label(string3).setFont(true).skipSelection(true));
                        popupMenu.add(new PopupButton(Localization.get("action.ok")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                                try {
                                    this.goBack();
                                    new Thread(){

                                        public void run() {
                                            try {
                                                DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                                fileConnection.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }.start();
                                }
                                catch (Exception exception) {
                                    AppCanvas.instance.dropError(exception);
                                }
                            }
                        });
                        popupMenu.add(new PopupButton(Localization.get("action.cancel")){

                            public void actionPerformed() {
                                AppCanvas.instance.closePopup();
                            }
                        });
                        AppCanvas.instance.showPopup(popupMenu);
                    } else {
                        this.goBack();
                        new Thread(){

                            public void run() {
                                try {
                                    DownloadUtils.downloadFile(string, fileConnection, focusedProgressProvider, 0);
                                    fileConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Exception exception) {
                    AppCanvas.instance.dropError(exception);
                }
            }
        });
    }

    public void setProgress(long l) {
        if (this.aView != null) {
            this.aView.setProgress(l);
        }
    }

    public void failed(String string) {
        if (this.aView != null) {
            this.aView.failed(string);
        } else {
            AppCanvas.instance.dropError("Image viewer:" + string);
        }
    }

    public void successful() {
        if (this.aView != null) {
            this.aView.successful();
        }
    }

    public String getName() {
        return this.photo == null ? null : this.photo.toString();
    }
}

