/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import javax.microedition.lcdui.Graphics;
import org.json.me.JSONArray;
import ru.curoviyxru.j2vk.LongPoll;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.Conversation;
import ru.curoviyxru.j2vk.api.objects.ImItem;
import ru.curoviyxru.j2vk.api.objects.Message;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetById;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetHistory;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesMarkAsRead;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesSetActivity;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetByIdResponse;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetHistoryResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.ConversationItem;
import ru.curoviyxru.phoenix.ui.KeyboardUtil;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.PopupMenu;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.ConversationList;
import ru.curoviyxru.phoenix.ui.contents.TwoScrollContent;
import ru.curoviyxru.phoenix.ui.im.ImContent;
import ru.curoviyxru.phoenix.ui.im.ImField;
import ru.curoviyxru.phoenix.ui.im.ImHolder;
import ru.curoviyxru.phoenix.ui.im.MainImItem;
import ru.curoviyxru.phoenix.ui.im.ServiceImItem;

public class MessageContent
extends TwoScrollContent
implements ImContent {
    public static MessageContent MESSAGE_CONTENT = null;
    int typing;
    String oldCornerIcon;
    boolean forceDown = false;
    public int readTo;
    public int readedTo;
    public int outReadedTo;
    int min_id = -1;
    int max_id = -1;
    public final ImField msgField;
    int pressedY;
    long typingLong;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateOnline(long l) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            PageStorage.load(l);
            Object object = messageContent.lock;
            synchronized (object) {
                messageContent.setCornerIcon(ListItem.getCornerPath(ContentController.getStatusIcon(PageStorage.get(l))));
                messageContent.renderIfNeeded();
            }
        }
    }

    public static Content getMessageContent() {
        if (MESSAGE_CONTENT != null) {
            return MESSAGE_CONTENT;
        }
        Content content = AppCanvas.instance.content;
        if (content instanceof MessageContent) {
            MESSAGE_CONTENT = (MessageContent)content;
            return content;
        }
        while (content != null) {
            content = content.parent;
            if (!(content instanceof MessageContent)) continue;
            MESSAGE_CONTENT = (MessageContent)content;
            return content;
        }
        return null;
    }

    public void updateTyping() {
        if (this.msgField != null) {
            this.msgField.updateTyping();
        }
    }

    public void itemRendered(PaneItem paneItem, Graphics graphics, int n, int n2) {
        if (paneItem instanceof ImHolder && !((ImHolder)((Object)paneItem)).out() && ((ImHolder)((Object)paneItem)).id() > this.readTo) {
            this.readTo = ((ImHolder)((Object)paneItem)).id();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gotRead(int n, long l, int n2) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                if (n == 7) {
                    messageContent.outReadedTo = Math.max(n2, messageContent.outReadedTo);
                } else {
                    messageContent.readedTo = Math.max(n2, messageContent.readedTo);
                }
                messageContent.renderIfNeeded();
            }
        }
    }

    public void loadNextForce() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = MessageContent.this.lock;
                    synchronized (object) {
                        int n = MessageContent.this.size();
                        boolean bl = MessageContent.this.totalHeight - MessageContent.this.toScrollY - MessageContent.this.contentHeight <= AppCanvas.instance.normalEmojiFont.height * 2;
                        MessageContent.this.setTyping(0);
                        MessageContent.this.updateLabel();
                        MessageContent.this.processNext();
                        if (bl && n != MessageContent.this.size()) {
                            MessageContent.this.scrollTo(MessageContent.this.size() - 1);
                        }
                        MessageContent.this.loading = false;
                    }
                }
                catch (Exception exception) {
                    MessageContent.this.loading = false;
                    AppCanvas.instance.dropError(exception);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    MessageContent.this.loading = false;
                    MessageContent.this.imOut();
                }
                AppCanvas.instance.setProgress(false);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gotNew(int n, long l) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                if (!messageContent.noNext || messageContent.max_id >= n) {
                    return;
                }
                messageContent.loadNextForce();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gotEdit(int n, long l) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                MessagesGetByIdResponse messagesGetByIdResponse = (MessagesGetByIdResponse)new MessagesGetById().addMessageId(n).execute();
                if (messagesGetByIdResponse != null && messagesGetByIdResponse.hasMessage()) {
                    Message message = messagesGetByIdResponse.getMessage();
                    int n2 = messageContent.indexOf(message.id);
                    if (n2 != -1) {
                        messageContent.removeAt(n2);
                        messageContent.insert(messageContent.getMessageItem(message), n2);
                        messageContent.renderIfNeeded();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gotDelete(int n, long l) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                int n2 = messageContent.indexOf(n);
                if (n2 != -1) {
                    messageContent.removeAt(n2);
                    messageContent.renderIfNeeded();
                }
            }
        }
    }

    public void paint(Graphics graphics, int n) {
        this.msgField.width = AppCanvas.instance.getWidth();
        this.msgField.x = 0;
        this.msgField.updateHeight();
        this.contentHeight = AppCanvas.instance.contentOriginalHeight - this.msgField.height;
        this.msgField.y = AppCanvas.instance.contentY + this.contentHeight;
        if (graphics == null) {
            return;
        }
        super.paint(graphics, this.contentHeight, n);
        this.msgField.paint(graphics, 0, n);
    }

    public void pointerPressed(int n, int n2) {
        this.pressedY = n2;
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerPressed(n, n2, 0);
        } else {
            super.pointerPressed(n, n2);
        }
    }

    public void pointerReleased(int n, int n2) {
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerReleased(n, n2, 0);
        } else {
            super.pointerReleased(n, n2);
        }
    }

    public void pointerDragged(int n, int n2) {
        if (this.pressedY >= AppCanvas.instance.contentY + this.contentHeight) {
            this.msgField.pointerDragged(n, n2, 0);
        } else {
            super.pointerDragged(n, n2);
        }
    }

    public void keyRepeated(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyRepeated(n, this.scrollY);
        } else {
            super.keyRepeated(n);
        }
    }

    public void keyReleased(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyReleased(n, this.scrollY);
        } else {
            super.keyReleased(n);
        }
    }

    public void keyPressed(int n) {
        if ((KeyboardUtil.isAccepted(n) || n == 1000011 || n == 8 || n == 2 || n == 5) && !AppCanvas.instance.popupOpened() && this.c.canWrite() && (this.msgField.opened || !Midlet.instance.config.usePQSofts && n != 8 && n != 50 && n != 56)) {
            if (!this.msgField.opened) {
                this.msgField.setOpened(true);
            }
            this.msgField.keyPressed(n, this.scrollY);
        } else {
            super.keyPressed(n);
        }
    }

    public void rightSoft() {
        if (!Midlet.instance.config.oldMessagesSoft) {
            super.rightSoft();
            return;
        }
        if (this.c.canWrite()) {
            this.msgField.setOpened();
        }
    }

    public String getRightSoft() {
        if (!Midlet.instance.config.oldMessagesSoft) {
            return super.getRightSoft();
        }
        return !this.c.canWrite() ? null : (this.msgField.opened ? Localization.get("action.hide") : Localization.get("action.reveal"));
    }

    public MessageContent(final Conversation conversation) {
        super(conversation);
        this.readTo = this.readedTo = conversation.inRead;
        this.outReadedTo = conversation.outRead;
        this.msgField = new ImField(this);
        this.rightSoft = new PopupMenu(Localization.get("general.actions"));
        if (conversation.canWrite()) {
            this.rightSoft.add(new PopupButton(Localization.get("action.fieldVisibility")){

                public void actionPerformed() {
                    MessageContent.this.msgField.setOpened();
                    AppCanvas.instance.closePopup();
                }
            }.setIcon("new/pencil.rle"));
        }
        this.rightSoft.add(new PopupButton(Localization.get("action.scrollToBottom")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed() {
                Object object = MessageContent.this.lock;
                synchronized (object) {
                    MessageContent.this.max_id = -1;
                    MessageContent.this.min_id = -1;
                    MessageContent.this.forceDown = true;
                    MessageContent.this.loadedFirst = false;
                    MessageContent.this.noPrev = false;
                    MessageContent.this.noNext = false;
                    MessageContent.this.removeAll();
                    MessageContent.this.loadFirst();
                }
                AppCanvas.instance.closePopup();
            }
        }.setIcon("new/chevron-down.rle"));
        if (conversation.isPage()) {
            PageStorage.load(conversation.getId());
            this.setCornerIcon(ListItem.getCornerPath(ContentController.getStatusIcon(PageStorage.get(conversation.getId()))));
            this.rightSoft.add(new PopupButton(Localization.get("action.goToProfile")){

                public void actionPerformed() {
                    ContentController.showProfile(MessageContent.this, PageStorage.get(conversation.getId()));
                    AppCanvas.instance.closePopup();
                }
            }.setIcon("new/account.rle"));
        }
        this.updateLabel();
        this.loadFirst();
        this.paint(null, 0);
    }

    public void processFirst() {
        if (this.forceDown || Midlet.instance.config.showMessagesFromEnd) {
            this.processNext(true);
        } else {
            this.processPrev();
        }
        this.scrollTo(this.size() - 1);
        this.processNext();
    }

    public void processPrev() {
        AppCanvas.instance.setProgress(true);
        int n = this.size();
        MessagesGetHistory messagesGetHistory = new MessagesGetHistory(this.c.getId(), 5, this.min_id == -1 ? 0 : 1).setStartMessageId(this.min_id);
        MessagesGetHistoryResponse messagesGetHistoryResponse = (MessagesGetHistoryResponse)messagesGetHistory.execute();
        AppCanvas.instance.setProgress(false);
        if (messagesGetHistoryResponse != null && messagesGetHistoryResponse.hasItems()) {
            if (messagesGetHistoryResponse.items.length < 5) {
                this.noPrev = true;
            }
            int n2 = 0;
            for (int i = messagesGetHistoryResponse.items.length - 1; i >= 0; --i) {
                Message message = messagesGetHistoryResponse.items[i];
                if (message == null) continue;
                if (this.min_id == -1 || this.min_id > message.id) {
                    this.min_id = message.id;
                }
                if (this.max_id == -1 || this.max_id < message.id) {
                    this.max_id = message.id;
                }
                this.insert(this.getMessageItem(message), n2++);
            }
        } else {
            this.noPrev = true;
            if (messagesGetHistoryResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        this.selectedY += this.size() - n;
        this.updateHeightsAdd(this.getWidth(), this.size() - n);
    }

    public void processNext() {
        this.processNext(false);
    }

    public void processNext(boolean bl) {
        AppCanvas.instance.setProgress(true);
        int n = this.size();
        MessagesGetHistory messagesGetHistory = new MessagesGetHistory(this.c.getId(), 5, bl ? 0 : -5);
        if (!bl) {
            messagesGetHistory.setStartMessageId(this.max_id);
        }
        MessagesGetHistoryResponse messagesGetHistoryResponse = (MessagesGetHistoryResponse)messagesGetHistory.execute();
        AppCanvas.instance.setProgress(false);
        if (messagesGetHistoryResponse != null && messagesGetHistoryResponse.hasItems()) {
            if (messagesGetHistoryResponse.items.length < 5) {
                this.noNext = true;
            }
            for (int i = messagesGetHistoryResponse.items.length - 1; i >= 0; --i) {
                Message message = messagesGetHistoryResponse.items[i];
                if (message == null) continue;
                if (this.min_id == -1 || this.min_id > message.id) {
                    this.min_id = message.id;
                }
                if (this.max_id == -1 || this.max_id < message.id) {
                    this.max_id = message.id;
                }
                this.add(this.getMessageItem(message));
            }
        } else {
            this.noNext = true;
            if (messagesGetHistoryResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        this.updateHeightsFromEnd(this.getWidth(), this.size() - n);
    }

    private int indexOf(int n) {
        for (int i = this.size() - 1; i >= 0; --i) {
            PaneItem paneItem = this.at(i);
            if (!(paneItem instanceof ImHolder) || ((ImHolder)((Object)paneItem)).id() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTypingUsers(JSONArray jSONArray, long l, int n) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                messageContent.setTyping(5);
                messageContent.updateLabel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTypingUser(long l, long l2) {
        Content content = MessageContent.getMessageContent();
        if (content instanceof MessageContent) {
            MessageContent messageContent = (MessageContent)content;
            if (messageContent.c.getId() != l) {
                return;
            }
            Object object = messageContent.lock;
            synchronized (object) {
                messageContent.setTyping(5);
                messageContent.updateLabel();
            }
        }
    }

    public void updateLabel() {
        if (this.readTo > this.readedTo && !Midlet.instance.config.DNR) {
            this.readedTo = Math.max(this.readTo, this.readedTo);
            new MessagesMarkAsRead(this.c.getId(), this.readTo).execute();
        }
        String string = "";
        ConversationItem conversationItem = ConversationList.instance.get(this.c.getId(), false);
        if (conversationItem != null && conversationItem.rightState > 0) {
            string = "(+" + conversationItem.rightState + ") ";
        }
        this.setTitle(string + (this.c.getId() == VKConstants.account.getId() ? Localization.get("element.favorites") : this.c.getTitle()));
        if (AppCanvas.lastField instanceof ImField && !Midlet.instance.config.DNT && System.currentTimeMillis() - this.typingLong > 4000L) {
            this.typingLong = System.currentTimeMillis();
            new MessagesSetActivity(this.c.getId(), "typing").execute();
        }
        this.renderIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTyping(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.typing = Math.max(n, 0);
            if (this.oldCornerIcon == null) {
                this.oldCornerIcon = this.cornerIcon;
            }
            if (this.typing == 0) {
                if (this.cornerIcon != null && this.cornerIcon.equals(ListItem.getCornerPath(7))) {
                    this.setCornerIcon(this.oldCornerIcon);
                }
                this.oldCornerIcon = null;
            } else {
                this.setCornerIcon(ListItem.getCornerPath(7));
            }
        }
    }

    public void updateTypingState() {
        if (this.typing > 0) {
            this.setTyping(this.typing - 1);
        }
    }

    public Content insert(PaneItem paneItem, int n) {
        super.insert(paneItem, n);
        this.updateMessageSender(n);
        this.updateMessageSender(n + 1);
        return this;
    }

    public Content remove(PaneItem paneItem) {
        return this.removeAt(this.indexOf(paneItem));
    }

    public Content removeAt(int n) {
        super.removeAt(n);
        this.updateMessageSender(n + 1);
        return this;
    }

    public Content add(PaneItem paneItem) {
        super.add(paneItem);
        this.updateMessageSender(this.size() - 1);
        return this;
    }

    private void updateMessageSender(int n) {
        PaneItem paneItem;
        PaneItem paneItem2 = n >= 0 && n < this.size() ? this.at(n) : null;
        PaneItem paneItem3 = paneItem = n - 1 >= 0 && n - 1 < this.size() ? this.at(n - 1) : null;
        if (paneItem2 instanceof MainImItem) {
            ((MainImItem)paneItem2).updateShowName(paneItem instanceof MainImItem ? (MainImItem)paneItem : null);
        }
    }

    private PaneItem getMessageItem(Message message) {
        if (message.hasChatAction()) {
            return new ServiceImItem(this, message);
        }
        return new MainImItem(this, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTo(ImItem imItem) {
        Object object = this.lock;
        synchronized (object) {
            if (imItem.id() > this.readedTo) {
                this.readedTo = imItem.id();
                new MessagesMarkAsRead(this.c.getId(), imItem.id()).execute();
                LongPoll.skipWait = true;
            }
        }
    }

    public boolean isChat() {
        return this.c.isChat();
    }

    public boolean canWrite() {
        return this.c.canWrite();
    }

    public ImField field() {
        return this.msgField;
    }

    public void gotDelete(int n) {
    }

    public boolean isAdmin() {
        return this.c.hasChatSettings() && ((Conversation)this.c).chatSettings.isAdmin(VKConstants.account.getId());
    }

    public void setThread(ImItem imItem) {
    }

    public void gotEdit(int n) {
    }

    public long ownerId() {
        return 0L;
    }

    public long id() {
        return this.c.getId();
    }

    public void gotNew(int n) {
    }

    public boolean isComments() {
        return false;
    }

    public int readedTo() {
        return this.readedTo;
    }

    public int outReadedTo() {
        return this.outReadedTo;
    }

    public int pinned() {
        return this.c.hasChatSettings() && ((Conversation)this.c).chatSettings.hasPinnedMessage() ? ((Conversation)this.c).chatSettings.pinnedMessage.id : 0;
    }

    public void setPinned(ImItem imItem) {
        if (this.c.hasChatSettings()) {
            ((Conversation)this.c).chatSettings.pinnedMessage = (Message)imItem;
        }
    }
}

