/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.api.objects.Attachment;
import ru.curoviyxru.j2vk.api.objects.attachments.ImageAttachment;
import ru.curoviyxru.j2vk.api.objects.attachments.Photo;
import ru.curoviyxru.j2vk.api.objects.attachments.Post;
import ru.curoviyxru.j2vk.api.requests.newsfeed.NewsfeedGet;
import ru.curoviyxru.j2vk.api.responses.newsfeed.NewsfeedGetResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.AttachmentView;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.Footer;
import ru.curoviyxru.phoenix.ui.ImageItem;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PostFooter;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.PageContent;
import ru.curoviyxru.phoenix.ui.contents.PostContent;
import ru.curoviyxru.phoenix.ui.contents.ScrollContent;

public class NewsfeedContent
extends ScrollContent
implements PostContent {
    public NewsfeedContent() {
        super(Localization.get("title.newsfeed"), true);
    }

    public void process() {
        AppCanvas.instance.setProgress(true);
        NewsfeedGetResponse newsfeedGetResponse = (NewsfeedGetResponse)new NewsfeedGet().setCount(5).setStartFrom(this.next == null ? null : this.next.toString()).execute();
        if (newsfeedGetResponse != null && newsfeedGetResponse.hasItems()) {
            if (newsfeedGetResponse.items.length < 5 || newsfeedGetResponse.next_from == null || this.next != null && this.next.equals(newsfeedGetResponse.next_from)) {
                this.noNext = true;
                AppCanvas.instance.setProgress(false);
                if (newsfeedGetResponse.next_from != null && this.next != null && this.next.equals(newsfeedGetResponse.next_from)) {
                    return;
                }
            }
            this.next = newsfeedGetResponse.next_from;
            for (int i = 0; i < newsfeedGetResponse.items.length; ++i) {
                NewsfeedContent.addPost(this, newsfeedGetResponse.items[i]);
            }
        } else {
            this.noNext = true;
            if (newsfeedGetResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        AppCanvas.instance.setProgress(false);
    }

    public static void addPost(PostContent postContent, Post post) {
        if (post == null) {
            return;
        }
        postContent.addPostItem(ContentController.getUserButton(PageStorage.get(post.owner_id), false, true, true, true, (Content)((Object)postContent)).setDescription(PageContent.getTimeActionString(post.date)));
        if (post.from_id != post.owner_id && post.from_id != 0L) {
            postContent.addPostItem(ContentController.getUserButton(PageStorage.get(post.from_id), true, true, false, true, (Content)((Object)postContent)).setDescription(PageContent.getTimeActionString(post.date)));
        }
        if (post.isAd()) {
            postContent.addPostItem(new Label(Localization.get("element.advertisement")).setFont(true));
        }
        if (post.hasText()) {
            postContent.addPostItem(new Label(post.text));
        }
        if (post.hasAttachments()) {
            for (int i = 0; i < post.attachments.length; ++i) {
                Attachment attachment = post.attachments[i];
                if (attachment == null) continue;
                if (attachment instanceof ImageAttachment) {
                    int n = Math.min(AppCanvas.instance.lW, AppCanvas.instance.lH) - AppCanvas.instance.perLineSpace * 4;
                    int n2 = ((ImageAttachment)((Object)attachment)).getWidth(n);
                    postContent.addPostItem(new ImageItem(attachment instanceof Photo ? (Photo)attachment : null, ((ImageAttachment)((Object)attachment)).getURL(n), false, Math.min(n, n2), Math.min(n, n2) * ((ImageAttachment)((Object)attachment)).getHeight(n) / n2).setAlign(1));
                    continue;
                }
                postContent.addPostItem(new AttachmentView(attachment));
            }
        }
        Post post2 = post;
        if (post.hasCopyHistory() && (post = post.copy_history[0]) != null) {
            postContent.addPostItem(new AttachmentView(post));
        }
        if ((post = post2).hasSigner() && post.signer_id != post.owner_id && post.signer_id != post.from_id) {
            postContent.addPostItem(ContentController.getUserButton(PageStorage.get(post.signer_id), true, true, false, true, (Content)((Object)postContent)));
        }
        postContent.addPostItem(new PostFooter((Content)((Object)postContent), post));
        postContent.addPostItem(new Footer());
    }

    public void addPostItem(PaneItem paneItem) {
        this.add(paneItem);
    }
}

