/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.TextUtil;
import ru.curoviyxru.j2vk.VKConstants;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.j2vk.api.objects.user.Group;
import ru.curoviyxru.j2vk.api.objects.user.Page;
import ru.curoviyxru.j2vk.api.objects.user.User;
import ru.curoviyxru.j2vk.api.requests.friends.FriendsAdd;
import ru.curoviyxru.j2vk.api.requests.friends.FriendsDelete;
import ru.curoviyxru.j2vk.api.requests.groups.GroupsJoin;
import ru.curoviyxru.j2vk.api.requests.groups.GroupsLeave;
import ru.curoviyxru.j2vk.api.requests.messages.MessagesGetConversationsById;
import ru.curoviyxru.j2vk.api.requests.wall.WallGet;
import ru.curoviyxru.j2vk.api.responses.friends.FriendsAddResponse;
import ru.curoviyxru.j2vk.api.responses.friends.FriendsDeleteResponse;
import ru.curoviyxru.j2vk.api.responses.groups.GroupsJoinResponse;
import ru.curoviyxru.j2vk.api.responses.groups.GroupsLeaveResponse;
import ru.curoviyxru.j2vk.api.responses.messages.MessagesGetConversationsByIdResponse;
import ru.curoviyxru.j2vk.api.responses.wall.WallGetResponse;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.ConversationItem;
import ru.curoviyxru.phoenix.ui.Footer;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.PaneItem;
import ru.curoviyxru.phoenix.ui.PopupButton;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.ImageViewer;
import ru.curoviyxru.phoenix.ui.contents.NewsfeedContent;
import ru.curoviyxru.phoenix.ui.contents.PageInfoContent;
import ru.curoviyxru.phoenix.ui.contents.PostContent;
import ru.curoviyxru.phoenix.ui.contents.ScrollContent;

public class PageContent
extends ScrollContent
implements PostContent {
    Page page;
    int deleteFrom = 0;

    public PageContent(long l) {
        super(Localization.get("title.pageInformation"), false);
        this.noNext = true;
        PageStorage.load(l, "can_message,ban_info,can_write_private_message,can_see_audio,followers,friend_status,common_count,blacklisted,blacklisted_by_me,fixed_post,ban_info,members_count,counters,photo_50,photo_100,text,views,reposts,likes,status,sex,online,online_app,online_mobile,last_seen,first_name_nom,first_name_gen,first_name_dat,first_name_acc,first_name_ins,first_name_abl,last_name_nom,last_name_gen,last_name_dat,last_name_acc,last_name_ins,last_name_abl,screen_name,image_status,emoji_status,crop_photo,photo_50,photo_100,online,online_app,online_mobile,last_seen,sex,status,screen_name,occupation,description,activity,age_limits,bdate,education,contacts,home_town,country,city,interests,books,activities,about,connections,relation,movies,music,games,tv,quotes,personal,site");
        this.page = PageStorage.get(l);
        this.rightSoft.add(new PopupButton(Localization.get("action.showAvatar")){

            public void actionPerformed() {
                AppCanvas.instance.closePopup();
                AppCanvas.instance.goTo(ImageViewer.instance.setPhoto(PageContent.this.page.isGroup ? PageContent.this.page.asGroup().crop_photo : PageContent.this.page.asUser().crop_photo, null, null).parent(PageContent.this));
            }
        }.setIcon("new/account.rle"));
        this.setTitle("@" + this.page.getNickname());
        this.load();
    }

    public Content removeAll() {
        int n = this.deleteFrom;
        while (n < this.size()) {
            this.removeAt(n);
        }
        System.gc();
        return this;
    }

    public void addElement(PaneItem paneItem) {
        this.add(paneItem);
        ++this.deleteFrom;
    }

    public void process() {
        boolean bl;
        AppCanvas.instance.setProgress(true);
        boolean bl2 = bl = this.next == null;
        if (bl) {
            this.next = new Integer(-1);
        }
        this.next = new Integer((Integer)this.next + 1);
        WallGetResponse wallGetResponse = (WallGetResponse)new WallGet(this.page.getId(), 20, (Integer)this.next * 20).execute();
        if (wallGetResponse != null && wallGetResponse.hasItems()) {
            if (wallGetResponse.items.length < 20) {
                this.noNext = true;
            }
            for (int i = 0; i < wallGetResponse.items.length; ++i) {
                NewsfeedContent.addPost(this, wallGetResponse.items[i]);
            }
        } else {
            this.noNext = true;
            if (wallGetResponse == null) {
                AppCanvas.instance.dropError(Localization.get("general.loadError"));
            }
        }
        AppCanvas.instance.setProgress(false);
    }

    public void load() {
        this.loading = true;
        AppCanvas.instance.setProgress(true);
        if (this.page != null && this.page.isGroup) {
            this.loadGroupInfo();
        } else {
            this.loadUserInfo();
        }
        this.loading = false;
        AppCanvas.instance.setProgress(false);
        this.refresh();
    }

    private void loadGroupInfo() {
        final Group group = this.page.asGroup();
        if (!VKObject.isEmpty(group.deactivated)) {
            if (group.deactivated.equals("deleted")) {
                this.addElement(new Label(Localization.get("element.pageDeleted")));
            } else {
                this.addElement(new Label(Localization.get("element.pageBanned")));
            }
        } else {
            this.addElement(ContentController.getUserButton(group, false, true, true, true, this).setDescription(Localization.get("element.community")));
            if (!TextUtil.isNullOrEmpty(group.status)) {
                this.addElement(new Label(group.status).setFocusable(false).skipSelection(true));
            }
            if (group.blacklisted) {
                this.addElement(new Label(Localization.get("element.groupBlacklisted")));
            } else {
                if (!group.is_member && group.is_closed != 0) {
                    if (group.is_closed == 1) {
                        this.addElement(new Label(Localization.get("element.groupClosed")));
                    } else {
                        this.addElement(new Label(Localization.get("element.groupPrivate")));
                    }
                }
                if (group.is_member || group.is_closed != 2) {
                    String string = group.is_member ? Localization.get("action.leaveGroup") : (group.is_closed == 0 ? Localization.get("action.joinGroup") : (group.invited_by != 0 ? Localization.get("action.acceptInvitation") : Localization.get("action.sendRequest")));
                    this.addElement(new ListItem(string){

                        public void actionPerformed() {
                            if (group.is_member) {
                                GroupsLeaveResponse groupsLeaveResponse = (GroupsLeaveResponse)new GroupsLeave(group.getOriginalId()).execute();
                                if (groupsLeaveResponse != null) {
                                    if (groupsLeaveResponse.response) {
                                        this.setCaption(group.is_closed == 0 ? Localization.get("action.joinGroup") : Localization.get("action.sendRequest"));
                                        group.is_member = false;
                                        group.invited_by = 0;
                                        PageStorage.put(group);
                                        PageContent.this.page = group;
                                    }
                                } else {
                                    AppCanvas.instance.dropError(Localization.get("element.groupLeaveError"));
                                }
                            } else {
                                GroupsJoinResponse groupsJoinResponse = (GroupsJoinResponse)new GroupsJoin(group.getOriginalId()).execute();
                                if (groupsJoinResponse != null) {
                                    if (groupsJoinResponse.response) {
                                        this.setCaption(Localization.get("action.leaveGroup"));
                                        group.is_member = true;
                                        PageStorage.put(group);
                                        PageContent.this.page = group;
                                    }
                                } else {
                                    AppCanvas.instance.dropError(Localization.get("element.groupJoinError"));
                                }
                            }
                        }
                    }.setFont(true));
                }
                if (group.is_member || group.is_closed == 0) {
                    if (group.can_message) {
                        this.addElement(new ListItem(Localization.get("action.writeMessage")){

                            public void actionPerformed() {
                                MessagesGetConversationsByIdResponse messagesGetConversationsByIdResponse = (MessagesGetConversationsByIdResponse)new MessagesGetConversationsById().addPeerId(PageContent.this.page.getId()).execute();
                                if (messagesGetConversationsByIdResponse == null || !messagesGetConversationsByIdResponse.hasConversation()) {
                                    return;
                                }
                                ConversationItem.showConversation(PageContent.this, PageContent.this.page.getId());
                            }
                        }.setFont(true));
                    }
                    this.addElement(new ListItem(Localization.get("action.additionalInfo")){

                        public void actionPerformed() {
                            AppCanvas.instance.goTo(new PageInfoContent(PageContent.this.page).parent(PageContent.this));
                        }
                    }.setIcon("new/information.rle"));
                    if (group.albums_count > 0) {
                        this.addElement(new ListItem(Localization.get("title.albums"), 3){

                            public void actionPerformed() {
                                ContentController.showAlbums(PageContent.this.page.getId(), PageContent.this);
                            }
                        }.setIcon("new/image.rle").setTimestamp(PageContent.count(group.albums_count)).ignoreUnreadBackground(true));
                    }
                    if (group.audios_count > 0) {
                        this.addElement(new ListItem(Localization.get("elements.audios"), 3){

                            public void actionPerformed() {
                                ContentController.showTracks(PageContent.this, PageContent.this.page.getId());
                            }
                        }.setIcon("new/music-note.rle").setTimestamp(PageContent.count(group.audios_count)).ignoreUnreadBackground(true));
                    }
                    this.addElement(new Footer());
                    this.noNext = false;
                }
            }
        }
    }

    private void loadUserInfo() {
        final User user = this.page.asUser();
        if (!VKObject.isEmpty(user.deactivated)) {
            if (user.deactivated.equals("deleted")) {
                this.addElement(new Label(Localization.get("element.pageDeleted")));
            } else {
                this.addElement(new Label(Localization.get("element.pageBanned")));
            }
        } else {
            this.addElement(ContentController.getUserButton(user, false, true, true, true, this));
            if (!TextUtil.isNullOrEmpty(user.status)) {
                this.addElement(new Label(user.status).setFocusable(false).skipSelection(true));
            }
            if (user.blacklisted) {
                this.addElement(new Label(Localization.get("element.userBlacklisted")));
            } else {
                String string;
                switch (user.friend_status) {
                    case 3: {
                        string = Localization.get("action.removeFromFriends");
                        break;
                    }
                    case 2: {
                        string = Localization.get("action.acceptFriendsRequest");
                        break;
                    }
                    case 1: {
                        string = Localization.get("action.cancelFriendsRequest");
                        break;
                    }
                    default: {
                        string = Localization.get("action.addToFriends");
                    }
                }
                if (user.getId() != VKConstants.account.getId()) {
                    this.addElement(new ListItem(string){

                        public void actionPerformed() {
                            block0 : switch (user.friend_status) {
                                case 1: 
                                case 3: {
                                    FriendsDeleteResponse friendsDeleteResponse = (FriendsDeleteResponse)new FriendsDelete(user.getId()).execute();
                                    if (friendsDeleteResponse != null) {
                                        switch (friendsDeleteResponse.response) {
                                            case 10: {
                                                this.setCaption(Localization.get("action.acceptFriendsRequest"));
                                                user.friend_status = 2;
                                                PageStorage.put(user);
                                                PageContent.this.page = user;
                                                break block0;
                                            }
                                        }
                                        this.setCaption(Localization.get("action.addToFriends"));
                                        user.friend_status = 0;
                                        PageStorage.put(user);
                                        PageContent.this.page = user;
                                        break;
                                    }
                                    AppCanvas.instance.dropError(Localization.get("element.friendRemoveError"));
                                    break;
                                }
                                default: {
                                    FriendsAddResponse friendsAddResponse = (FriendsAddResponse)new FriendsAdd(user.getId()).execute();
                                    if (friendsAddResponse != null) {
                                        switch (friendsAddResponse.response) {
                                            case 1: 
                                            case 4: {
                                                this.setCaption(Localization.get("action.cancelFriendsRequest"));
                                                user.friend_status = 1;
                                                PageStorage.put(user);
                                                PageContent.this.page = user;
                                                break;
                                            }
                                            case 2: {
                                                this.setCaption(Localization.get("action.removeFromFriends"));
                                                user.friend_status = 3;
                                                PageStorage.put(user);
                                                PageContent.this.page = user;
                                            }
                                        }
                                        break;
                                    }
                                    AppCanvas.instance.dropError(Localization.get("element.friendSendError"));
                                }
                            }
                        }
                    }.setFont(true));
                }
                if (user.can_write_private_message && user.getId() != VKConstants.account.getId()) {
                    this.addElement(new ListItem(Localization.get("action.writeMessage")){

                        public void actionPerformed() {
                            MessagesGetConversationsByIdResponse messagesGetConversationsByIdResponse = (MessagesGetConversationsByIdResponse)new MessagesGetConversationsById().addPeerId(PageContent.this.page.getId()).execute();
                            if (messagesGetConversationsByIdResponse == null || !messagesGetConversationsByIdResponse.hasConversation()) {
                                return;
                            }
                            ConversationItem.showConversation(PageContent.this, PageContent.this.page.getId());
                        }
                    }.setFont(true));
                }
                this.addElement(new ListItem(Localization.get("action.additionalInfo")){

                    public void actionPerformed() {
                        AppCanvas.instance.goTo(new PageInfoContent(PageContent.this.page).parent(PageContent.this));
                    }
                }.setIcon("new/information.rle"));
                if (user.friends_count > 0) {
                    this.addElement(new ListItem(Localization.get("elements.friends"), 3){

                        public void actionPerformed() {
                            ContentController.showFriends(PageContent.this, PageContent.this.page.getId());
                        }
                    }.setIcon("new/account.rle").setTimestamp((user.online_friends > 0 ? PageContent.count(user.online_friends) + " / " : "") + PageContent.count(user.friends_count)).ignoreUnreadBackground(true));
                }
                if (user.groups_count > 0) {
                    this.addElement(new ListItem(Localization.get("elements.groups"), 3){

                        public void actionPerformed() {
                            ContentController.showGroups(PageContent.this, PageContent.this.page.getId());
                        }
                    }.setIcon("new/account-supervisor.rle").setTimestamp(PageContent.count(user.groups_count)).ignoreUnreadBackground(true));
                }
                if (user.albums_count > 0) {
                    this.addElement(new ListItem(Localization.get("title.albums"), 3){

                        public void actionPerformed() {
                            ContentController.showAlbums(PageContent.this.page.getId(), PageContent.this);
                        }
                    }.setIcon("new/image.rle").setTimestamp(PageContent.count(user.albums_count)).ignoreUnreadBackground(true));
                }
                if (user.audios_count > 0) {
                    this.addElement(new ListItem(Localization.get("elements.audios"), 3){

                        public void actionPerformed() {
                            ContentController.showTracks(PageContent.this, PageContent.this.page.getId());
                        }
                    }.setIcon("new/music-note.rle").setTimestamp(PageContent.count(user.audios_count)).ignoreUnreadBackground(true));
                }
                this.addElement(new Footer());
                this.noNext = false;
            }
        }
    }

    public static String getFollowersString(int n) {
        int n2 = n % 100 / 10;
        if (n2 == 1) {
            return Localization.get("element.followersCount", n + "");
        }
        switch (n % 10) {
            case 1: {
                return Localization.get("element.followersCountOne", n + "");
            }
            case 2: 
            case 3: 
            case 4: {
                return Localization.get("element.followersCountSome", n + "");
            }
        }
        return Localization.get("element.followersCount", n + "");
    }

    public static String count(int n) {
        return PageContent.count(n, false);
    }

    public static String count(int n, boolean bl) {
        return n == 0 ? (bl ? "0" : "") : (n < 10000 ? n + "" : (n < 1000000 ? n / 1000 + "K" : n / 1000000 + "M"));
    }

    public static String getTimeActionString(int n) {
        long l = System.currentTimeMillis() / 1000L / 86400L - (long)(n / 86400);
        return l > 1L ? Localization.get("general.dateAt", VKObject.dateToString(n), VKObject.onlyTimeToString(n)) : Localization.get(l == 1L ? "general.yesterdayAt" : "general.todayAt", VKObject.onlyTimeToString(n));
    }

    public static String getLastSeenString(boolean bl, int n) {
        return Localization.get("element.lastSeen" + (bl ? "Male" : "Female"), PageContent.getTimeActionString(n));
    }

    public void addPostItem(PaneItem paneItem) {
        this.add(paneItem);
    }
}

