/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import org.json.me.JSONArray;
import ru.curoviyxru.j2vk.PageStorage;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.j2vk.api.objects.user.Group;
import ru.curoviyxru.j2vk.api.objects.user.Page;
import ru.curoviyxru.j2vk.api.objects.user.User;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.contents.ContentController;

public class PageInfoContent
extends Content {
    Page page;

    public PageInfoContent(Page page) {
        super(Localization.get("title.additionalInfo"));
        PageStorage.load(page.getId(), "can_message,ban_info,can_write_private_message,can_see_audio,followers,friend_status,common_count,blacklisted,blacklisted_by_me,fixed_post,ban_info,members_count,counters,photo_50,photo_100,text,views,reposts,likes,status,sex,online,online_app,online_mobile,last_seen,first_name_nom,first_name_gen,first_name_dat,first_name_acc,first_name_ins,first_name_abl,last_name_nom,last_name_gen,last_name_dat,last_name_acc,last_name_ins,last_name_abl,screen_name,image_status,emoji_status,crop_photo,photo_50,photo_100,online,online_app,online_mobile,last_seen,sex,status,screen_name,occupation,description,activity,age_limits,bdate,education,contacts,home_town,country,city,interests,books,activities,about,connections,relation,movies,music,games,tv,quotes,personal,site");
        this.page = PageStorage.get(page.getId());
        if (this.page != null) {
            this.setTitle("@" + this.page.getNickname());
            if (this.page.isGroup) {
                this.loadGroupInfo();
            } else {
                this.loadUserInfo();
            }
        }
    }

    public void loadGroupInfo() {
        final Group group = this.page.asGroup();
        if (!VKObject.isEmpty(group.activity)) {
            this.add(new Label(Localization.get("element.activity")).setFont(true));
            this.add(new Label(group.activity));
        }
        if (group.age_limits != 0) {
            this.add(new Label(Localization.get("element.age_limits")).setFont(true));
            this.add(new Label(Localization.get("ageLimits." + (group.age_limits == 2 ? "sixteen" : (group.age_limits == 3 ? "eighteen" : "none")))));
        }
        if (!VKObject.isEmpty(group.description)) {
            this.add(new Label(Localization.get("element.description")).setFont(true));
            this.add(new Label(group.description));
        }
        if (!VKObject.isEmpty(group.site)) {
            this.add(new Label(Localization.get("element.site")).setFont(true));
            this.add(new ListItem(group.site, 2){

                public void actionPerformed() {
                    Midlet.goLink(group.site);
                }
            });
        }
        if (!VKObject.isEmpty(group.country_title)) {
            this.add(new Label(Localization.get("element.country_title")).setFont(true));
            this.add(new Label(group.country_title));
        }
        if (!VKObject.isEmpty(group.city_title)) {
            this.add(new Label(Localization.get("element.city_title")).setFont(true));
            this.add(new Label(group.city_title));
        }
    }

    public void loadUserInfo() {
        String string;
        Object object;
        final User user = this.page.asUser();
        if (!VKObject.isEmpty(user.bdate)) {
            this.add(new Label(Localization.get("element.bdate")).setFont(true));
            this.add(new Label(user.bdate));
        }
        if (!VKObject.isEmpty(user.about)) {
            this.add(new Label(Localization.get("element.about")).setFont(true));
            this.add(new Label(user.about));
        }
        if (!VKObject.isEmpty(user.mobile_phone)) {
            this.add(new Label(Localization.get("element.mobile_phone")).setFont(true));
            this.add(new Label(user.mobile_phone));
        }
        if (!VKObject.isEmpty(user.home_phone)) {
            this.add(new Label(Localization.get("element.home_phone")).setFont(true));
            this.add(new Label(user.home_phone));
        }
        if (!VKObject.isEmpty(user.site)) {
            this.add(new Label(Localization.get("element.site")).setFont(true));
            this.add(new ListItem(user.site, 2){

                public void actionPerformed() {
                    Midlet.goLink(user.site);
                }
            });
        }
        if (!VKObject.isEmpty(user.occupation_name) && !VKObject.isEmpty(user.occupation_type)) {
            this.add(new Label(Localization.get("element.occupation")).setFont(true));
            this.add(new Label(Localization.get("occupation." + user.occupation_type) + ", " + user.occupation_name));
        }
        String string2 = "";
        if (!VKObject.isEmpty(user.university_name)) {
            string2 = string2 + user.university_name;
        }
        if (!VKObject.isEmpty(user.faculty_name)) {
            if (string2.length() != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + user.faculty_name;
        }
        if (user.graduation != 0) {
            if (string2.length() != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + user.graduation;
        }
        if (string2.length() != 0) {
            this.add(new Label(Localization.get("element.education")).setFont(true));
            this.add(new Label(string2));
        }
        if (user.connections != null && user.connections.length() > 0) {
            this.add(new Label(Localization.get("element.connections")).setFont(true));
            String string3 = "";
            object = user.connections.keys();
            while (object.hasMoreElements()) {
                String string4;
                string = (String)object.nextElement();
                if (string == null || (string4 = user.connections.optString(string)) == null) continue;
                string3 = string3 + string + ": " + string4;
            }
            this.add(new Label(string3));
        }
        if (user.relation != 0) {
            this.add(new Label(Localization.get("element.relation")).setFont(true));
            this.add(new Label(Localization.get("relation." + String.valueOf(user.relation))));
            if (user.relation_partner_id != 0) {
                this.add(ContentController.getUserButton(PageStorage.get(user.relation_partner_id), false, false, false, false, this));
            }
        }
        if (!VKObject.isEmpty(user.country_title)) {
            this.add(new Label(Localization.get("element.country_title")).setFont(true));
            this.add(new Label(user.country_title));
        }
        if (!VKObject.isEmpty(user.city_title)) {
            this.add(new Label(Localization.get("element.city_title")).setFont(true));
            this.add(new Label(user.city_title));
        }
        if (!VKObject.isEmpty(user.home_town)) {
            this.add(new Label(Localization.get("element.home_town")).setFont(true));
            this.add(new Label(user.home_town));
        }
        if (user.personal != null) {
            int n;
            int n2;
            int n3;
            int n4;
            String string5;
            this.add(new Label(Localization.get("element.personal")).setFont(true));
            int n5 = user.personal.optInt("political");
            if (n5 != 0) {
                this.add(new Label(Localization.get("element.political")).setFont(true));
                this.add(new Label(Localization.get("political." + String.valueOf(n5))));
            }
            if ((object = user.personal.optJSONArray("langs")) != null && ((JSONArray)object).length() != 0) {
                string = "";
                for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                    String string6 = ((JSONArray)object).optString(i);
                    if (string6 == null) continue;
                    if (string.length() != 0) {
                        string = string + ", ";
                    }
                    string = string + string6;
                }
                if (string.length() != 0) {
                    this.add(new Label(Localization.get("element.langs")).setFont(true));
                    this.add(new Label(string));
                }
            }
            if (!VKObject.isEmpty(string = user.personal.optString("religion"))) {
                this.add(new Label(Localization.get("element.religion")).setFont(true));
                this.add(new Label(string));
            }
            if (!VKObject.isEmpty(string5 = user.personal.optString("inspired_by"))) {
                this.add(new Label(Localization.get("element.inspiredBy")).setFont(true));
                this.add(new Label(string5));
            }
            if ((n4 = user.personal.optInt("people_main")) != 0) {
                this.add(new Label(Localization.get("element.people_main")).setFont(true));
                this.add(new Label(Localization.get("people_main." + String.valueOf(n4))));
            }
            if ((n3 = user.personal.optInt("life_main")) != 0) {
                this.add(new Label(Localization.get("element.life_main")).setFont(true));
                this.add(new Label(Localization.get("life_main." + String.valueOf(n3))));
            }
            if ((n2 = user.personal.optInt("smoking")) != 0) {
                this.add(new Label(Localization.get("element.smoking")).setFont(true));
                this.add(new Label(Localization.get("attitude." + String.valueOf(n2))));
            }
            if ((n = user.personal.optInt("alcohol")) != 0) {
                this.add(new Label(Localization.get("element.alcohol")).setFont(true));
                this.add(new Label(Localization.get("attitude." + String.valueOf(n))));
            }
        }
        if (!VKObject.isEmpty(user.interests)) {
            this.add(new Label(Localization.get("element.interests")).setFont(true));
            this.add(new Label(user.interests));
        }
        if (!VKObject.isEmpty(user.activities)) {
            this.add(new Label(Localization.get("element.activities")).setFont(true));
            this.add(new Label(user.activities));
        }
        if (!VKObject.isEmpty(user.books)) {
            this.add(new Label(Localization.get("element.books")).setFont(true));
            this.add(new Label(user.books));
        }
        if (!VKObject.isEmpty(user.tv)) {
            this.add(new Label(Localization.get("element.tv")).setFont(true));
            this.add(new Label(user.tv));
        }
        if (!VKObject.isEmpty(user.movies)) {
            this.add(new Label(Localization.get("element.movies")).setFont(true));
            this.add(new Label(user.movies));
        }
        if (!VKObject.isEmpty(user.music)) {
            this.add(new Label(Localization.get("element.music")).setFont(true));
            this.add(new Label(user.music));
        }
        if (!VKObject.isEmpty(user.games)) {
            this.add(new Label(Localization.get("element.games")).setFont(true));
            this.add(new Label(user.games));
        }
        if (!VKObject.isEmpty(user.quotes)) {
            this.add(new Label(Localization.get("element.quotes")).setFont(true));
            this.add(new Label(user.quotes));
        }
    }
}

