/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.phoenix.ui.contents;

import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.api.objects.VKObject;
import ru.curoviyxru.phoenix.Localization;
import ru.curoviyxru.phoenix.Theming;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.AppCanvas;
import ru.curoviyxru.phoenix.ui.Content;
import ru.curoviyxru.phoenix.ui.Footer;
import ru.curoviyxru.phoenix.ui.Label;
import ru.curoviyxru.phoenix.ui.ListItem;
import ru.curoviyxru.phoenix.ui.Slider;
import ru.curoviyxru.phoenix.ui.contents.ContentController;
import ru.curoviyxru.phoenix.ui.contents.settings.AboutSettings;
import ru.curoviyxru.phoenix.ui.contents.settings.BehaviorSettings;
import ru.curoviyxru.phoenix.ui.contents.settings.InterfaceSettings;
import ru.curoviyxru.phoenix.ui.contents.settings.LocalizationSettings;

public class SettingsContent
extends Content {
    public static boolean hasUpdate = SettingsContent.checkUpdate();
    public static String newVersion;

    private static boolean checkUpdate() {
        try {
            String string = HTTPClient.getURLString("http://vk4me.crx.moe/next/latest");
            if (!VKObject.isEmpty(string) && string.indexOf("Not Found") == -1 && string.indexOf("Moved") == -1 && string.compareTo(Midlet.instance.version) != 0) {
                newVersion = string;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        newVersion = null;
        return false;
    }

    public SettingsContent(final boolean bl) {
        super(Localization.get("title.settings"));
        this.add(new ListItem(Localization.get("element.interface"), 2){

            public void actionPerformed() {
                new InterfaceSettings().parent(SettingsContent.this);
            }
        }.setIcon("new/image.rle").separatorAfter(true));
        this.add(new ListItem(Localization.get("element.behavior"), 2){

            public void actionPerformed() {
                new BehaviorSettings(bl).parent(SettingsContent.this);
            }
        }.setIcon("new/widgets.rle").separatorAfter(true));
        this.add(new ListItem(Localization.get("element.localization"), 2){

            public void actionPerformed() {
                new LocalizationSettings().parent(SettingsContent.this);
            }
        }.setIcon("new/translate.rle"));
        this.add(new Footer());
        ListItem listItem = (ListItem)new ListItem(Localization.get("element.aboutApp"), 3){

            public void actionPerformed() {
                new AboutSettings(bl).parent(SettingsContent.this);
            }
        }.setIcon("new/information.rle").ignoreUnreadBackground(true).separatorAfter(true);
        this.add(listItem);
        if (hasUpdate) {
            listItem.setTimestamp(Localization.get("event.updateAvaliable"));
        }
        if (bl) {
            this.add(new ListItem(Localization.get("action.logOut")){

                public void actionPerformed() {
                    ContentController.logout();
                }
            }.setFont(true).setIcon("new/exit-to-app.rle").separatorAfter(true));
        }
        try {
            if (Class.forName("com.nokia.mid.ui.DeviceControl") != null) {
                final Label label = (Label)new Label(Localization.get("settings.brightness", Midlet.instance.config.brightness == 0 ? Localization.get("element.system") : Midlet.instance.config.brightness + "")).skipSelection(true);
                this.add(label);
                Slider slider = (Slider)new Slider(Midlet.instance.config.brightness){

                    public void valueChanged(long l, long l2) {
                        String string;
                        Midlet.instance.config.brightness = (int)l2;
                        if (Midlet.instance.config.brightness == 0) {
                            string = Localization.get("element.system");
                        } else {
                            Midlet.instance.config.brightness = (int)l2;
                            string = Midlet.instance.config.brightness + "";
                        }
                        label.setText(Localization.get("settings.brightness", string));
                        Midlet.instance.config.post();
                    }
                }.setMaxProgress(100L);
                this.add(slider);
            } else {
                Midlet.instance.config.brightness = 0;
                Midlet.instance.config.post();
            }
        }
        catch (Throwable throwable) {
            Midlet.instance.config.brightness = 0;
            Midlet.instance.config.post();
        }
        this.add(new Label(Localization.get("element.settingsRestartDisclaimer")).setAlign(1).setColor(Theming.now.captionColor).skipSelection(false));
        AppCanvas.instance.goTo(this);
    }
}

